/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.youxi.auth.game.service;

import com.xunlei.youxi.core.config.DynamicConfig;
import com.xunlei.youxi.core.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebGameKey {
    protected static Logger logger = Logger.getLogger(WebGameKey.class);
    private static Map<String, byte[]> keyMap = new HashMap<String, byte[]>(256);
    private static String ConfigName = "web-game-key.properties";
    public static WebGameKey instance = new WebGameKey(ConfigName);
    private DynamicConfig.Config config = null;

    public WebGameKey(String fileName) {
        this.config = DynamicConfig.getInstance().newConfig(fileName);
    }

    public byte[] getPrivateKey(String gameid) {
        String key = String.valueOf(gameid) + "_privateKey";
        String keyValue = this.config.getValue(key);
        if (StringUtils.isEmpty((String)keyValue)) {
            return null;
        }
        byte[] keyByte = keyMap.get(key);
        if (keyByte == null) {
            String[] keyArr = keyValue.split(",");
            keyByte = new byte[keyArr.length];
            int i = 0;
            while (i < keyArr.length) {
                keyByte[i] = Byte.parseByte(keyArr[i]);
                ++i;
            }
            keyMap.put(key, keyByte);
        }
        return keyByte;
    }

    public byte[] getPublicKey(String gameid) {
        String key = String.valueOf(gameid) + "_publicKey";
        String keyValue = this.config.getValue(key);
        if (StringUtils.isEmpty((String)keyValue)) {
            return null;
        }
        byte[] keyByte = keyMap.get(key);
        if (keyByte == null) {
            String[] keyArr = keyValue.split(",");
            keyByte = new byte[keyArr.length];
            int i = 0;
            while (i < keyArr.length) {
                keyByte[i] = Byte.parseByte(keyArr[i]);
                ++i;
            }
            keyMap.put(key, keyByte);
        }
        return keyByte;
    }
}

