/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.youxi.auth.game.service;

import com.xunlei.authserver.client.ServerLoginProxy;
import com.xunlei.authserver.client.ServerLoginReturnMsg;
import com.xunlei.youxi.auth.game.entry.ServerLoginReq;
import com.xunlei.youxi.auth.game.entry.ServerLoginResp;
import com.xunlei.youxi.auth.game.exception.AuthGameParameterException;
import com.xunlei.youxi.auth.game.exception.AuthGameProcessException;
import com.xunlei.youxi.auth.game.exception.AuthGameVerifyException;
import com.xunlei.youxi.auth.game.service.WebGameKey;
import com.xunlei.youxi.core.util.GameIdConverter;
import org.apache.log4j.Logger;

public class ServerLoginService {
    protected static Logger logger = Logger.getLogger(ServerLoginService.class);

    public static ServerLoginResp verify(ServerLoginReq req) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        if (!req.isValid()) {
            throw new AuthGameParameterException();
        }
        byte[] publicKey = WebGameKey.instance.getPublicKey(req.getGameid());
        byte[] privateKey = WebGameKey.instance.getPrivateKey(req.getGameid());
        return ServerLoginService.verify(req, publicKey, privateKey);
    }

    public static ServerLoginResp verify(ServerLoginReq req, byte[] publicKey, byte[] privateKey) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        if (!req.isValid() || publicKey == null || privateKey == null) {
            throw new AuthGameParameterException();
        }
        try {
            ServerLoginProxy proxy = new ServerLoginProxy(GameIdConverter.toServerGameid((String)req.getGameid()), publicKey, req.getHost(), req.getPort(), privateKey);
            ServerLoginReturnMsg rtn = proxy.serverLogin(req.getSign(), req.getUsername(), req.getPassword(), req.getServerid(), req.getPeerid(), req.getIp(), req.getClientid());
            if (rtn == null) {
                throw new AuthGameVerifyException("Null ServerLoginReturnMsg");
            }
            ServerLoginResp resp = new ServerLoginResp();
            resp.setReturnCode(rtn.getReturnCode());
            if ("0000".equals(rtn.getReturnCode())) {
                resp.setCustomerId(((String)rtn.getPropertyMap().get("customerId")).trim());
                resp.setAdultFalg((String)rtn.getPropertyMap().get("adultFalg"));
                resp.setMibaokaFlag((String)rtn.getPropertyMap().get("mibaokaFlag"));
                resp.setGameVip((String)rtn.getPropertyMap().get("gameVip"));
                resp.setGameVipEndDate((String)rtn.getPropertyMap().get("gameVipEndDate"));
                resp.setFcmTime((String)rtn.getPropertyMap().get("fcmTime"));
                resp.setXunleiVip((String)rtn.getPropertyMap().get("xunleiVip"));
                resp.setXunleiLevel((String)rtn.getPropertyMap().get("xunleiLevel"));
                resp.setSexFalg((String)rtn.getPropertyMap().get("sexFalg"));
                resp.setPickUp((String)rtn.getPropertyMap().get("pickUp"));
                resp.setExperience((String)rtn.getPropertyMap().get("experience"));
                resp.setBarPrivilege((String)rtn.getPropertyMap().get("barPrivilege"));
            }
            logger.info((Object)("ServerLoginService," + rtn.getReturnCode() + "," + req.getUsername() + "," + req.getGameid() + "," + req.getServerid() + "," + req.getIp() + "," + resp.getCustomerId()));
            return resp;
        }
        catch (Exception e) {
            throw new AuthGameProcessException("serverLogin", e);
        }
    }

    public static String verifyLY(ServerLoginReq req, byte[] publicKey, byte[] privateKey) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        if (!req.isValid() || publicKey == null || privateKey == null) {
            throw new AuthGameParameterException();
        }
        try {
            ServerLoginProxy proxy = new ServerLoginProxy(GameIdConverter.toServerGameid((String)req.getGameid()), publicKey, req.getHost(), req.getPort(), privateKey);
            String rtn = proxy.serverLYLogin(req.getSign(), req.getUsername(), req.getPassword(), req.getServerid(), req.getPeerid(), req.getIp(), req.getClientid());
            if (rtn == null) {
                throw new AuthGameVerifyException("Null ServerLoginReturnMsg");
            }
            logger.info((Object)("server login,verifyLY," + req.getUsername() + "," + req.getGameid() + "," + req.getServerid() + "," + req.getIp()));
            return rtn;
        }
        catch (Exception e) {
            throw new AuthGameProcessException("serverLogin,verifyLY", e);
        }
    }
}

