/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.youxi.auth.game.service;

import com.xunlei.youxi.auth.game.entry.GameLoginReq;
import com.xunlei.youxi.auth.game.entry.GameLoginResp;
import com.xunlei.youxi.auth.game.entry.ServerLoginReq;
import com.xunlei.youxi.auth.game.exception.AuthGameParameterException;
import com.xunlei.youxi.auth.game.exception.AuthGameProcessException;
import com.xunlei.youxi.auth.game.exception.AuthGameVerifyException;
import com.xunlei.youxi.auth.game.service.GameLoginService;
import com.xunlei.youxi.auth.game.service.ServerLoginService;
import com.xunlei.youxi.auth.game.service.WebGameFilter;
import com.xunlei.youxi.auth.game.service.WebGameKey;
import com.xunlei.youxi.core.util.ResultCode;
import com.xunlei.youxi.core.util.StringUtils;
import org.apache.log4j.Logger;

public class GameLoginPwd
implements GameLoginService {
    protected static Logger logger = Logger.getLogger(GameLoginPwd.class);

    public GameLoginResp verify(GameLoginReq req) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        byte[] publicKey = WebGameKey.instance.getPublicKey(req.getGameid());
        byte[] privateKey = WebGameKey.instance.getPrivateKey(req.getGameid());
        return this.verify(req, publicKey, privateKey);
    }

    public GameLoginResp verify(GameLoginReq req, byte[] publicKey, byte[] privateKey) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        if (!WebGameFilter.instance.filterPwd(req.getGameid())) {
            logger.debug((Object)("GameLoginPwd,filter gameid," + req.getGameid()));
            return null;
        }
        if (!req.isValid() || publicKey == null || privateKey == null) {
            throw new AuthGameParameterException();
        }
        ServerLoginReq serverLoginReq = new ServerLoginReq();
        serverLoginReq.setGameid(req.getGameid());
        serverLoginReq.setUsername(req.getUsername());
        serverLoginReq.setPassword(req.getPassword());
        serverLoginReq.setServerid(req.getServerid());
        serverLoginReq.setSign(req.getSign());
        serverLoginReq.setHost(WebGameFilter.instance.getHostPwd(req.getSvrflag(), req.getGameid()));
        serverLoginReq.setPort(WebGameFilter.instance.getPortPwd(req.getSvrflag(), req.getGameid()));
        serverLoginReq.setClientid(req.getClientid());
        String postrtn = ServerLoginService.verifyLY(serverLoginReq, publicKey, privateKey);
        if (StringUtils.isEmpty((String)postrtn)) {
            logger.error((Object)("GameLoginPwd,empty result," + req.getUsername() + "," + req.getGameid() + "," + req.getServerid() + "," + req.getIp()));
            throw new AuthGameVerifyException(postrtn);
        }
        GameLoginResp resp = new GameLoginResp();
        String returnCode = postrtn.substring(postrtn.indexOf(61) + 1, postrtn.indexOf(44));
        String loginUrl = postrtn.substring(postrtn.lastIndexOf("loginUrl=") + 9);
        if ("0000".equals(returnCode)) {
            resp.setResult(ResultCode.AuthGameSucc.getResult());
            resp.setUrl(loginUrl);
            logger.info((Object)("GameLoginPwd,succ," + req.getUsername() + "," + req.getGameid() + "," + req.getServerid() + "," + req.getIp() + "," + resp.getUrl()));
        } else {
            resp.setResult(ResultCode.AuthGameFail.getResult());
            logger.error((Object)("GameLoginPwd,fail return code," + req.getUsername() + "," + req.getGameid() + "," + req.getServerid() + "," + req.getIp() + "," + postrtn));
        }
        return resp;
    }
}

