/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.youxi.auth.game.service;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.xunlei.server.common.exception.AESException;
import com.xunlei.server.common.util.AESUtil;
import com.xunlei.youxi.auth.game.entry.GameLoginReq;
import com.xunlei.youxi.auth.game.entry.GameLoginResp;
import com.xunlei.youxi.auth.game.exception.AuthGameParameterException;
import com.xunlei.youxi.auth.game.exception.AuthGameProcessException;
import com.xunlei.youxi.auth.game.exception.AuthGameVerifyException;
import com.xunlei.youxi.auth.game.service.GameLoginService;
import com.xunlei.youxi.auth.game.service.WebGameFilter;
import com.xunlei.youxi.auth.game.service.WebGameKey;
import com.xunlei.youxi.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class GameLoginCopartner
implements GameLoginService {
    protected static Logger logger = Logger.getLogger(GameLoginCopartner.class);

    public GameLoginResp verify(GameLoginReq req) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        byte[] publicKey = WebGameKey.instance.getPublicKey(req.getGameid());
        byte[] privateKey = WebGameKey.instance.getPrivateKey(req.getGameid());
        return this.verify(req, publicKey, privateKey);
    }

    public GameLoginResp verify(GameLoginReq req, byte[] publicKey, byte[] privateKey) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        if (!WebGameFilter.instance.filter(req.getGameid())) {
            logger.debug((Object)("GameLoginCopartner,filter gameid," + req.getGameid()));
            return null;
        }
        if (!req.isValid() || publicKey == null || privateKey == null) {
            throw new AuthGameParameterException();
        }
        try {
            byte[] securityData = this.buildSecurityData(req.getUsername(), req.getPassword(), req.getIp(), req.getGameid(), req.getServerid(), req.getSign(), publicKey, privateKey);
            String postUrl = this.buildPostUrl(req.getServerurl());
            logger.debug((Object)("postUrl=" + postUrl));
            String postParameter = this.buildPostParameter(req, securityData);
            logger.debug((Object)("postParameter=" + postParameter));
            String postrtn = this.post(postUrl, postParameter);
            logger.debug((Object)("postrtn=" + postrtn));
            if (StringUtils.isEmpty((String)postrtn)) {
                logger.error((Object)("GameLoginService,empty post result," + postParameter + "," + postrtn));
                throw new AuthGameVerifyException(postrtn);
            }
            if (postrtn.indexOf("result=") < 0 || postrtn.indexOf("url=") < 0) {
                logger.error((Object)("GameLoginService,undefine post result," + postUrl + "," + postParameter + "," + postrtn));
            }
            GameLoginResp resp = new GameLoginResp();
            resp.setResult(Integer.valueOf(postrtn.substring(postrtn.indexOf(61) + 1, postrtn.indexOf(59))));
            resp.setUrl(postrtn.substring(postrtn.lastIndexOf("url=") + 4));
            logger.info((Object)("GameLoginService,succ," + req.getUsername() + "," + req.getGameid() + "," + req.getServerid() + "," + req.getIp() + "," + resp.getUrl()));
            return resp;
        }
        catch (AESException e) {
            throw new AuthGameProcessException("buildSecurityData", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthGameProcessException("buildPostParameter", e);
        }
        catch (IOException e) {
            throw new AuthGameProcessException("post", e);
        }
    }

    protected String post(String postUrl, String postParameter) throws IOException {
        String tline;
        StringBuilder sb = new StringBuilder();
        URL url = new URL(postUrl);
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(20000);
        conn.setReadTimeout(20000);
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(postParameter);
        wr.flush();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((tline = rd.readLine()) != null) {
            sb.append(tline);
        }
        return sb.toString();
    }

    protected String buildPostUrl(String loginURL) {
        if (loginURL.indexOf("?") >= 0) {
            loginURL = loginURL.substring(0, loginURL.indexOf("?"));
            return loginURL;
        }
        return loginURL;
    }

    protected String buildPostParameter(GameLoginReq req, byte[] securityData) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (req.getServerurl().indexOf("?") != -1) {
            sb.append(req.getServerurl().substring(req.getServerurl().indexOf("?") + 1, req.getServerurl().length()));
        }
        String value = URLEncoder.encode(Base64.encode(securityData), "UTF8");
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append("userinfo=").append(value);
        sb.append("&svrflag=").append(req.getSvrflag());
        sb.append("&serverid=").append(req.getServerid());
        return sb.toString();
    }

    protected byte[] buildSecurityData(String username, String password, String ip, String gameid, String serverid, String sign, byte[] userinfokey, byte[] cooperateserverkey) throws AESException {
        byte[] userPac = new byte[96];
        byte[] cooperateServerPac = new byte[110];
        Object key1 = AESUtil.makeKey((byte[])userinfokey);
        Object key2 = AESUtil.makeKey((byte[])cooperateserverkey);
        Arrays.fill(userPac, (byte)32);
        Arrays.fill(cooperateServerPac, (byte)32);
        this.copyBytes(sign.getBytes(), userPac, 0);
        this.copyBytes(username.getBytes(), userPac, 4);
        this.copyBytes(password.getBytes(), userPac, 36);
        this.copyBytes(StringUtils.intToByteArray((int)Integer.valueOf(serverid)), userPac, 68);
        this.copyBytes("0".getBytes(), userPac, 72);
        String[] ipStrings = ip.split("\\.");
        byte[] ipBytes = new byte[ipStrings.length];
        int i = 0;
        while (i < ipStrings.length) {
            try {
                int temp = Integer.parseInt(ipStrings[i]);
                ipBytes[i] = (byte)temp;
            }
            catch (Exception e) {
                ipBytes[i] = 0;
            }
            ++i;
        }
        this.copyBytes(ipBytes, userPac, 88);
        this.copyBytes(AESUtil.encrypt((byte[])userPac, (Object)key1), cooperateServerPac, 0);
        this.copyBytes(this.formatServerid(serverid), cooperateServerPac, 100);
        return AESUtil.encrypt((byte[])cooperateServerPac, (Object)key2);
    }

    private void copyBytes(byte[] src, byte[] desc, int descStart) {
        int j = 0;
        while (j < src.length) {
            desc[descStart + j] = src[j];
            ++j;
        }
    }

    private byte[] formatServerid(String serverid) {
        byte[] server = serverid.getBytes();
        byte[] serverPac = new byte[10];
        Arrays.fill(serverPac, (byte)32);
        this.copyBytes(server, serverPac, serverPac.length - server.length);
        return serverPac;
    }
}

