/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.youxi.auth.game.service;

import com.xunlei.youxi.auth.game.entry.GameLoginReq;
import com.xunlei.youxi.auth.game.entry.GameLoginResp;
import com.xunlei.youxi.auth.game.entry.ServerLoginReq;
import com.xunlei.youxi.auth.game.entry.ServerLoginResp;
import com.xunlei.youxi.auth.game.exception.AuthGameParameterException;
import com.xunlei.youxi.auth.game.exception.AuthGameProcessException;
import com.xunlei.youxi.auth.game.exception.AuthGameVerifyException;
import com.xunlei.youxi.auth.game.service.GameLoginService;
import com.xunlei.youxi.auth.game.service.ServerLoginService;
import com.xunlei.youxi.auth.game.service.WebGameFilter;
import com.xunlei.youxi.auth.game.service.WebGameKey;
import com.xunlei.youxi.core.util.DatetimeUtils;
import com.xunlei.youxi.core.util.ResultCode;
import com.xunlei.youxi.core.util.StringUtils;
import org.apache.log4j.Logger;

public class GameLogin000066
implements GameLoginService {
    protected static Logger logger = Logger.getLogger(GameLogin000066.class);

    public GameLoginResp verify(GameLoginReq req) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        byte[] publicKey = WebGameKey.instance.getPublicKey(req.getGameid());
        byte[] privateKey = WebGameKey.instance.getPrivateKey(req.getGameid());
        return this.verify(req, publicKey, privateKey);
    }

    public GameLoginResp verify(GameLoginReq req, byte[] publicKey, byte[] privateKey) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        if (!WebGameFilter.instance.filterGameid(req.getGameid())) {
            logger.debug((Object)("GameLogin000066,filter gameid," + req.getGameid()));
            return null;
        }
        if (!req.isValid() || publicKey == null || privateKey == null) {
            throw new AuthGameParameterException();
        }
        GameLoginResp resp = new GameLoginResp();
        ServerLoginReq serverLoginReq = new ServerLoginReq();
        serverLoginReq.setGameid(req.getGameid());
        serverLoginReq.setUsername(req.getUsername());
        serverLoginReq.setPassword(req.getPassword());
        serverLoginReq.setServerid(req.getServerid());
        serverLoginReq.setSign(req.getSign());
        serverLoginReq.setHost(WebGameFilter.instance.getHost(req.getSvrflag(), req.getGameid()));
        serverLoginReq.setPort(WebGameFilter.instance.getPort(req.getSvrflag(), req.getGameid()));
        ServerLoginResp serverLoginResp = ServerLoginService.verify(serverLoginReq, publicKey, privateKey);
        if (!serverLoginResp.succ()) {
            resp.setResult(ResultCode.AuthGameFail.getResult());
            logger.error((Object)("GameLogin000066,fail server login," + serverLoginResp.getReturnCode() + "," + req.getUsername() + "," + req.getServerid() + "," + req.getIp()));
            return resp;
        }
        StringBuilder url = new StringBuilder();
        url.append(req.getServerurl());
        url.append("?user_id=").append(serverLoginResp.getCustomerId());
        url.append("&server_id=").append(req.getServerid());
        String cm_flag = "y";
        url.append("&cm_flag=").append(cm_flag);
        String timestamp = DatetimeUtils.now();
        url.append("&timestamp=").append(timestamp);
        String sign = StringUtils.encodeMD5((String)(String.valueOf(WebGameFilter.instance.getSignkey(req.getGameid())) + "cm_flag" + cm_flag + "server_id" + req.getServerid() + "timestamp" + timestamp + "user_id" + serverLoginResp.getCustomerId()));
        url.append("&sign=").append(sign.toUpperCase());
        resp.setResult(ResultCode.AuthGameSucc.getResult());
        resp.setUrl(url.toString());
        logger.info((Object)("GameLogin000066,succ," + req.getUsername() + "," + req.getGameid() + "," + req.getServerid() + "," + req.getIp() + "," + resp.getUrl()));
        return resp;
    }
}

