/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.util;

import com.xunlei.frame.netty.common.CommonCoder;
import com.xunlei.frame.netty.common.ServerRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class SocketUtil {
    private static final int CACHE_SIZE = 2048;
    private static final int DEFAULT_TIMEOUT = 5000;

    public static byte[] sendShortLinkRequest(String ip, int port, int timeout, byte[] request) throws IOException {
        Socket socket = null;
        byte[] ret = null;
        InputStream in = null;
        OutputStream out = null;
        ByteArrayOutputStream baos = null;
        try {
            int length;
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setTcpNoDelay(true);
            socket.setSoLinger(false, -1);
            socket.setKeepAlive(false);
            socket.setSoTimeout(timeout);
            socket.connect(new InetSocketAddress(ip, port), timeout);
            out = socket.getOutputStream();
            in = socket.getInputStream();
            if (request != null && request.length > 0) {
                out.write(request);
                out.flush();
            }
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[2048];
            while ((length = in.read(buf)) != -1) {
                baos.write(buf, 0, length);
            }
            ret = baos.toByteArray();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        return ret;
    }

    public static boolean isLongLink(String ip, int port, byte[] request) throws IOException {
        try {
            byte[] res = SocketUtil.sendShortLinkRequest(ip, port, 5000, request);
            if (res != null && res.length > 0) {
                return false;
            }
            throw new IllegalStateException("response is null.");
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            if (e.getMessage().equals("Read timed out")) {
                return true;
            }
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static void main(String[] args) {
        String pid = "asdfghjkl";
        String gameid = "000034";
        String name = pid;
        String type = "0";
        ServerRequest request = new ServerRequest();
        request.setCommand(2);
        request.setExtend1((byte)0);
        request.setParam("name", name);
        request.setParam("type", type);
        request.setParam("gameid", gameid);
        ServerRequest testRequest = new ServerRequest();
        testRequest.setCommand(28);
        testRequest.setExtend1((byte)1);
        CommonCoder commonCoder = new CommonCoder();
        try {
            System.out.println("\u957f\u8fde\u63a5:" + SocketUtil.isLongLink("10.11.200.90", 8866, commonCoder.encodeRequest(testRequest)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

