/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.common;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class ProtocolSupport {
    public byte[] encode(String encode, Map<String, String> data) {
        if (data == null || data.size() == 0) {
            return new byte[0];
        }
        try {
            ByteBuffer[] fieldBuffers = new ByteBuffer[data.size()];
            int length = 0;
            int i = -1;
            for (Map.Entry<String, String> entry : data.entrySet()) {
                ++i;
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                byte[] keyBytes = key.getBytes(encode);
                byte[] valueBytes = value.getBytes(encode);
                int fieldLen = keyBytes.length + valueBytes.length + 8;
                fieldBuffers[i] = ByteBuffer.allocate(fieldLen);
                fieldBuffers[i].putInt(keyBytes.length);
                if (keyBytes.length > 0) {
                    fieldBuffers[i].put(keyBytes);
                }
                fieldBuffers[i].putInt(valueBytes.length);
                if (valueBytes.length > 0) {
                    fieldBuffers[i].put(valueBytes);
                }
                fieldBuffers[i].flip();
                length += fieldLen;
            }
            ByteBuffer buffer = ByteBuffer.allocate(length);
            for (ByteBuffer field : fieldBuffers) {
                if (field == null) continue;
                buffer.put(field);
            }
            return buffer.array();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Map<String, String> decode(String encode, byte[] data) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (data == null || data.length == 0) {
            return map;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        try {
            while (buffer.remaining() > 0) {
                int valueLen;
                int remaining = buffer.remaining();
                if (remaining < 8) {
                    throw new IllegalStateException("data remaining " + remaining);
                }
                int keyLen = buffer.getInt();
                if (keyLen > remaining - 8) {
                    throw new IllegalStateException("key length exceed: " + keyLen + ">" + (remaining - 8));
                }
                String key = "";
                if (keyLen > 0) {
                    byte[] keyBytes = new byte[keyLen];
                    buffer.get(keyBytes);
                    key = new String(keyBytes, encode);
                }
                if ((valueLen = buffer.getInt()) > remaining - 8 - keyLen) {
                    throw new IllegalStateException("value length exceed: " + valueLen + ">" + (remaining - 8 - keyLen));
                }
                String value = "";
                if (valueLen > 0) {
                    byte[] valueBytes = new byte[valueLen];
                    buffer.get(valueBytes);
                    value = new String(valueBytes, encode);
                }
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

