/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.common;

import com.xunlei.frame.netty.common.CommonCoder;
import com.xunlei.frame.netty.common.ServerRequest;
import com.xunlei.frame.netty.common.ServerResponse;
import com.xunlei.frame.netty.util.SocketUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConnection {
    private static final Logger log = LoggerFactory.getLogger((String)"client");
    private String ip;
    private int port;
    private int timeout;
    private CommonCoder coder = new CommonCoder();

    public CommonConnection(String ip, int port, int timeout) {
        this.ip = ip;
        this.port = port;
        this.timeout = timeout;
    }

    public ServerResponse sendRequest(ServerRequest request) throws IOException {
        ServerResponse response;
        block7: {
            if (request == null) {
                return null;
            }
            response = null;
            try {
                byte[] requestData = this.coder.encodeRequest(request);
                byte[] responseData = SocketUtil.sendShortLinkRequest(this.ip, this.port, this.timeout, requestData);
                if (responseData == null || responseData.length <= 0) break block7;
                response = this.coder.decodeResponse(responseData);
            }
            catch (Exception e) {
                try {
                    log.error("reqeust exception.{},{},{},{},{}", new Object[]{this.ip, this.port, request.getCommand(), request.getParams(), e.getMessage()});
                    throw new IOException("request exception.", e.getCause());
                }
                catch (Throwable throwable) {
                    log.debug("request:{},{},{},{},{}", new Object[]{this.ip, this.port, request.getCommand(), request.getParams(), response != null});
                    if (response != null) {
                        log.debug("response:{},{}", new Object[]{response.getResult(), response.getValues()});
                    }
                    throw throwable;
                }
            }
        }
        log.debug("request:{},{},{},{},{}", new Object[]{this.ip, this.port, request.getCommand(), request.getParams(), response != null});
        if (response != null) {
            log.debug("response:{},{}", new Object[]{response.getResult(), response.getValues()});
        }
        return response;
    }
}

