/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.common;

import com.xunlei.frame.netty.common.EncodeSet;
import com.xunlei.frame.netty.common.ProtocolSupport;
import com.xunlei.frame.netty.common.ServerRequest;
import com.xunlei.frame.netty.common.ServerResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class CommonCoder {
    public static final int HEAD_LENGTH = 16;
    private static final int CACHE_SIZE = 1024;
    private ProtocolSupport support = new ProtocolSupport();

    public byte[] encodeRequest(ServerRequest request) {
        try {
            String encode = EncodeSet.encodeOf(request.getEncode());
            ByteBuffer paramBuffer = ByteBuffer.allocate(1024);
            Map<String, String> params = request.getParams();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key == null || value == null) continue;
                    byte[] keyBytes = key.getBytes(encode);
                    byte[] valueBytes = value.getBytes(encode);
                    if (paramBuffer.remaining() < 8 + keyBytes.length + valueBytes.length) {
                        ByteBuffer newBuffer = ByteBuffer.allocate(paramBuffer.capacity() * 2);
                        paramBuffer.flip();
                        newBuffer.put(paramBuffer);
                        paramBuffer = newBuffer;
                    }
                    paramBuffer.putInt(keyBytes.length);
                    paramBuffer.put(keyBytes);
                    paramBuffer.putInt(valueBytes.length);
                    paramBuffer.put(valueBytes);
                }
            }
            paramBuffer.flip();
            ByteBuffer reqBuffer = ByteBuffer.allocate(16 + paramBuffer.remaining());
            reqBuffer.put(request.getEncode());
            reqBuffer.put(request.getEncrypt());
            reqBuffer.put(request.getExtend1());
            reqBuffer.put(request.getExtend2());
            reqBuffer.putInt(request.getSessionid());
            reqBuffer.putInt(request.getCommand());
            reqBuffer.putInt(paramBuffer.remaining());
            reqBuffer.put(paramBuffer);
            return reqBuffer.array();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public byte[] encodeResponse(ServerResponse response) {
        byte[] data = this.support.encode(EncodeSet.encodeOf(response.getEncode()), response.getValues());
        ByteBuffer buffer = ByteBuffer.allocate(16 + data.length);
        buffer.put(new byte[]{response.getEncode(), response.getEncrypt(), response.getExtend1(), response.getExtend2()});
        buffer.putInt(response.getSessionid());
        buffer.putInt(response.getResult());
        buffer.putInt(data.length);
        buffer.put(data);
        return buffer.array();
    }

    public ServerRequest decodeRequest(byte[] requestData) {
        ServerRequest request = new ServerRequest();
        ByteBuffer buffer = ByteBuffer.wrap(requestData);
        request.setEncode(buffer.get());
        request.setEncrypt(buffer.get());
        request.setExtend1(buffer.get());
        request.setExtend2(buffer.get());
        request.setSessionid(buffer.getInt());
        request.setCommand(buffer.getInt());
        int length = buffer.getInt();
        request.setLength(length);
        byte[] data = new byte[length];
        buffer.get(data);
        request.setParams(this.support.decode(EncodeSet.encodeOf(request.getEncode()), data));
        return request;
    }

    public ServerResponse decodeResponse(byte[] responseData) {
        ServerResponse response = new ServerResponse();
        ByteBuffer buffer = ByteBuffer.wrap(responseData);
        response.setEncode(buffer.get());
        response.setEncrypt(buffer.get());
        response.setExtend1(buffer.get());
        response.setExtend2(buffer.get());
        response.setSessionid(buffer.getInt());
        response.setResult(buffer.getInt());
        int length = buffer.getInt();
        response.setLength(length);
        byte[] data = new byte[length];
        buffer.get(data);
        response.setValues(this.support.decode(EncodeSet.encodeOf(response.getEncode()), data));
        return response;
    }
}

