/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.client;

import com.xunlei.frame.netty.client.BlockSocketClient;
import com.xunlei.frame.netty.client.ShortSocketIO;
import com.xunlei.frame.netty.common.EncodeSet;
import com.xunlei.frame.netty.common.ServerRequest;
import com.xunlei.frame.netty.common.ServerResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioShortSocketClient
implements BlockSocketClient<ServerRequest, ServerResponse> {
    private static final Logger log = LoggerFactory.getLogger((String)"client");
    private static final int CACHE_SIZE = 2048;
    private static final int HEAD_LENGTH = 16;
    private String host;
    private int port;
    private int timeout;

    public NioShortSocketClient(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    @Override
    public ServerResponse socketRequest(ServerRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("reqeust");
        }
        String encode = EncodeSet.encodeOf(request.getEncode());
        ServerResponse response = null;
        ShortSocketIO socket = null;
        try {
            ByteBuffer paramBuffer = ByteBuffer.allocate(2048);
            Map<String, String> params = request.getParams();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key == null || value == null) continue;
                    byte[] keyBytes = key.getBytes(encode);
                    byte[] valueBytes = value.getBytes(encode);
                    if (paramBuffer.remaining() < 8 + keyBytes.length + valueBytes.length) {
                        ByteBuffer newBuffer = ByteBuffer.allocate(paramBuffer.capacity() * 2);
                        paramBuffer.flip();
                        newBuffer.put(paramBuffer);
                        paramBuffer = newBuffer;
                    }
                    paramBuffer.putInt(keyBytes.length);
                    paramBuffer.put(keyBytes);
                    paramBuffer.putInt(valueBytes.length);
                    paramBuffer.put(valueBytes);
                }
            }
            paramBuffer.flip();
            socket = new ShortSocketIO(this.host, this.port, this.timeout);
            ByteBuffer reqBuffer = ByteBuffer.allocate(16 + paramBuffer.remaining());
            reqBuffer.put(request.getEncode());
            reqBuffer.put(request.getEncrypt());
            reqBuffer.put(request.getExtend1());
            reqBuffer.put(request.getExtend2());
            reqBuffer.putInt(request.getSessionid());
            reqBuffer.putInt(request.getCommand());
            reqBuffer.putInt(paramBuffer.remaining());
            reqBuffer.put(paramBuffer);
            socket.write(reqBuffer.array());
            socket.flush();
            response = new ServerResponse();
            ByteBuffer headBuffer = ByteBuffer.wrap(socket.readBytes(16));
            response.setEncode(headBuffer.get());
            response.setEncrypt(headBuffer.get());
            response.setExtend1(headBuffer.get());
            response.setExtend2(headBuffer.get());
            response.setSessionid(headBuffer.getInt());
            response.setResult(headBuffer.getInt());
            int length = headBuffer.getInt();
            response.setLength(length);
            HashMap<String, String> values = new HashMap<String, String>();
            if (length > 0) {
                ByteBuffer valueBuffer = ByteBuffer.wrap(socket.readBytes(length));
                encode = EncodeSet.encodeOf(response.getEncode());
                while (valueBuffer.remaining() > 0) {
                    int valueLen;
                    int remaining = valueBuffer.remaining();
                    if (remaining < 8) {
                        throw new IllegalStateException("data remaining " + remaining);
                    }
                    int keyLen = valueBuffer.getInt();
                    if (keyLen > remaining - 8) {
                        throw new IllegalStateException("key length exceed: " + keyLen + ">" + (remaining - 8));
                    }
                    String key = "";
                    if (keyLen > 0) {
                        byte[] keyBytes = new byte[keyLen];
                        valueBuffer.get(keyBytes);
                        key = new String(keyBytes, encode);
                    }
                    if ((valueLen = valueBuffer.getInt()) > remaining - 8 - keyLen) {
                        throw new IllegalStateException("value length exceed: " + valueLen + ">" + (remaining - 8 - keyLen));
                    }
                    String value = "";
                    if (valueLen > 0) {
                        byte[] valueBytes = new byte[valueLen];
                        valueBuffer.get(valueBytes);
                        value = new String(valueBytes, encode);
                    }
                    values.put(key, value);
                }
            }
            response.setValues(values);
            log.debug("{}:{} {},{}-->{},{}", new Object[]{this.host, this.port, request.getCommand(), request.getParams(), response.getResult(), response.getValues()});
        }
        catch (IOException e) {
            log.error("exception.{}:{} {},{},{}", new Object[]{this.host, this.port, request.getCommand(), request.getParams(), e.getMessage()});
            throw e;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return response;
    }
}

