/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.client;

import com.xunlei.frame.netty.client.BlockSocketClient;
import com.xunlei.frame.netty.client.LongSocketIOPool;
import com.xunlei.frame.netty.client.LongSocketIOQueue;
import com.xunlei.frame.netty.client.LongSocketIOThreadMap;
import com.xunlei.frame.netty.client.NioLongSocketClient;
import com.xunlei.frame.netty.common.ServerRequest;
import com.xunlei.frame.netty.common.ServerResponse;
import java.util.HashMap;
import java.util.Map;

public class NioLongSocketClientFactory {
    private static Map<String, NioLongSocketClient> clients = new HashMap<String, NioLongSocketClient>();

    public static BlockSocketClient<ServerRequest, ServerResponse> createLongSocketIOPoolClient(String host, int port, int timeout, int connCount) {
        String key = "pool:" + host + ":" + port + ":" + timeout + ":" + connCount;
        NioLongSocketClient client = clients.get(key);
        if (client == null) {
            client = new NioLongSocketClient(host, port, timeout, new LongSocketIOPool(connCount));
            clients.put(key, client);
        }
        return client;
    }

    public static BlockSocketClient<ServerRequest, ServerResponse> createLongSocketIOQueueClient(String host, int port, int timeout) {
        String key = "queue:" + host + ":" + port + ":" + timeout;
        NioLongSocketClient client = clients.get(key);
        if (client == null) {
            client = new NioLongSocketClient(host, port, timeout, new LongSocketIOQueue());
            clients.put(key, client);
        }
        return client;
    }

    public static BlockSocketClient<ServerRequest, ServerResponse> createLongSocketIOThreadMapClient(String host, int port, int timeout) {
        String key = "threadMap:" + host + ":" + port + ":" + timeout;
        NioLongSocketClient client = clients.get(key);
        if (client == null) {
            client = new NioLongSocketClient(host, port, timeout, new LongSocketIOThreadMap());
            clients.put(key, client);
        }
        return client;
    }
}

