/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.client;

import com.xunlei.frame.netty.client.BlockSocketClient;
import com.xunlei.frame.netty.common.EncodeSet;
import com.xunlei.frame.netty.common.ServerRequest;
import com.xunlei.frame.netty.common.ServerResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyShortSocketClient
implements BlockSocketClient<ServerRequest, ServerResponse> {
    private static final Logger log = LoggerFactory.getLogger((String)"client");
    private static final String DECODE_NAME = "decode";
    private static final String ENCODE_NAME = "encode";
    private static final String HANDLER_NAME = "handler";
    private static ChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
    private static ChannelPipelineFactory pipelineFactory = new ClientChannelPipelineFactory();
    private ClientBootstrap bootstrap = new ClientBootstrap(channelFactory);

    public NettyShortSocketClient(String host, int port, int timeout) {
        this.bootstrap.setPipelineFactory(pipelineFactory);
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.bootstrap.setOption("tcpNoDelay", (Object)true);
        this.bootstrap.setOption("soLinger", (Object)-1);
        this.bootstrap.setOption("keepAlive", (Object)false);
        this.bootstrap.setOption("soTimeout", (Object)timeout);
        this.bootstrap.setOption("remoteAddress", (Object)new InetSocketAddress(host, port));
    }

    @Override
    public ServerResponse socketRequest(ServerRequest request) throws IOException {
        ChannelFuture future = this.bootstrap.connect();
        int timeout = (Integer)this.bootstrap.getOption("soTimeout");
        Channel channel = future.awaitUninterruptibly().getChannel();
        if (!future.isSuccess()) {
            throw new IOException(future.getCause().getMessage(), future.getCause().getCause());
        }
        channel.write((Object)request);
        boolean finish = channel.getCloseFuture().awaitUninterruptibly((long)timeout);
        if (!finish) {
            throw new IOException("read timeout.");
        }
        ClientHandler clientHandler = (ClientHandler)channel.getPipeline().get(HANDLER_NAME);
        return clientHandler.response;
    }

    public static void destroy() {
        channelFactory.releaseExternalResources();
    }

    static class ClientHandler
    extends SimpleChannelUpstreamHandler {
        ServerResponse response;

        ClientHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            this.response = (ServerResponse)e.getMessage();
            e.getChannel().close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            StackTraceElement[] eles;
            StringBuffer sb = new StringBuffer();
            if (e.getCause() != null && (eles = e.getCause().getStackTrace()) != null) {
                for (StackTraceElement ele : eles) {
                    sb.append("\n\tat " + ele.toString());
                }
            }
            log.error("handler error.{}{}", new Object[]{e, sb.toString()});
            try {
                e.getChannel().close();
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    static class ClientEncode
    extends OneToOneEncoder {
        public static final int HEAD_LENGTH = 16;
        public static final int BUFFER_ESTIMATED_LENGTH = 1024;

        ClientEncode() {
        }

        protected Object encode(ChannelHandlerContext ctx, Channel channel, Object obj) throws Exception {
            if (obj instanceof ServerRequest) {
                ServerRequest request = (ServerRequest)obj;
                int length = 0;
                Map<String, String> data = request.getParams();
                ChannelBuffer fieldBuffer = ChannelBuffers.dynamicBuffer((int)1024);
                if (data != null && data.size() > 0) {
                    String encode = EncodeSet.encodeOf(request.getEncode());
                    for (Map.Entry<String, String> entry : data.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (key == null || value == null) continue;
                        byte[] keyBytes = key.getBytes(encode);
                        byte[] valueBytes = value.getBytes(encode);
                        int fieldLen = keyBytes.length + valueBytes.length + 8;
                        fieldBuffer.writeInt(keyBytes.length);
                        if (keyBytes.length > 0) {
                            fieldBuffer.writeBytes(keyBytes);
                        }
                        fieldBuffer.writeInt(valueBytes.length);
                        if (valueBytes.length > 0) {
                            fieldBuffer.writeBytes(valueBytes);
                        }
                        length += fieldLen;
                    }
                }
                ChannelBuffer buffer = ChannelBuffers.buffer((int)(16 + length));
                buffer.writeByte((int)request.getEncode());
                buffer.writeByte((int)request.getEncrypt());
                buffer.writeByte((int)request.getExtend1());
                buffer.writeByte((int)request.getExtend2());
                buffer.writeInt(request.getSessionid());
                buffer.writeInt(request.getCommand());
                buffer.writeInt(length);
                if (length > 0) {
                    buffer.writeBytes(fieldBuffer);
                }
                return buffer;
            }
            return null;
        }
    }

    static class ClientDecode
    extends ReplayingDecoder<VoidEnum> {
        ClientDecode() {
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum status) throws Exception {
            byte encode = buffer.readByte();
            byte encrypt = buffer.readByte();
            byte extend1 = buffer.readByte();
            byte extend2 = buffer.readByte();
            int sessionid = buffer.readInt();
            int result = buffer.readInt();
            int length = buffer.readInt();
            HashMap<String, String> values = new HashMap<String, String>();
            int index = buffer.readerIndex();
            byte[] temp = null;
            int remaining = 0;
            int keyLen = 0;
            String key = null;
            int valueLen = 0;
            String value = null;
            while (buffer.readerIndex() < length + index) {
                remaining = length + index - buffer.readerIndex();
                if (remaining < 8) {
                    throw new IllegalStateException("data remaining " + remaining);
                }
                keyLen = buffer.readInt();
                if (keyLen > remaining - 8) {
                    throw new IllegalStateException("key length exceed: " + keyLen + ">" + (remaining - 8));
                }
                key = "";
                if (keyLen > 0) {
                    temp = new byte[keyLen];
                    buffer.readBytes(temp);
                    key = new String(temp, EncodeSet.encodeOf(encode));
                }
                if ((valueLen = buffer.readInt()) > remaining - 8 - keyLen) {
                    throw new IllegalStateException("value length exceed: " + valueLen + ">" + (remaining - 8 - keyLen));
                }
                value = "";
                if (valueLen > 0) {
                    temp = new byte[valueLen];
                    buffer.readBytes(temp);
                    value = new String(temp, EncodeSet.encodeOf(encode));
                }
                values.put(key, value);
            }
            ServerResponse response = new ServerResponse();
            response.setEncode(encode);
            response.setEncrypt(encrypt);
            response.setExtend1(extend1);
            response.setExtend2(extend2);
            response.setSessionid(sessionid);
            response.setResult(result);
            response.setLength(length);
            response.setValues(values);
            return response;
        }
    }

    static class ClientChannelPipelineFactory
    implements ChannelPipelineFactory {
        private ClientEncode encode = new ClientEncode();

        ClientChannelPipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast(NettyShortSocketClient.DECODE_NAME, (ChannelHandler)new ClientDecode());
            pipeline.addLast(NettyShortSocketClient.HANDLER_NAME, (ChannelHandler)new ClientHandler());
            pipeline.addLast(NettyShortSocketClient.ENCODE_NAME, (ChannelHandler)this.encode);
            return pipeline;
        }
    }
}

