/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.client;

import com.xunlei.frame.netty.client.LongSocketIO;
import com.xunlei.frame.netty.client.LongSocketIOManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LongSocketIOThreadMap
implements LongSocketIOManager {
    private Map<String, LongSocketIO> map = new ConcurrentHashMap<String, LongSocketIO>();
    private Map<String, Object> config = new HashMap<String, Object>();

    @Override
    public LongSocketIO borrowSocket() throws IOException {
        LongSocketIO sockIO = this.map.get(Thread.currentThread().getName());
        if (sockIO == null || !sockIO.isConnected()) {
            Boolean reuseAddress;
            Boolean noDelay;
            Integer connectTimeout;
            if (sockIO != null && !sockIO.isConnected()) {
                sockIO.destroy();
            }
            if ((connectTimeout = (Integer)this.config.get("connectTimeout")) == null) {
                connectTimeout = (Integer)this.config.get("timeout");
            }
            if ((noDelay = (Boolean)this.config.get("noDelay")) == null) {
                noDelay = Boolean.TRUE;
            }
            if ((reuseAddress = (Boolean)this.config.get("reuseAddress")) == null) {
                reuseAddress = Boolean.TRUE;
            }
            sockIO = new LongSocketIO(this, (String)this.config.get("host"), (Integer)this.config.get("port"), connectTimeout, (Integer)this.config.get("timeout"), noDelay, reuseAddress);
            this.map.put(Thread.currentThread().getName(), sockIO);
        }
        return sockIO;
    }

    @Override
    public void destroy() {
        for (Map.Entry<String, LongSocketIO> entry : this.map.entrySet()) {
            try {
                entry.getValue().destroy();
            }
            catch (IOException iOException) {}
        }
        this.map.clear();
    }

    @Override
    public void init() {
    }

    @Override
    public void returnSocket(LongSocketIO socket) {
    }

    @Override
    public void setOption(String option, Object value) {
        this.config.put(option, value);
    }
}

