/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.client;

import com.xunlei.frame.netty.client.LongSocketIO;
import com.xunlei.frame.netty.client.LongSocketIOManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LongSocketIOQueue
implements LongSocketIOManager {
    private Queue<LongSocketIO> queue = new ConcurrentLinkedQueue<LongSocketIO>();
    private Map<String, Object> config = new HashMap<String, Object>();

    @Override
    public LongSocketIO borrowSocket() throws IOException {
        LongSocketIO sockIO = this.queue.poll();
        if (sockIO == null || !sockIO.isConnected()) {
            Boolean reuseAddress;
            Boolean noDelay;
            Integer connectTimeout;
            if (sockIO != null && !sockIO.isConnected()) {
                sockIO.destroy();
            }
            if ((connectTimeout = (Integer)this.config.get("connectTimeout")) == null) {
                connectTimeout = (Integer)this.config.get("timeout");
            }
            if ((noDelay = (Boolean)this.config.get("noDelay")) == null) {
                noDelay = Boolean.TRUE;
            }
            if ((reuseAddress = (Boolean)this.config.get("reuseAddress")) == null) {
                reuseAddress = Boolean.TRUE;
            }
            sockIO = new LongSocketIO(this, (String)this.config.get("host"), (Integer)this.config.get("port"), connectTimeout, (Integer)this.config.get("timeout"), noDelay, reuseAddress);
        }
        return sockIO;
    }

    @Override
    public void destroy() {
        LongSocketIO sockIO;
        while ((sockIO = this.queue.poll()) != null) {
            try {
                sockIO.destroy();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void returnSocket(LongSocketIO socket) {
        if (socket != null) {
            this.queue.add(socket);
        }
    }

    @Override
    public void setOption(String option, Object value) {
        this.config.put(option, value);
    }
}

