/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.client;

import com.xunlei.frame.netty.client.LongSocketIO;
import com.xunlei.frame.netty.client.LongSocketIOManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongSocketIOPool
implements LongSocketIOManager {
    public static final long DEFAULT_MAX_ACTIVE = 300000L;
    public static final Logger log = LoggerFactory.getLogger((String)"client");
    private int max = 0;
    private Map<String, Object> config = new HashMap<String, Object>();
    private LongSocketIO[] sockets;
    private byte[] status;
    private ReentrantLock lock = new ReentrantLock();
    private long maxWait;
    private Finder finder = new Finder();
    private Recycler recycler = new Recycler(300000L);

    public LongSocketIOPool(int maxConn) {
        if (maxConn <= 0) {
            throw new IllegalArgumentException("maxConn cannot less than 0.");
        }
        this.max = maxConn;
        this.sockets = new LongSocketIO[this.max];
        this.status = new byte[this.max];
        this.init();
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.max; ++i) {
            try {
                if (this.sockets != null) {
                    this.sockets[i].destroy();
                }
                this.status[i] = 0;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.recycler.isRun()) {
            this.recycler.destroy();
        }
    }

    @Override
    public LongSocketIO borrowSocket() throws IOException {
        return this.finder.findSocket();
    }

    @Override
    public void init() {
        if (!this.recycler.isRun()) {
            Thread thread = new Thread(this.recycler);
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    public void returnSocket(LongSocketIO socket) {
        for (int i = 0; i < this.max; ++i) {
            if (!socket.equals(this.sockets[i])) continue;
            this.finder.reset(i);
            break;
        }
    }

    @Override
    public void setOption(String option, Object value) {
        this.config.put(option, value);
    }

    private long getMaxWait() {
        if (this.maxWait == 0L) {
            Integer timeout = (Integer)this.config.get("timeout");
            Integer connectTimeout = (Integer)this.config.get("connectTimeout");
            if (connectTimeout == null) {
                connectTimeout = timeout;
            }
            this.maxWait = Math.min(timeout, connectTimeout);
        }
        return this.maxWait;
    }

    public class Recycler
    implements Runnable {
        private long maxActive;
        private boolean end = true;

        public Recycler(long active) {
            this.maxActive = active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.end = false;
            log.info("\u5f00\u59cb\u542f\u52a8\u68c0\u67e5\u7a7a\u95f2\u8fde\u63a5\u7ebf\u7a0b.");
            while (!this.end) {
                long currentTime = System.currentTimeMillis();
                long recycleTime = currentTime - this.maxActive;
                long minLastUse = currentTime;
                for (int i = 0; i < LongSocketIOPool.this.max; ++i) {
                    if (LongSocketIOPool.this.status[i] != 0 || LongSocketIOPool.this.sockets[i] == null) continue;
                    long lastUse = LongSocketIOPool.this.sockets[i].lastUseTime();
                    if (lastUse <= recycleTime) {
                        this.recycle(i);
                        continue;
                    }
                    minLastUse = Math.min(minLastUse, lastUse);
                }
                Recycler recycler = this;
                synchronized (recycler) {
                    try {
                        this.wait(minLastUse + recycleTime - currentTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            log.info("\u9500\u6bc1\u68c0\u67e5\u7a7a\u95f2\u8fde\u63a5\u7ebf\u7a0b.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recycle(int i) {
            LongSocketIO longSocketIO = null;
            try {
                LongSocketIOPool.this.lock.lock();
                if (LongSocketIOPool.this.status[i] == 0 && LongSocketIOPool.this.sockets[i] != null) {
                    longSocketIO = LongSocketIOPool.this.sockets[i];
                    ((LongSocketIOPool)LongSocketIOPool.this).sockets[i] = null;
                }
            }
            finally {
                LongSocketIOPool.this.lock.unlock();
            }
            if (longSocketIO != null) {
                try {
                    log.info("\u56de\u6536socket" + i + ":" + longSocketIO.toString());
                    longSocketIO.destroy();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public boolean isRun() {
            return !this.end;
        }

        public void destroy() {
            this.end = true;
            Thread.interrupted();
        }
    }

    public class Finder {
        private int index;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LongSocketIO findSocket() throws IOException {
            LongSocketIO longSocketIO = this.findSocket1();
            if (longSocketIO != null) {
                return longSocketIO;
            }
            long waitTime = LongSocketIOPool.this.getMaxWait();
            while (longSocketIO == null && waitTime > 0L) {
                try {
                    long startTime = System.currentTimeMillis();
                    Finder finder = this;
                    synchronized (finder) {
                        this.wait(waitTime);
                    }
                    longSocketIO = this.findSocket1(0);
                    waitTime = waitTime + startTime - System.currentTimeMillis();
                }
                catch (Exception e) {}
            }
            if (longSocketIO == null) {
                throw new IOException("cannot find socket.");
            }
            return longSocketIO;
        }

        private LongSocketIO findSocket1() throws IOException {
            return this.findSocket1(this.index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LongSocketIO findSocket1(int start) throws IOException {
            if (start < 0 || start >= LongSocketIOPool.this.max) {
                start = 0;
            }
            LongSocketIO longSocketIO = null;
            int findIndex = -1;
            try {
                LongSocketIOPool.this.lock.lock();
                for (int i = start; i < start + LongSocketIOPool.this.max; ++i) {
                    int j = i % LongSocketIOPool.this.max;
                    if (LongSocketIOPool.this.status[j] != 0) continue;
                    ((LongSocketIOPool)LongSocketIOPool.this).status[j] = 1;
                    this.index = (j + 1) % LongSocketIOPool.this.max;
                    findIndex = j;
                    break;
                }
            }
            finally {
                LongSocketIOPool.this.lock.unlock();
            }
            if (findIndex != -1) {
                longSocketIO = this.createSocket(findIndex);
            }
            return longSocketIO;
        }

        private LongSocketIO createSocket(int findIndex) throws IOException {
            if (LongSocketIOPool.this.sockets[findIndex] == null || !LongSocketIOPool.this.sockets[findIndex].isConnected()) {
                Boolean reuseAddress;
                Boolean noDelay;
                Integer connectTimeout;
                if (LongSocketIOPool.this.sockets[findIndex] != null && !LongSocketIOPool.this.sockets[findIndex].isConnected()) {
                    LongSocketIOPool.this.sockets[findIndex].destroy();
                }
                if ((connectTimeout = (Integer)LongSocketIOPool.this.config.get("connectTimeout")) == null) {
                    connectTimeout = (Integer)LongSocketIOPool.this.config.get("timeout");
                }
                if ((noDelay = (Boolean)LongSocketIOPool.this.config.get("noDelay")) == null) {
                    noDelay = Boolean.TRUE;
                }
                if ((reuseAddress = (Boolean)LongSocketIOPool.this.config.get("reuseAddress")) == null) {
                    reuseAddress = Boolean.TRUE;
                }
                ((LongSocketIOPool)LongSocketIOPool.this).sockets[findIndex] = new LongSocketIO(LongSocketIOPool.this, (String)LongSocketIOPool.this.config.get("host"), (Integer)LongSocketIOPool.this.config.get("port"), connectTimeout, (Integer)LongSocketIOPool.this.config.get("timeout"), noDelay, reuseAddress);
                log.info("\u521b\u5efasocket" + findIndex + ":" + LongSocketIOPool.this.sockets[findIndex].toString());
            }
            return LongSocketIOPool.this.sockets[findIndex];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(int i) {
            ((LongSocketIOPool)LongSocketIOPool.this).status[i] = 0;
            if (i < this.index) {
                this.index = i;
            }
            Finder finder = this;
            synchronized (finder) {
                this.notifyAll();
            }
        }
    }
}

