/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.frame.netty.client;

import com.xunlei.frame.netty.client.LongSocketIOManager;
import com.xunlei.frame.netty.client.SocketIO;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public class LongSocketIO
implements SocketIO {
    private LongSocketIOManager socketIOManager;
    private Socket socket;
    private DataInputStream in;
    private BufferedOutputStream out;
    private byte[] recBuf;
    private int recBufSize = 1024;
    private int recIndex = 0;
    private long aliveTimeStamp = 0L;

    public LongSocketIO(LongSocketIOManager socketIOManager, String host, int port, int timeout) throws IOException {
        this(socketIOManager, host, port, timeout, timeout, true, true);
    }

    public LongSocketIO(LongSocketIOManager socketIOManager, String host, int port, int connectTimeout, int timeout, boolean noDelay, boolean reuseAddress) throws IOException {
        this.socketIOManager = socketIOManager;
        this.recBuf = new byte[this.recBufSize];
        SocketChannel channel = SocketChannel.open();
        this.socket = channel.socket();
        if (timeout >= 0) {
            this.socket.setSoTimeout(timeout);
        }
        this.socket.setTcpNoDelay(noDelay);
        this.socket.setReuseAddress(reuseAddress);
        this.socket.setKeepAlive(true);
        this.socket.connect(new InetSocketAddress(host, port), connectTimeout);
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
    }

    public void destroy() throws IOException {
        this.aliveTimeStamp = 0L;
        this.recBuf = new byte[this.recBufSize];
        this.recIndex = 0;
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.in = null;
        this.out = null;
        this.socket = null;
    }

    @Override
    public void close() throws IOException {
        this.recBuf = new byte[this.recBufSize];
        this.recIndex = 0;
        this.socketIOManager.returnSocket(this);
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public boolean isAlive() {
        return this.isConnected();
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new IOException("++++ attempting to read from closed socket");
        }
        byte[] result = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.recIndex >= length) {
            bos.write(this.recBuf, 0, length);
            byte[] newBuf = new byte[this.recBufSize];
            if (this.recIndex > length) {
                System.arraycopy(this.recBuf, length, newBuf, 0, this.recIndex - length);
            }
            this.recBuf = newBuf;
            this.recIndex -= length;
        } else {
            int totalread = length;
            if (this.recIndex > 0) {
                totalread -= this.recIndex;
                bos.write(this.recBuf, 0, this.recIndex);
                this.recBuf = new byte[this.recBufSize];
                this.recIndex = 0;
            }
            int readCount = 0;
            while (totalread > 0) {
                readCount = this.in.read(this.recBuf);
                if (readCount <= 0) continue;
                if (totalread > readCount) {
                    bos.write(this.recBuf, 0, readCount);
                    this.recBuf = new byte[this.recBufSize];
                    this.recIndex = 0;
                } else {
                    bos.write(this.recBuf, 0, totalread);
                    byte[] newBuf = new byte[this.recBufSize];
                    System.arraycopy(this.recBuf, totalread, newBuf, 0, readCount - totalread);
                    this.recBuf = newBuf;
                    this.recIndex = readCount - totalread;
                }
                totalread -= readCount;
            }
        }
        result = bos.toByteArray();
        if (result == null || result != null && result.length <= 0 && this.recIndex <= 0) {
            throw new IOException("++++ Stream appears to be dead, so closing it down");
        }
        this.aliveTimeStamp = System.currentTimeMillis();
        return result;
    }

    @Override
    public String readLine() throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new IOException("++++ attempting to read from closed socket");
        }
        String result = null;
        StringBuilder content = new StringBuilder();
        int readCount = 0;
        if (this.recIndex > 0 && this.read(content)) {
            return content.toString();
        }
        while ((readCount = this.in.read(this.recBuf, this.recIndex, this.recBuf.length - this.recIndex)) > 0) {
            this.recIndex += readCount;
            if (!this.read(content)) continue;
        }
        if ((result = content.toString()) == null || result != null && result.length() <= 0 && this.recIndex <= 0) {
            throw new IOException("++++ Stream appears to be dead, so closing it down");
        }
        this.aliveTimeStamp = System.currentTimeMillis();
        return result;
    }

    private boolean read(StringBuilder strBuilder) {
        boolean result = false;
        int index = -1;
        for (int i = 0; i < this.recIndex - 1; ++i) {
            if (this.recBuf[i] != 13 || this.recBuf[i + 1] != 10) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            strBuilder.append(new String(this.recBuf, 0, index));
            byte[] newBuf = new byte[this.recBufSize];
            if (this.recIndex > index + 2) {
                System.arraycopy(this.recBuf, index + 2, newBuf, 0, this.recIndex - index - 2);
            }
            this.recBuf = newBuf;
            this.recIndex = this.recIndex - index - 2;
            result = true;
        } else if (this.recBuf[this.recIndex - 1] == 13) {
            strBuilder.append(new String(this.recBuf, 0, this.recIndex - 1));
            this.recBuf = new byte[this.recBufSize];
            this.recBuf[0] = 13;
            this.recIndex = 1;
        } else {
            strBuilder.append(new String(this.recBuf, 0, this.recIndex));
            this.recBuf = new byte[this.recBufSize];
            this.recIndex = 0;
        }
        return result;
    }

    @Override
    public void flush() throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        this.out.flush();
        this.aliveTimeStamp = System.currentTimeMillis();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        this.out.write(b);
        this.aliveTimeStamp = System.currentTimeMillis();
    }

    public long lastUseTime() {
        return this.aliveTimeStamp;
    }

    public int hashCode() {
        return this.socket == null ? 0 : this.socket.hashCode();
    }

    public String toString() {
        return this.socket == null ? "" : this.socket.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public byte[] readBytes() throws IOException {
        throw new IOException("cannot access readBytes method.");
    }
}

