/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.stat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.xunlei.common.base.XLLog;
import com.xunlei.common.stat.XLStatItem;
import com.xunlei.common.stat.XLStatPack;
import com.xunlei.common.stat.a.c;
import com.xunlei.common.stat.base.a;
import com.xunlei.common.stat.base.b;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

@SuppressLint(value={"UseSparseArrays"})
public final class XLStatUtil
implements a.b {
    public static boolean mAcceptPhoneCode = false;
    private String TAG = XLStatUtil.class.getSimpleName();
    private static final String REPORT_BASE_URL = "http://stat.login.xunlei.com:1800/report?";
    private static int REPORT_REMOVE_BASE = 251662626;
    private static final int REPORT_ONCE_NUM = 3;
    private static final int REPORT_TIME_EXPIRE = 30000;
    private static int REPORT_TIMER_BASE = 252269168;
    private String mDeviceMacAddress = null;
    private static final String PLATFORM = "2";
    private static XLStatUtil mInstance = null;
    private Map<Integer, XLStatItem> mXLStatRequestMap = new HashMap<Integer, XLStatItem>();
    private List<XLStatPack> mXLReportStatList = new ArrayList<XLStatPack>();
    private c mStatDBManager = null;
    private String mAppName = "";
    private String mClientVersion = "";
    private String mSDKVersion = "";
    private int mBusinessType = -1;
    private int mCurrentStatTimerId = 0;
    private int mCurrentRemoveMsgId = 0;
    private String mPeerId = "";
    private Context mContext = null;
    private HttpClient mHttpClient = null;
    private boolean mIsMoudleInit = false;
    private Thread mThread = null;
    private b mLocker = new b();
    private boolean mReportThreadFin = false;
    private XLStatItem mRegisterPhoneCode = null;
    private XLStatItem mLoginFastPhoneCode = null;
    private boolean mTimerStarted = false;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            XLStatUtil.this.handleMessage(message);
        }
    };
    private Runnable mRunner = new Runnable(){

        @Override
        public void run() {
            while (true) {
                XLStatUtil.this.mLocker.a(0L);
                XLLog.v(XLStatUtil.this.TAG, "wait lock release");
                if (XLStatUtil.this.mReportThreadFin) break;
                int n = XLStatUtil.this.mXLReportStatList.size();
                if (n < 3) continue;
                XLStatUtil.this.reportStatToServer(XLStatUtil.this.packReportStatUrl());
            }
        }
    };

    private XLStatUtil() {
    }

    public static XLStatUtil getInstance() {
        if (mInstance == null) {
            mInstance = new XLStatUtil();
        }
        return mInstance;
    }

    public final void init(Context context, int n, String string, String string2, String string3) {
        if (this.mIsMoudleInit) {
            return;
        }
        XLLog.d(this.TAG, "init stat moudle id = " + this.hashCode());
        this.mBusinessType = n;
        this.mClientVersion = string;
        this.mSDKVersion = string2;
        this.mPeerId = string3;
        this.mXLStatRequestMap.clear();
        this.mContext = context;
        this.mHttpClient = new DefaultHttpClient();
        this.mDeviceMacAddress = this.getDeviceMac();
        this.mAppName = this.mContext.getApplicationInfo().packageName;
        this.mCurrentStatTimerId = REPORT_TIMER_BASE++;
        this.mCurrentRemoveMsgId = REPORT_REMOVE_BASE += 100;
        a.a(this.mContext);
        this.mThread = new Thread(this.mRunner);
        this.mThread.start();
        this.mReportThreadFin = false;
        this.mStatDBManager = new c(this.mContext);
        this.loadReportsFromDataBase();
        if (this.mXLReportStatList.size() >= 3) {
            this.startStatTimer();
        }
        this.mIsMoudleInit = true;
    }

    public final void uninit() {
        if (!this.mIsMoudleInit) {
            return;
        }
        a.a();
        this.saveReportsToDataBase();
        this.mReportThreadFin = true;
        this.mLocker.a();
        this.mXLStatRequestMap.clear();
        this.mIsMoudleInit = false;
    }

    public final int getBusinessType() {
        return this.mBusinessType;
    }

    public final synchronized void registerStatReq(int n) {
        XLStatItem xLStatItem = new XLStatItem();
        new XLStatItem().mTaskCookie = n;
        xLStatItem.mRequestTime = this.getCurrentTime();
        this.mXLStatRequestMap.put(n, xLStatItem);
    }

    public final synchronized void registerStatReq(int n, int n2) {
        XLStatItem xLStatItem = new XLStatItem();
        new XLStatItem().mTaskCookie = n;
        xLStatItem.mRequestTime = this.getCurrentTime();
        xLStatItem.mRequestCommandID = n2;
        this.mXLStatRequestMap.put(n, xLStatItem);
    }

    public final synchronized void registerSpecialStatReq(int n, int n2) {
        XLStatItem xLStatItem = new XLStatItem();
        new XLStatItem().mTaskCookie = n;
        xLStatItem.mRequestTime = this.getCurrentTime();
        if (n2 == 1) {
            this.mRegisterPhoneCode = xLStatItem;
            return;
        }
        this.mLoginFastPhoneCode = xLStatItem;
    }

    public final synchronized void reportSpecialStat(int n, XLStatPack xLStatPack) {
        XLStatItem xLStatItem = this.mLoginFastPhoneCode;
        if (n == 1) {
            xLStatItem = this.mRegisterPhoneCode;
        }
        if (xLStatItem != null) {
            xLStatPack.mRespTime = this.getCurrentTime() - xLStatItem.mRequestTime;
            xLStatPack.mReportDate = this.getReportDate();
            this.mXLReportStatList.add(0, xLStatPack);
            if (n == 1) {
                this.mRegisterPhoneCode = null;
            } else {
                this.mLoginFastPhoneCode = null;
            }
            if (this.mXLReportStatList.size() >= 3) {
                this.startStatTimer();
            }
            XLLog.d(this.TAG, "report command id = " + xLStatPack.mCommandID);
        }
    }

    private synchronized void unRegisterStatReq(int n) {
        this.mXLStatRequestMap.remove(n);
    }

    public final synchronized void report(int n, XLStatPack xLStatPack) {
        XLStatItem xLStatItem = this.getStatReq(n);
        if (xLStatItem != null) {
            xLStatPack.mRespTime = this.getCurrentTime() - xLStatItem.mRequestTime;
            xLStatPack.mReportDate = this.getReportDate();
            this.mXLReportStatList.add(0, xLStatPack);
            this.unRegisterStatReq(n);
            if (this.mXLReportStatList.size() >= 3) {
                this.startStatTimer();
            }
            XLLog.d(this.TAG, "report command id = " + xLStatPack.mCommandID);
        }
    }

    public final synchronized void report(int n, XLStatPack xLStatPack, boolean bl) {
        XLStatItem xLStatItem = this.getStatReq(n);
        if (xLStatItem != null) {
            xLStatPack.mRespTime = this.getCurrentTime() - xLStatItem.mRequestTime;
            xLStatPack.mReportDate = this.getReportDate();
            if (bl) {
                xLStatPack.mCommandID = xLStatItem.mRequestCommandID;
            }
            this.mXLReportStatList.add(0, xLStatPack);
            this.unRegisterStatReq(n);
            if (this.mXLReportStatList.size() >= 3) {
                this.startStatTimer();
            }
            XLLog.d(this.TAG, "report command id = " + xLStatPack.mCommandID);
        }
    }

    @Override
    public final void onTimerTick(int n) {
        if (this.mCurrentStatTimerId == n) {
            XLLog.d(this.TAG, "onTimerTick mXLReportStatList.size = " + this.mXLReportStatList.size() + " timerid = " + n);
            if (this.mXLReportStatList.size() >= 3) {
                this.mLocker.a();
            }
        }
    }

    private long getCurrentTime() {
        Date date = new Date();
        return date.getTime();
    }

    private synchronized XLStatItem getStatReq(int n) {
        return this.mXLStatRequestMap.get(n);
    }

    private void reportStatToServer(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        XLLog.d(this.TAG, "reportStatToServer url = " + string);
        string = new HttpGet(string);
        try {
            HttpResponse httpResponse = this.mHttpClient.execute((HttpUriRequest)string);
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n == 200) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(this.mCurrentRemoveMsgId));
            } else {
                XLLog.e(this.TAG, "reportStatToServer error code = " + n);
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            XLLog.e(this.TAG, "reportStatToServer error desc = " + exception2.getMessage());
            return;
        }
        finally {
            string.abort();
        }
    }

    private synchronized String packReportStatUrl() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(REPORT_BASE_URL);
        stringBuffer.append("cnt=3").append("&");
        int n = this.mXLReportStatList.size();
        XLLog.v(this.TAG, "packReportStatUrl report list size = " + n);
        if (n < 3) {
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            Object object;
            XLStatPack xLStatPack = this.mXLReportStatList.get(n - (i + 1));
            try {
                object = URLEncoder.encode(xLStatPack.mReqUrl, "UTF-8");
                stringBuffer.append("url").append(i).append("=").append((String)object).append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
            }
            stringBuffer.append("errorcode").append(i).append("=").append(xLStatPack.mErrorCode).append("&responsetime").append(i).append("=").append(xLStatPack.mRespTime).append("&retrynum").append(i).append("=").append(xLStatPack.mRetryNum).append("&serverip").append(i).append("=").append(xLStatPack.mSvrIp).append("&domain").append(i).append("=").append(xLStatPack.mSvrDomain).append("&cmdid").append(i).append("=").append(xLStatPack.mCommandID).append("&b_type").append(i).append("=").append(this.mBusinessType).append("&platform").append(i).append("=2").append("&clientversion").append(i).append("=").append(this.mClientVersion).append("&sdkversion").append(i).append("=").append(this.mSDKVersion).append("&appname").append(i).append("=").append(this.mAppName).append("&mac").append(i).append("=").append(this.mDeviceMacAddress).append("&uid").append(i).append("=").append(xLStatPack.mUserId);
            if (i == 2) continue;
            stringBuffer.append("&");
        }
        return stringBuffer.toString();
    }

    private synchronized void handleMessage(Message message) {
        if (this.mCurrentRemoveMsgId == message.what) {
            int n;
            for (n = 0; n < 3; ++n) {
                int n2 = this.mXLReportStatList.size() - 1;
                if (n2 < 0) continue;
                this.mXLReportStatList.remove(n2);
            }
            n = this.mXLReportStatList.size();
            XLLog.d(this.TAG, "remove report item size = " + n);
            if (n < 3) {
                this.killStatTimer();
            }
        }
    }

    private synchronized void loadReportsFromDataBase() {
        Object object = this.mStatDBManager;
        ArrayList<XLStatPack> arrayList = new ArrayList<XLStatPack>();
        object = ((c)object).c();
        while (object.moveToNext()) {
            XLStatPack xLStatPack = new XLStatPack();
            new XLStatPack().mReqUrl = object.getString(object.getColumnIndex("url"));
            xLStatPack.mErrorCode = object.getInt(object.getColumnIndex("error"));
            xLStatPack.mRespTime = object.getDouble(object.getColumnIndex("respt"));
            xLStatPack.mRetryNum = object.getInt(object.getColumnIndex("retry"));
            xLStatPack.mSvrIp = object.getString(object.getColumnIndex("ip"));
            xLStatPack.mSvrDomain = object.getString(object.getColumnIndex("domain"));
            xLStatPack.mCommandID = object.getInt(object.getColumnIndex("cmd"));
            xLStatPack.mReportDate = object.getString(object.getColumnIndex("date"));
            xLStatPack.mUserId = object.getInt(object.getColumnIndex("uid"));
            arrayList.add(xLStatPack);
        }
        object.close();
        object = arrayList;
        if (object.size() > 0) {
            XLLog.v("XLStatUtil", "loadReportsFromDataBase size = " + object.size());
            this.mXLReportStatList.addAll((Collection<XLStatPack>)object);
            this.mStatDBManager.a();
        }
    }

    private void saveReportsToDataBase() {
        XLLog.v("XLStatUtil", "save report list to database.");
        this.mStatDBManager.a(this.mXLReportStatList);
        this.mXLReportStatList.clear();
    }

    private String getReportDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }

    private int getNetConnType() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        connectivityManager = connectivityManager.getNetworkInfo(0);
        if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
            return 1;
        }
        if (connectivityManager != null && connectivityManager.getState() == NetworkInfo.State.CONNECTED) {
            return 2;
        }
        return 0;
    }

    private String getDeviceMac() {
        String string = "ANDROID-MAC";
        WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager = wifiManager == null ? null : wifiManager.getConnectionInfo();
        if (wifiManager != null) {
            string = wifiManager.getMacAddress();
            if (string == null) {
                string = "ANDROID-MAC";
            }
            string = string.replace(":", "");
        }
        return string;
    }

    private synchronized void startStatTimer() {
        if (!this.mTimerStarted) {
            this.mTimerStarted = true;
            a.b().a(this.mCurrentStatTimerId, 30000, true, this);
            XLLog.v(this.TAG, "startStatTimer");
        }
    }

    private synchronized void killStatTimer() {
        if (this.mTimerStarted) {
            this.mTimerStarted = false;
            a.b().a(this.mCurrentStatTimerId);
            XLLog.v(this.TAG, "killStatTimer");
        }
    }
}

