/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.httpclient.request;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.xunlei.common.httpclient.request.d;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;

public class PersistentCookieStore
implements CookieStore {
    private static final String COOKIE_PREFS = "CookiePrefsFile";
    private static final String COOKIE_NAME_STORE = "names";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private final ConcurrentHashMap<String, Cookie> cookies;
    private final SharedPreferences cookiePrefs;

    public PersistentCookieStore(Context stringArray) {
        this.cookiePrefs = stringArray.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new ConcurrentHashMap();
        stringArray = this.cookiePrefs.getString(COOKIE_NAME_STORE, null);
        if (stringArray != null) {
            String[] stringArray2 = TextUtils.split((String)stringArray, (String)",");
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                String string2 = this.cookiePrefs.getString(COOKIE_NAME_PREFIX + string, null);
                if (string2 == null || (string2 = this.decodeCookie(string2)) == null) continue;
                this.cookies.put(string, (Cookie)string2);
            }
            this.clearExpired(new Date());
        }
    }

    public void addCookie(Cookie cookie) {
        String string = cookie.getName() + cookie.getDomain();
        if (!cookie.isExpired(new Date())) {
            this.cookies.put(string, cookie);
        } else {
            this.cookies.remove(string);
        }
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        editor.putString(COOKIE_NAME_STORE, TextUtils.join((CharSequence)",", (Iterable)this.cookies.keySet()));
        editor.putString(COOKIE_NAME_PREFIX + string, this.encodeCookie(new d(cookie)));
        editor.commit();
    }

    public void clear() {
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        for (String string : this.cookies.keySet()) {
            editor.remove(COOKIE_NAME_PREFIX + string);
        }
        editor.remove(COOKIE_NAME_STORE);
        editor.commit();
        this.cookies.clear();
    }

    public boolean clearExpired(Date date) {
        boolean bl = false;
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        for (Map.Entry<String, Cookie> entry : this.cookies.entrySet()) {
            String string = entry.getKey();
            Cookie cookie = entry.getValue();
            if (!cookie.isExpired(date)) continue;
            this.cookies.remove(string);
            editor.remove(COOKIE_NAME_PREFIX + string);
            bl = true;
        }
        if (bl) {
            editor.putString(COOKIE_NAME_STORE, TextUtils.join((CharSequence)",", (Iterable)this.cookies.keySet()));
        }
        editor.commit();
        return bl;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    protected String encodeCookie(d d2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(d2);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
        return this.byteArrayToHexString(byteArrayOutputStream.toByteArray());
    }

    protected Cookie decodeCookie(String object) {
        object = this.hexStringToByteArray((String)object);
        object = new ByteArrayInputStream((byte[])object);
        Cookie cookie = null;
        try {
            object = new ObjectInputStream((InputStream)object);
            cookie = ((d)((ObjectInputStream)object).readObject()).a();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length << 1);
        for (int n : byArray) {
            if ((n &= 0xFF) < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }

    protected byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }
}

