/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.httpclient.handler;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class HttpResponseHandler {
    private static final int SUCCESS_MESSAGE = 0;
    private static final int FAILURE_MESSAGE = 1;
    private static final int START_MESSAGE = 2;
    private static final int FINISH_MESSAGE = 3;
    private static final int PROGRESS_MESSAGE = 4;
    private Handler handler;
    protected Object mFlag;

    public HttpResponseHandler() {
        if (Looper.myLooper() != null) {
            this.handler = new Handler(){

                public void handleMessage(Message message) {
                    HttpResponseHandler.this.handleMessage(message);
                }
            };
        }
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    public void onProgressChanged(long l, long l2) {
    }

    public void onSuccess(int n, Header[] headerArray, byte[] byArray) {
    }

    public void onFailure(Throwable throwable, byte[] byArray) {
    }

    public void sendSuccessMessage(int n, Header[] headerArray, byte[] byArray) {
        this.sendMessage(this.obtainMessage(0, new Object[]{n, headerArray, byArray}));
    }

    public void sendFailureMessage(Throwable throwable, byte[] byArray) {
        this.sendMessage(this.obtainMessage(1, new Object[]{throwable, byArray}));
    }

    public void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    public void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    public void sendProgressChangeMessage(long l, long l2) {
        this.sendMessage(this.obtainMessage(4, new long[]{l, l2}));
    }

    protected void handleSuccessMessage(int n, Header[] headerArray, byte[] byArray) {
        this.onSuccess(n, headerArray, byArray);
    }

    protected void handleFailureMessage(Throwable throwable, byte[] byArray) {
        this.onFailure(throwable, byArray);
    }

    protected void handleMessage(Message objectArray) {
        switch (objectArray.what) {
            case 0: {
                objectArray = (Object[])objectArray.obj;
                this.handleSuccessMessage((Integer)objectArray[0], (Header[])objectArray[1], (byte[])objectArray[2]);
                return;
            }
            case 1: {
                objectArray = (Object[])objectArray.obj;
                this.handleFailureMessage((Throwable)objectArray[0], (byte[])objectArray[1]);
                return;
            }
            case 2: {
                this.onStart();
                return;
            }
            case 3: {
                this.onFinish();
                return;
            }
            case 4: {
                objectArray = (long[])objectArray.obj;
                this.onProgressChanged((long)objectArray[0], (long)objectArray[1]);
            }
        }
    }

    protected void sendMessage(Message message) {
        if (this.handler != null) {
            this.handler.sendMessage(message);
            return;
        }
        this.handleMessage(message);
    }

    protected Message obtainMessage(int n, Object object) {
        Message message;
        if (this.handler != null) {
            message = this.handler.obtainMessage(n, object);
        } else {
            message = Message.obtain();
            Message.obtain().what = n;
            message.obj = object;
        }
        return message;
    }

    public void sendResponseMessage(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        Object object = null;
        int n = statusLine.getStatusCode();
        if (200 != n) {
            HttpResponseException httpResponseException = new HttpResponseException(statusLine.getStatusCode(), statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
            this.sendFailureMessage((Throwable)httpResponseException, null);
            return;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            try {
                object = new BufferedHttpEntity(httpEntity);
                object = EntityUtils.toByteArray((HttpEntity)object);
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
                this.sendFailureMessage((Throwable)object, null);
                return;
            }
        }
        this.sendSuccessMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), (byte[])object);
    }

    public void setFlag(Object object) {
        this.mFlag = object;
    }

    public Object getFlag() {
        return this.mFlag;
    }
}

