/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.httpclient;

import android.content.Context;
import com.xunlei.common.httpclient.BaseHttpClient;
import com.xunlei.common.httpclient.BaseHttpClientListener;
import com.xunlei.common.httpclient.handler.HttpResponseHandler;
import com.xunlei.common.httpclient.request.b;
import com.xunlei.common.httpclient.request.c;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.SyncBasicHttpContext;

public class AsyncHttpClient
implements BaseHttpClient {
    private static final String VERSION = "1.4.3";
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private static int maxConnections = 10;
    private static int socketTimeout = 10000;
    private DefaultHttpClient httpClient;
    private HttpContext httpContext;
    private ThreadPoolExecutor threadPool;
    private Map<Context, List<WeakReference<Future<?>>>> requestMap;
    private Map<String, String> clientHeaderMap;
    private String mAccSDKVersion = "1.0.0.1";

    public AsyncHttpClient(String string) {
        this.mAccSDKVersion = string;
        this.initHttpParam();
    }

    public AsyncHttpClient() {
        this.initHttpParam();
    }

    private void initHttpParam() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)basicHttpParams, (long)socketTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)basicHttpParams, (ConnPerRoute)new ConnPerRouteBean(maxConnections));
        ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)10);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)socketTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)socketTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)8192);
        HttpProtocolParams.setUseExpectContinue((HttpParams)basicHttpParams, (boolean)false);
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams, (String)String.format("android-async-http/xl-acc-sdk/version-" + this.mAccSDKVersion, VERSION));
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
        this.httpContext = new SyncBasicHttpContext((HttpContext)new BasicHttpContext());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)schemeRegistry, (HttpParams)basicHttpParams);
        this.httpClient.addRequestInterceptor(new HttpRequestInterceptor(this){
            private /* synthetic */ AsyncHttpClient a;
            {
                this.a = asyncHttpClient;
            }

            public final void process(HttpRequest httpRequest, HttpContext object) {
                if (!httpRequest.containsHeader(AsyncHttpClient.HEADER_ACCEPT_ENCODING)) {
                    httpRequest.addHeader(AsyncHttpClient.HEADER_ACCEPT_ENCODING, AsyncHttpClient.ENCODING_GZIP);
                }
                for (String string : this.a.clientHeaderMap.keySet()) {
                    httpRequest.addHeader(string, (String)this.a.clientHeaderMap.get(string));
                }
            }
        });
        this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(this){
            private /* synthetic */ AsyncHttpClient a;

            public final void process(HttpResponse httpResponse, HttpContext httpEntity) {
                httpEntity = httpResponse.getEntity();
                if (httpEntity == null) {
                    return;
                }
                if ((httpEntity = httpEntity.getContentEncoding()) != null) {
                    for (HeaderElement headerElement : httpEntity.getElements()) {
                        if (!headerElement.getName().equalsIgnoreCase(AsyncHttpClient.ENCODING_GZIP)) continue;
                        httpResponse.setEntity((HttpEntity)new a(httpResponse.getEntity()));
                        return;
                    }
                }
            }
        });
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new c(5));
        this.threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.requestMap = new WeakHashMap();
        this.clientHeaderMap = new HashMap<String, String>();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    public void setThreadPool(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPool = threadPoolExecutor;
    }

    public void setUserAgent(String string) {
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)string);
    }

    public void setTimeout(int n) {
        HttpParams httpParams = this.httpClient.getParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)n);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)n);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)n);
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)sSLSocketFactory, 443));
    }

    public void addHeader(String string, String string2) {
        this.clientHeaderMap.put(string, string2);
    }

    public void setBasicAuth(String string, String string2) {
        AuthScope authScope = AuthScope.ANY;
        this.setBasicAuth(string, string2, authScope);
    }

    public void setBasicAuth(String string, String string2, AuthScope authScope) {
        string = new UsernamePasswordCredentials(string, string2);
        this.httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)string);
    }

    public void cancelRequests(Context context, boolean bl) {
        List<WeakReference<Future<?>>> list = this.requestMap.get(context);
        if (list != null) {
            for (WeakReference weakReference : list) {
                Future object = (Future)weakReference.get();
                if (object == null) continue;
                object.cancel(bl);
            }
        }
        this.requestMap.remove(context);
    }

    public void get(String string, HttpResponseHandler httpResponseHandler) {
        this.get(null, string, null, httpResponseHandler);
    }

    public void get(String string, b b2, HttpResponseHandler httpResponseHandler) {
        this.get(null, string, b2, httpResponseHandler);
    }

    public void get(Context context, String string, HttpResponseHandler httpResponseHandler) {
        this.get(context, string, null, httpResponseHandler);
    }

    public void get(Context object, String string, b b2, HttpResponseHandler httpResponseHandler) {
        try {
            this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)new HttpGet(AsyncHttpClient.getUrlWithQueryString(string, b2)), null, httpResponseHandler, (Context)object);
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            httpResponseHandler.sendFailureMessage((Throwable)object, "".getBytes());
            return;
        }
    }

    public void get(Context context, String object, Header[] headerArray, b b2, HttpResponseHandler httpResponseHandler) {
        try {
            object = new HttpGet(AsyncHttpClient.getUrlWithQueryString((String)object, b2));
            if (headerArray != null) {
                object.setHeaders(headerArray);
            }
            this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, httpResponseHandler, context);
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            httpResponseHandler.sendFailureMessage((Throwable)object, "".getBytes());
            return;
        }
    }

    public void post(String string, HttpResponseHandler httpResponseHandler) {
        this.post(null, string, null, httpResponseHandler);
    }

    public void post(String string, b b2, HttpResponseHandler httpResponseHandler) {
        this.post(null, string, b2, httpResponseHandler);
    }

    public void post(Context context, String string, b b2, HttpResponseHandler httpResponseHandler) {
        this.post(context, string, this.paramsToEntity(b2), null, httpResponseHandler);
    }

    public void post(Context context, String string, HttpEntity httpEntity, String string2, HttpResponseHandler httpResponseHandler) {
        if ((string = (HttpPost)this.newHttpMethod("Post", string, null)) == null) {
            httpResponseHandler.sendFailureMessage(new IllegalArgumentException("the url is invlid."), "the url is invlid.".getBytes());
            return;
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)string, httpEntity), string2, httpResponseHandler, context);
    }

    public void post(Context context, String string, Header[] headerArray, b b2, String string2, HttpResponseHandler httpResponseHandler) {
        if ((string = (HttpPost)this.newHttpMethod("Post", string, b2)) == null) {
            httpResponseHandler.sendFailureMessage(new IllegalArgumentException("the url is invlid."), "the url is invlid.".getBytes());
            return;
        }
        if (b2 != null) {
            string.setEntity(this.paramsToEntity(b2));
        }
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, string2, httpResponseHandler, context);
    }

    public void post(Context context, String string, Header[] headerArray, HttpEntity httpEntity, String string2, HttpResponseHandler httpResponseHandler) {
        if ((string = (HttpPost)this.newHttpMethod("Post", string, null)) == null) {
            httpResponseHandler.sendFailureMessage(new IllegalArgumentException("the url is invlid."), "the url is invlid.".getBytes());
            return;
        }
        string = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)string, httpEntity);
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, string2, httpResponseHandler, context);
    }

    public void put(String string, HttpResponseHandler httpResponseHandler) {
        this.put(null, string, null, httpResponseHandler);
    }

    public void put(String string, b b2, HttpResponseHandler httpResponseHandler) {
        this.put(null, string, b2, httpResponseHandler);
    }

    public void put(Context context, String string, b b2, HttpResponseHandler httpResponseHandler) {
        this.put(context, string, this.paramsToEntity(b2), null, httpResponseHandler);
    }

    public void put(Context context, String string, HttpEntity httpEntity, String string2, HttpResponseHandler httpResponseHandler) {
        if ((string = (HttpPut)this.newHttpMethod("Put", string, null)) == null) {
            httpResponseHandler.sendFailureMessage(new IllegalArgumentException("the url is invlid."), "the url is invlid.".getBytes());
            return;
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)string, httpEntity), string2, httpResponseHandler, context);
    }

    public void put(Context context, String string, Header[] headerArray, HttpEntity httpEntity, String string2, HttpResponseHandler httpResponseHandler) {
        if ((string = (HttpPut)this.newHttpMethod("Put", string, null)) == null) {
            httpResponseHandler.sendFailureMessage(new IllegalArgumentException("the url is invlid."), "the url is invlid.".getBytes());
            return;
        }
        string = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)string, httpEntity);
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, string2, httpResponseHandler, context);
    }

    public void delete(String string, HttpResponseHandler httpResponseHandler) {
        this.delete(null, string, httpResponseHandler);
    }

    public void delete(Context context, String string, HttpResponseHandler httpResponseHandler) {
        if ((string = (HttpDelete)this.newHttpMethod("Delete", string, null)) == null) {
            httpResponseHandler.sendFailureMessage(new IllegalArgumentException("the url is invlid."), "the url is invlid.".getBytes());
            return;
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, null, httpResponseHandler, context);
    }

    public void delete(Context context, String string, Header[] headerArray, HttpResponseHandler httpResponseHandler) {
        if ((string = (HttpDelete)this.newHttpMethod("Delete", string, null)) == null) {
            httpResponseHandler.sendFailureMessage(new IllegalArgumentException("the url is invlid."), "the url is invlid.".getBytes());
            return;
        }
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, null, httpResponseHandler, context);
    }

    protected void sendRequest(DefaultHttpClient object, HttpContext object2, HttpUriRequest httpUriRequest, String string, HttpResponseHandler httpResponseHandler, Context context) {
        if (string != null) {
            httpUriRequest.addHeader("Content-Type", string);
        }
        object = this.threadPool.submit(new com.xunlei.common.httpclient.request.a((AbstractHttpClient)object, (HttpContext)object2, httpUriRequest, httpResponseHandler));
        if (context != null) {
            object2 = this.requestMap.get(context);
            if (object2 == null) {
                object2 = new LinkedList();
                this.requestMap.put(context, (List<WeakReference<Future<?>>>)object2);
            }
            object2.add(new WeakReference<DefaultHttpClient>((DefaultHttpClient)object));
        }
    }

    public static String getUrlWithQueryString(String string, b object) {
        if (object != null) {
            object = ((b)object).b();
            string = string.indexOf("?") == -1 ? string + "?" + (String)object : string + "&" + (String)object;
        }
        return string;
    }

    private HttpRequest newHttpMethod(String object, String string, b b2) {
        HttpGet httpGet = null;
        string = AsyncHttpClient.getUrlWithQueryString(string, b2);
        try {
            if ("Get".equalsIgnoreCase((String)object)) {
                httpGet = new HttpGet(string);
            } else if ("Post".equalsIgnoreCase((String)object)) {
                httpGet = new HttpPost(string);
            } else if ("Put".equalsIgnoreCase((String)object)) {
                httpGet = new HttpPut(string);
            } else if ("Delete".equalsIgnoreCase((String)object)) {
                httpGet = new HttpDelete(string);
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return httpGet;
    }

    private HttpEntity paramsToEntity(b b2) {
        HttpEntity httpEntity = null;
        if (b2 != null) {
            httpEntity = b2.a();
        }
        return httpEntity;
    }

    private HttpEntityEnclosingRequestBase addEntityToRequestBase(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, HttpEntity httpEntity) {
        if (httpEntity != null) {
            httpEntityEnclosingRequestBase.setEntity(httpEntity);
        }
        return httpEntityEnclosingRequestBase;
    }

    @Override
    public void post(Context context, String string, Header[] headerArray, byte[] object, BaseHttpClientListener baseHttpClientListener) {
        ByteArrayEntity byteArrayEntity = null;
        if (object != null) {
            byteArrayEntity = new ByteArrayEntity(object);
        }
        object = new HttpResponseHandler(this, baseHttpClientListener){
            private /* synthetic */ BaseHttpClientListener a;
            private /* synthetic */ AsyncHttpClient b;
            {
                this.a = baseHttpClientListener;
            }

            @Override
            public final void onSuccess(int n, Header[] headerArray, byte[] byArray) {
                this.a.onSuccess(n, headerArray, byArray);
            }

            @Override
            public final void onFailure(Throwable throwable, byte[] byArray) {
                this.a.onFailure(throwable, byArray);
            }
        };
        this.post(context, string, headerArray, (HttpEntity)byteArrayEntity, null, (HttpResponseHandler)object);
    }

    @Override
    public void get(Context context, String string, Header[] headerArray, BaseHttpClientListener object) {
        object = new HttpResponseHandler(this, (BaseHttpClientListener)object){
            private /* synthetic */ BaseHttpClientListener a;
            private /* synthetic */ AsyncHttpClient b;
            {
                this.a = baseHttpClientListener;
            }

            @Override
            public final void onSuccess(int n, Header[] headerArray, byte[] byArray) {
                this.a.onSuccess(n, headerArray, byArray);
            }

            @Override
            public final void onFailure(Throwable throwable, byte[] byArray) {
                this.a.onFailure(throwable, byArray);
            }
        };
        this.get(context, string, headerArray, null, (HttpResponseHandler)object);
    }

    @Override
    public void setHttpClientTimeout(int n) {
        this.setTimeout(n);
    }

    static final class a
    extends HttpEntityWrapper {
        public a(HttpEntity httpEntity) {
            super(httpEntity);
        }

        public final InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public final long getContentLength() {
            return -1L;
        }
    }
}

