/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.encrypt;

import com.xunlei.common.encrypt.Base64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public final class RSATools {
    private static String RSA = "RSA";
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";

    public static KeyPair generateRSAKeyPair() {
        return RSATools.generateRSAKeyPair(1024);
    }

    public static KeyPair generateRSAKeyPair(int n) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
            keyPairGenerator.initialize(n);
            return keyPairGenerator.genKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static PublicKey getPublicKey(byte[] object) throws NoSuchAlgorithmException, InvalidKeySpecException {
        object = new X509EncodedKeySpec((byte[])object);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PublicKey publicKey = keyFactory.generatePublic((KeySpec)object);
        object = publicKey;
        return publicKey;
    }

    public static PrivateKey getPrivateKey(byte[] object) throws NoSuchAlgorithmException, InvalidKeySpecException {
        object = new PKCS8EncodedKeySpec((byte[])object);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PrivateKey privateKey = keyFactory.generatePrivate((KeySpec)object);
        object = privateKey;
        return privateKey;
    }

    public static PublicKey getPublicKey(String object, String object2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        object = new BigInteger((String)object);
        object2 = new BigInteger((String)object2);
        object = new RSAPublicKeySpec((BigInteger)object, (BigInteger)object2);
        object2 = KeyFactory.getInstance(RSA);
        object = ((KeyFactory)object2).generatePublic((KeySpec)object);
        return object;
    }

    public static PrivateKey getPrivateKey(String object, String object2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        object = new BigInteger((String)object);
        object2 = new BigInteger((String)object2);
        object = new RSAPublicKeySpec((BigInteger)object, (BigInteger)object2);
        object2 = KeyFactory.getInstance(RSA);
        object = ((KeyFactory)object2).generatePrivate((KeySpec)object);
        return object;
    }

    public static PublicKey loadPublicKey(String object) throws Exception {
        try {
            object = Base64.decode((String)object);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            object = new X509EncodedKeySpec((byte[])object);
            return (RSAPublicKey)keyFactory.generatePublic((KeySpec)object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static PrivateKey loadPrivateKey(String object) throws Exception {
        try {
            object = Base64.decode((String)object);
            object = new PKCS8EncodedKeySpec((byte[])object);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            return (RSAPrivateKey)keyFactory.generatePrivate((KeySpec)object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new Exception("\u79c1\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static PublicKey loadPublicKey(InputStream inputStream) throws Exception {
        try {
            return RSATools.loadPublicKey(RSATools.readKey(inputStream));
        }
        catch (IOException iOException) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u6d41\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u516c\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public static PrivateKey loadPrivateKey(InputStream inputStream) throws Exception {
        try {
            return RSATools.loadPrivateKey(RSATools.readKey(inputStream));
        }
        catch (IOException iOException) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u79c1\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    private static String readKey(InputStream closeable) throws IOException {
        String string;
        closeable = new BufferedReader(new InputStreamReader((InputStream)closeable));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = ((BufferedReader)closeable).readLine()) != null) {
            if (string.charAt(0) == '-') continue;
            stringBuilder.append(string);
            stringBuilder.append('\r');
        }
        return stringBuilder.toString();
    }

    public static byte[] encryptData(byte[] byArray, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(1, publicKey);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptData(byte[] byArray, PrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(2, privateKey);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String sign(String object, String object2, String string) {
        try {
            object2 = new PKCS8EncodedKeySpec(Base64.decode((String)object2));
            Object object3 = KeyFactory.getInstance("RSA");
            object2 = ((KeyFactory)object3).generatePrivate((KeySpec)object2);
            object3 = Signature.getInstance(SIGN_ALGORITHMS);
            ((Signature)object3).initSign((PrivateKey)object2);
            ((Signature)object3).update(((String)object).getBytes(string));
            byte[] byArray = ((Signature)object3).sign();
            object = byArray;
            return Base64.encode(byArray);
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static String sign(String object, PrivateKey privateKey, String string) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(privateKey);
            signature.update(((String)object).getBytes(string));
            byte[] byArray = signature.sign();
            object = byArray;
            return Base64.encode(byArray);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean verify(String string, String string2, String object, String string3) {
        try {
            Object object2 = KeyFactory.getInstance("RSA");
            object = Base64.decode((String)object);
            object = ((KeyFactory)object2).generatePublic(new X509EncodedKeySpec((byte[])object));
            object2 = Signature.getInstance(SIGN_ALGORITHMS);
            ((Signature)object2).initVerify((PublicKey)object);
            ((Signature)object2).update(string.getBytes(string3));
            boolean bl = ((Signature)object2).verify(Base64.decode(string2));
            return bl;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean verify(String string, String string2, PublicKey publicKey, String string3) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(publicKey);
            signature.update(string.getBytes(string3));
            boolean bl = signature.verify(Base64.decode(string2));
            return bl;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return false;
        }
    }

    public static void printPublicKeyInfo(PublicKey publicKey) {
        publicKey = (RSAPublicKey)publicKey;
        System.out.println("----------RSAPublicKey----------");
        System.out.println("Modulus.length=" + publicKey.getModulus().bitLength());
        System.out.println("Modulus=" + publicKey.getModulus().toString());
        System.out.println("PublicExponent.length=" + publicKey.getPublicExponent().bitLength());
        System.out.println("PublicExponent=" + publicKey.getPublicExponent().toString());
    }

    public static void printPrivateKeyInfo(PrivateKey privateKey) {
        privateKey = (RSAPrivateKey)privateKey;
        System.out.println("----------RSAPrivateKey ----------");
        System.out.println("Modulus.length=" + privateKey.getModulus().bitLength());
        System.out.println("Modulus=" + privateKey.getModulus().toString());
        System.out.println("PrivateExponent.length=" + privateKey.getPrivateExponent().bitLength());
        System.out.println("PrivatecExponent=" + privateKey.getPrivateExponent().toString());
    }
}

