/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.encrypt;

import com.xunlei.common.encrypt.HextoChar;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class CharsetConvert {
    public static final String US_ASCII = "US-ASCII";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_16 = "UTF-16";
    public static final String GBK = "GBK";

    public static String inputStreamToGBK(InputStream inputStream) throws IOException {
        return CharsetConvert.inputStreamconvertToCharset(inputStream, GBK);
    }

    public static String inputStreamToGBK(byte[] object) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = byteArrayInputStream;
        return CharsetConvert.inputStreamToGBK(byteArrayInputStream);
    }

    public static String inputStreamToUTF8(InputStream inputStream) throws IOException {
        return CharsetConvert.inputStreamconvertToCharset(inputStream, UTF_8);
    }

    public static String inputStreamToUTF8(byte[] object) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = byteArrayInputStream;
        return CharsetConvert.inputStreamToUTF8(byteArrayInputStream);
    }

    public static String StringToGBK(String string) throws IOException {
        return CharsetConvert.strconvertToCharset(string, GBK);
    }

    public static String utf8ToUnicode(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(cArray[i]);
            if (unicodeBlock == Character.UnicodeBlock.BASIC_LATIN) {
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                int n = cArray[i] - 65248;
                stringBuffer.append((char)n);
                continue;
            }
            short s = (short)cArray[i];
            String string2 = Integer.toHexString(s);
            string2 = "\\u" + string2;
            stringBuffer.append(string2.toLowerCase());
        }
        return stringBuffer.toString();
    }

    public static String unicodeToUtf8(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        char c2 = string.charAt(n2++);
                        n3 = c2;
                        switch (c2) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private static String strconvertToCharset(String object, String string) throws UnsupportedEncodingException {
        object = ((String)object).getBytes();
        object = new String((byte[])object, string);
        return object;
    }

    private static String inputStreamconvertToCharset(InputStream closeable, String charSequence) throws IOException {
        closeable = new InputStreamReader((InputStream)closeable, (String)charSequence);
        charSequence = new StringBuffer();
        char[] cArray = new char[64];
        try {
            int n;
            while ((n = ((Reader)closeable).read(cArray)) != -1) {
                ((StringBuffer)charSequence).append(cArray, 0, n);
            }
        }
        finally {
            ((InputStreamReader)closeable).close();
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String correctGBUrlCodeString(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringArray = stringArray.split("%");
        stringBuffer.append(stringArray[0]);
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("%");
            char[] cArray = stringArray[i].toCharArray();
            if (cArray.length <= 0) {
                return null;
            }
            if (bl) {
                stringBuffer.append(cArray);
                if (cArray[0] == '3') {
                    stringBuffer.append("%");
                    stringBuffer.append(stringArray[i + 1]);
                    stringBuffer.append("%");
                    stringBuffer.append(stringArray[i + 2]);
                    i += 2;
                }
                bl = false;
                continue;
            }
            if (cArray[0] >= '0' && cArray[0] <= '7') {
                stringBuffer.append(cArray);
                continue;
            }
            if (cArray.length == 2) {
                bl = true;
                stringBuffer.append(cArray);
                continue;
            }
            byte by = (byte)cArray[2];
            byte[] byArray = HextoChar.byte_to_hex(by);
            stringBuffer.append(cArray, 0, 2);
            stringBuffer.append("%");
            stringBuffer.append(new String(byArray));
            stringBuffer.append(cArray, 3, cArray.length - 3);
        }
        return stringBuffer.toString();
    }

    public static boolean testUTF8(byte[] byArray) {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = byArray[i];
            if ((n &= 0xFF) >>> 7 == 0) {
                n = 1;
            } else {
                if (n >>> 6 == 2) {
                    return false;
                }
                if (n >>> 5 == 6) {
                    n = 2;
                } else if (n >>> 4 == 14) {
                    n = 3;
                } else if (n >>> 3 == 30) {
                    n = 4;
                } else if (n >>> 2 == 62) {
                    n = 5;
                } else if (n >>> 1 == 126) {
                    n = 6;
                } else {
                    return false;
                }
            }
            if (i + n - 1 >= byArray.length) {
                return false;
            }
            for (int j = i + 1; j < n + i; ++j) {
                int n2 = byArray[j];
                if ((n2 &= 0xFF) >>> 6 == 2) continue;
                return false;
            }
        }
        return true;
    }
}

