/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.btorrent;

import com.xunlei.common.btorrent.a;
import com.xunlei.common.btorrent.b;
import com.xunlei.common.encrypt.HextoChar;
import com.xunlei.common.encrypt.SHA1;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Torrent {
    private static final int PIECE_LENGTH = 524288;
    public static final int PIECE_HASH_SIZE = 20;
    public static final String BYTE_ENCODING = "ISO-8859-1";
    protected final byte[] encoded;
    protected final byte[] encoded_info;
    protected final Map<String, b> decoded;
    protected final Map<String, b> decoded_info;
    private final byte[] info_hash;
    private final String hex_info_hash;
    private final List<List<URI>> trackers;
    private final Set<URI> allTrackers;
    private final Date creationDate;
    private final String comment;
    private final String createdBy;
    private String encoding;
    private final String name;
    private final long size;
    protected final List<TorrentFile> files;
    private final boolean seeder;

    public Torrent(byte[] object, boolean bl) throws IOException {
        Object object2;
        this.encoded = object;
        this.seeder = bl;
        this.decoded = a.a(new ByteArrayInputStream(this.encoded)).g();
        this.decoded_info = this.decoded.get("info").g();
        object = new ByteArrayOutputStream();
        a.a(this.decoded_info, (OutputStream)object);
        this.encoded_info = ((ByteArrayOutputStream)object).toByteArray();
        this.info_hash = Torrent.hash(this.encoded_info);
        this.hex_info_hash = Torrent.byteArrayToHexString(this.info_hash);
        this.trackers = new ArrayList<List<URI>>();
        this.allTrackers = new HashSet<URI>();
        this.creationDate = new Date(100000L);
        this.comment = "";
        this.createdBy = "";
        object = this.decoded.get("encoding");
        if (object != null) {
            this.encoding = ((b)object).a("UTF-8");
        }
        if (this.encoding == null || this.encoding.compareToIgnoreCase("") == 0) {
            object2 = this.decoded_info.get("name").c();
            this.encoding = Torrent.testUTF8(object2) ? "UTF-8" : "GBK";
        }
        this.name = this.decoded_info.get("name").a(this.encoding);
        this.files = new LinkedList<TorrentFile>();
        if (this.decoded_info.containsKey("files")) {
            object2 = this.decoded_info.get("files").f().iterator();
            while (object2.hasNext()) {
                b b2 = (b)object2.next();
                object = b2.g();
                StringBuilder stringBuilder = new StringBuilder();
                for (b b3 : ((b)object.get("path")).f()) {
                    stringBuilder.append(File.separator).append(b3.a(this.encoding));
                }
                object = (b)object.get("length");
                this.files.add(new TorrentFile(new File(this.name, stringBuilder.toString()), ((b)object).d().longValue()));
            }
        } else {
            object = this.decoded_info.get("length");
            this.files.add(new TorrentFile(new File(this.name), ((b)object).d().longValue()));
        }
        long l = 0L;
        for (TorrentFile torrentFile : this.files) {
            l += torrentFile.size;
        }
        this.size = l;
    }

    private static boolean testUTF8(byte[] byArray) {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = byArray[i];
            if ((n &= 0xFF) >>> 7 == 0) {
                n = 1;
            } else {
                if (n >>> 6 == 2) {
                    return false;
                }
                if (n >>> 5 == 6) {
                    n = 2;
                } else if (n >>> 4 == 14) {
                    n = 3;
                } else if (n >>> 3 == 30) {
                    n = 4;
                } else if (n >>> 2 == 62) {
                    n = 5;
                } else if (n >>> 1 == 126) {
                    n = 6;
                } else {
                    return false;
                }
            }
            if (i + n - 1 >= byArray.length) {
                return false;
            }
            for (int j = i + 1; j < n + i; ++j) {
                int n2 = byArray[j];
                if ((n2 &= 0xFF) >>> 6 == 2) continue;
                return false;
            }
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public long getSize() {
        return this.size;
    }

    public List<String> getFilenames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (TorrentFile torrentFile : this.files) {
            linkedList.add(torrentFile.file.getPath());
        }
        return linkedList;
    }

    public BtSubFile[] getSubFiles() {
        int n = this.files.size();
        if (n > 0) {
            BtSubFile[] btSubFileArray = new BtSubFile[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                TorrentFile torrentFile = this.files.get(i);
                if (torrentFile == null) continue;
                btSubFileArray[i] = new BtSubFile();
                btSubFileArray[i].fileName = torrentFile.file.getName();
                btSubFileArray[i].fileSize = torrentFile.size;
                btSubFileArray[i].fileId = n2++;
            }
            return btSubFileArray;
        }
        return null;
    }

    public boolean isMultifile() {
        return this.files.size() > 1;
    }

    public byte[] getInfoHash() {
        return this.info_hash;
    }

    public String getHexInfoHash() {
        return this.hex_info_hash;
    }

    public String toString() {
        return this.getName();
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public List<List<URI>> getAnnounceList() {
        return this.trackers;
    }

    public int getTrackerCount() {
        return this.allTrackers.size();
    }

    public boolean isSeeder() {
        return this.seeder;
    }

    public void save(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public static byte[] hash(byte[] byArray) {
        return SHA1.encrypt(byArray);
    }

    public static String byteArrayToHexString(byte[] byArray) {
        byArray = HextoChar.bytes_to_hex(byArray, byArray.length);
        return new String(byArray);
    }

    public static String toHexString(String object) {
        try {
            byte[] byArray = ((String)object).getBytes(BYTE_ENCODING);
            object = byArray;
            return Torrent.byteArrayToHexString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    protected static int getHashingThreadsCount() {
        String string = System.getenv("TTORRENT_HASHING_THREADS");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public static Torrent load(File file) throws IOException {
        return Torrent.load(file, false);
    }

    public static Torrent load(File object, boolean bl) throws IOException {
        object = new FileInputStream((File)object);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while (true) {
            int n;
            if ((n = ((FileInputStream)object).read(byArray, 0, 1024)) > 0 && n <= 1024) {
                byteArrayOutputStream.write(byArray, 0, n);
                continue;
            }
            if (n <= 0) break;
        }
        byteArrayOutputStream.flush();
        ((FileInputStream)object).close();
        Torrent torrent = new Torrent(byteArrayOutputStream.toByteArray(), bl);
        byteArrayOutputStream.close();
        return torrent;
    }

    public static Torrent create(File file, URI uRI, String string) throws InterruptedException, IOException {
        return Torrent.create(file, null, uRI, null, string);
    }

    public static Torrent create(File file, List<File> list, URI uRI, String string) throws InterruptedException, IOException {
        return Torrent.create(file, list, uRI, null, string);
    }

    public static Torrent create(File file, List<List<URI>> list, String string) throws InterruptedException, IOException {
        return Torrent.create(file, null, null, list, string);
    }

    public static Torrent create(File file, List<File> list, List<List<URI>> list2, String string) throws InterruptedException, IOException {
        return Torrent.create(file, list, null, list2, string);
    }

    private static Torrent create(File file, List<File> list, URI serializable, List<List<URI>> object, String string) throws InterruptedException, IOException {
        Serializable serializable2;
        Object object2;
        Serializable serializable3;
        Object object3;
        if (list != null) {
            list.isEmpty();
        }
        HashMap<String, b> hashMap = new HashMap<String, b>();
        if (serializable != null) {
            hashMap.put("announce", new b(((URI)serializable).toString()));
        }
        if (object != null) {
            serializable = new LinkedList();
            object = object.iterator();
            while (object.hasNext()) {
                object3 = (List)object.next();
                serializable3 = new LinkedList<b>();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    serializable2 = (URI)object2.next();
                    serializable3.add((b)new b(((URI)serializable2).toString()));
                }
                serializable.add(new b((List<b>)((Object)serializable3)));
            }
            hashMap.put("announce-list", new b((List<b>)((Object)serializable)));
        }
        hashMap.put("creation date", new b(new Date().getTime() / 1000L));
        hashMap.put("created by", new b(string));
        serializable = new TreeMap<String, b>();
        serializable.put("name", new b(file.getName()));
        serializable.put("piece length", new b(524288));
        if (list == null || list.isEmpty()) {
            serializable.put("length", new b(file.length()));
            serializable.put("pieces", new b(Torrent.hashFile(file), BYTE_ENCODING));
        } else {
            object = new LinkedList<b>();
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = new HashMap<String, b>();
                object2.put("length", new b(((File)serializable3).length()));
                serializable2 = new LinkedList();
                for (serializable3 = (File)object3.next(); serializable3 != null && !((File)serializable3).equals(file); serializable3 = ((File)serializable3).getParentFile()) {
                    ((LinkedList)serializable2).addFirst(new b(((File)serializable3).getName()));
                }
                object2.put("path", new b((List<b>)((Object)serializable2)));
                object.add(new b((Map<String, b>)object2));
            }
            serializable.put("files", new b((List<b>)object));
            serializable.put("pieces", new b(Torrent.hashFiles(list), BYTE_ENCODING));
        }
        hashMap.put("info", new b((Map<String, b>)((Object)serializable)));
        object = new ByteArrayOutputStream();
        a.a(new b(hashMap), (OutputStream)object);
        return new Torrent(((ByteArrayOutputStream)object).toByteArray(), true);
    }

    private static String hashFile(File file) throws InterruptedException, IOException {
        return Torrent.hashFiles(Arrays.asList(file));
    }

    private static String hashFiles(List<File> object) throws InterruptedException, IOException {
        int n = Torrent.getHashingThreadsCount();
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(524288);
        LinkedList<Future<String>> linkedList = new LinkedList<Future<String>>();
        StringBuilder stringBuilder = new StringBuilder();
        System.nanoTime();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (File)object.next();
            ((File)object2).length();
            object2 = new FileInputStream((File)object2);
            FileChannel fileChannel = ((FileInputStream)object2).getChannel();
            int n2 = 10;
            try {
                while (fileChannel.read(byteBuffer) > 0) {
                    if (byteBuffer.remaining() == 0) {
                        byteBuffer.clear();
                        linkedList.add(executorService.submit(new CallableChunkHasher(byteBuffer)));
                    }
                    if (linkedList.size() >= n) {
                        Torrent.accumulateHashes(stringBuilder, linkedList);
                    }
                    if (!((double)fileChannel.position() / (double)fileChannel.size() * 100.0 > (double)n2)) continue;
                    n2 += 10;
                }
            }
            finally {
                fileChannel.close();
                ((FileInputStream)object2).close();
            }
        }
        if (byteBuffer.position() > 0) {
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.position(0);
            linkedList.add(executorService.submit(new CallableChunkHasher(byteBuffer)));
        }
        Torrent.accumulateHashes(stringBuilder, linkedList);
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(10L);
        }
        System.nanoTime();
        return stringBuilder.toString();
    }

    private static int accumulateHashes(StringBuilder stringBuilder, List<Future<String>> list) throws InterruptedException, IOException {
        try {
            int n = list.size();
            for (Future<String> future : list) {
                stringBuilder.append(future.get());
            }
            list.clear();
            return n;
        }
        catch (ExecutionException executionException) {
            throw new IOException("Error while hashing the torrent data!", executionException);
        }
    }

    static class CallableChunkHasher
    implements Callable<String> {
        private MessageDigest md = null;
        private final ByteBuffer data;

        CallableChunkHasher(ByteBuffer byteBuffer) {
            try {
                this.md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
                noSuchAlgorithmException.printStackTrace();
            }
            this.data = ByteBuffer.allocate(byteBuffer.remaining());
            byteBuffer.mark();
            this.data.put(byteBuffer);
            this.data.clear();
            byteBuffer.reset();
        }

        @Override
        public String call() throws UnsupportedEncodingException {
            this.md.reset();
            this.md.update(this.data.array());
            return new String(this.md.digest(), Torrent.BYTE_ENCODING);
        }
    }

    public class BtSubFile {
        public String fileName;
        public long fileSize;
        public int fileId;
    }

    public static class TorrentFile {
        public final File file;
        public final long size;

        public TorrentFile(File file, long l) {
            this.file = file;
            this.size = l;
        }
    }
}

