/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.base;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class XLLog {
    public static final boolean DEBUG_MODE = false;
    public static final String SD_FILE_PATH = "/xunlei/xl-acc-log";
    private static final String LOG_NAME = "/acc-log";
    public static final int LOG_NO = 0;
    public static final int LOG_LOGCAT = 1;
    public static final int LOG_FILE = 2;
    public static final int LOG_BOTH = 3;
    private static int mLogLevel = 3;
    private static LogHandler mLogHandler = null;
    private static SimpleDateFormat mSdf = null;

    private XLLog() {
    }

    public static void i(String string, String string2) {
    }

    public static void d(String string, String string2) {
    }

    public static void v(String string, String string2) {
    }

    public static void w(String string, String string2) {
    }

    public static void e(String string, String string2) {
    }

    public static void e(String string, Throwable throwable) {
    }

    public static void logHeapStats(String string, Context context) {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(memoryInfo);
        context = new Debug.MemoryInfo();
        Debug.getMemoryInfo((Debug.MemoryInfo)context);
        long l = Debug.getNativeHeapSize();
        long l2 = Debug.getNativeHeapAllocatedSize();
        long l3 = Debug.getNativeHeapFreeSize();
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        Log.d((String)string, (String)("heap_stats heap_size=" + decimalFormat.format((float)l / 1048576.0f) + "M allocated=" + decimalFormat.format((float)l2 / 1048576.0f) + "M free=" + decimalFormat.format((float)l3 / 1048576.0f) + "M memory_stats " + "memory_usage=" + decimalFormat.format((float)context.getTotalPss() / 1024.0f) + "M dalvik_usage=" + decimalFormat.format((float)context.dalvikPss / 1024.0f) + "M native_usage=" + decimalFormat.format((float)context.nativePss / 1024.0f) + "M other_usage=" + decimalFormat.format((float)context.otherPss / 1024.0f) + "M system_stats " + "system_available=" + decimalFormat.format((float)memoryInfo.availMem / 1048576.0f) + "M"));
    }

    public static void logStackTrace(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.getAllStackTraces();
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray.get(Thread.currentThread());
        stackTraceElementArray = stackTraceElementArray2;
        stackTraceElementArray = stackTraceElementArray2;
        int n = stackTraceElementArray2.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            Log.d((String)string, (String)stackTraceElement.toString());
        }
    }

    public static void flush() {
        mLogHandler.flush();
    }

    private static void initFileHandler() {
        if (mLogHandler == null) {
            mLogHandler = new LogHandler();
        }
    }

    private static void sendHandlerMsg(String string, String string2, String string3) {
        if (mSdf == null) {
            mSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(mSdf.format(Calendar.getInstance().getTime())).append(" [");
        stringBuilder.append("Thread-").append(Thread.currentThread().getId()).append("] ");
        stringBuilder.append(string.toUpperCase()).append(" ");
        stringBuilder.append(string2).append(" : ").append(string3);
        string = mLogHandler.obtainMessage();
        mLogHandler.obtainMessage().obj = stringBuilder.toString();
        mLogHandler.sendMessage((Message)string);
    }

    private static boolean isExternalStorageAvailable() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    private static File getLogFileDirectory() {
        Object object = Environment.getExternalStorageDirectory().getAbsolutePath() + SD_FILE_PATH;
        if (!((File)(object = new File((String)object))).exists()) {
            ((File)object).mkdirs();
        }
        return object;
    }

    static class LogHandler
    extends Handler {
        private FileOutputStream mLogOutput = null;
        private File mLogFile = null;
        private static int mLogIndex = 0;

        public LogHandler() {
            this.createLogFile();
        }

        public void handleMessage(Message object) {
            Object object2;
            block7: {
                if (this.mLogFile == null) {
                    return;
                }
                try {
                    if (this.mLogOutput == null) {
                        this.mLogOutput = new FileOutputStream(this.mLogFile, true);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    object2 = fileNotFoundException;
                    fileNotFoundException.printStackTrace();
                    if (this.createLogFile()) break block7;
                    return;
                }
            }
            if (this.mLogOutput != null && (object2 = (String)object.obj + "\n\n") != null) {
                object = ((String)object2).getBytes();
                try {
                    this.mLogOutput.write((byte[])object, 0, ((Message)object).length);
                    return;
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                    this.mLogOutput = null;
                }
            }
        }

        public void flush() {
            if (this.mLogOutput != null) {
                try {
                    this.mLogOutput.flush();
                    return;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    iOException.printStackTrace();
                }
            }
        }

        private boolean createLogFile() {
            File file;
            if (XLLog.isExternalStorageAvailable()) {
                file = XLLog.getLogFileDirectory();
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                this.mLogFile = null;
                return false;
            }
            this.mLogFile = this.getValidLogFile(file.getAbsolutePath());
            return true;
        }

        private File getValidLogFile(String string) {
            Object object;
            while (true) {
                object = ".txt";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string).append(XLLog.LOG_NAME);
                if (mLogIndex == 0) {
                    stringBuffer.append((String)object);
                } else {
                    stringBuffer.append("-").append(mLogIndex).append((String)object);
                }
                object = new File(stringBuffer.toString());
                if (!((File)object).exists()) {
                    try {
                        ((File)object).createNewFile();
                        break;
                    }
                    catch (IOException iOException) {
                        XLLog.e("getValidLogFile", "create log file error = " + iOException.getMessage());
                    }
                }
                ++mLogIndex;
            }
            return object;
        }
    }
}

