/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.base;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import com.xunlei.common.base.XLLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class XLCrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandler";
    public static final String SD_FILE_PATH = "/xunlei/xl-acc-crash/";
    private Thread.UncaughtExceptionHandler mDefaultHandler = null;
    private static XLCrashHandler INSTANCE = null;
    private Context mContext = null;
    private Map<String, String> mDevInfos = new HashMap<String, String>();
    private DateFormat mFormatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");

    private XLCrashHandler() {
    }

    public static XLCrashHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new XLCrashHandler();
        }
        return INSTANCE;
    }

    public void init(Context context) {
        this.mContext = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (!this.handleException(throwable) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, throwable);
            return;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            XLLog.e(TAG, "error : " + interruptedException.getMessage());
        }
        Process.killProcess((int)Process.myPid());
        System.exit(1);
    }

    private boolean handleException(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                Toast.makeText((Context)XLCrashHandler.this.mContext, (CharSequence)"\u5f88\u62b1\u6b49,\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38,\u5373\u5c06\u9000\u51fa.", (int)1).show();
                Looper.loop();
            }
        }.start();
        this.collectDeviceInfo(this.mContext);
        this.saveCrashInfo2File(throwable);
        return true;
    }

    public void collectDeviceInfo(Context fieldArray) {
        Object object;
        try {
            object = fieldArray.getPackageManager();
            fieldArray = object.getPackageInfo(fieldArray.getPackageName(), 1);
            if (fieldArray != null) {
                object = fieldArray.versionName == null ? "null" : fieldArray.versionName;
                String string = "" + fieldArray.versionCode;
                this.mDevInfos.put("versionName", (String)object);
                this.mDevInfos.put("versionCode", string);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            XLLog.e(TAG, "an error occured when collect package info = " + nameNotFoundException.getMessage());
        }
        fieldArray = object = Build.class.getDeclaredFields();
        int n = ((Field[])object).length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            try {
                field.setAccessible(true);
                this.mDevInfos.put(field.getName(), field.get(null).toString());
                XLLog.d(TAG, field.getName() + " : " + field.get(null));
                continue;
            }
            catch (Exception exception) {
                XLLog.e(TAG, "an error occured when collect crash info = " + exception.getMessage());
            }
        }
    }

    private static String getCrashFileDirectory() {
        String string = Environment.getExternalStorageDirectory().getAbsolutePath() + SD_FILE_PATH;
        return string;
    }

    private String saveCrashInfo2File(Throwable object) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : this.mDevInfos.entrySet()) {
            object2 = entry.getKey();
            String object32 = entry.getValue();
            stringBuffer.append((String)object2 + "=" + object32 + "\n");
        }
        Object object4 = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)object4);
        ((Throwable)object).printStackTrace(printWriter);
        for (object2 = ((Throwable)object).getCause(); object2 != null; object2 = ((Throwable)object2).getCause()) {
            ((Throwable)object2).printStackTrace(printWriter);
        }
        printWriter.close();
        String string = object4.toString();
        stringBuffer.append(string);
        try {
            long l = System.currentTimeMillis();
            object = this.mFormatter.format(new Date());
            object = "xl-acc-crash-" + (String)object + "-" + l + ".txt";
            if (Environment.getExternalStorageState().equals("mounted")) {
                object4 = XLCrashHandler.getCrashFileDirectory();
                File file = new File((String)object4);
                if (!file.exists()) {
                    file.mkdirs();
                }
                object4 = new FileOutputStream((String)object4 + (String)object);
                ((FileOutputStream)object4).write(stringBuffer.toString().getBytes());
                ((OutputStream)object4).flush();
                ((FileOutputStream)object4).close();
            }
            return object;
        }
        catch (Exception exception) {
            XLLog.e(TAG, "an error occured while writing file " + exception.getMessage());
            return null;
        }
    }
}

