/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.base;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import java.util.HashMap;
import java.util.Map;

public class XLAlarmBaseTimer {
    private Map<String, TimerItem> mTimerCollection = new HashMap<String, TimerItem>();
    public static final String MY_ALARM_TIMER_INTENT_CATEGORY = "com.xunlei.xlkdemo.timer.CATEGORY";
    public static final String MY_ALARM_TIMER_ACTION_BASE = "com.xunlei.xlkdemo.timer.action_";
    public static final String MY_ALARM_TIMER_ID = "alarm_timer_id";
    private static XLAlarmBaseTimer mTimer = null;
    private static boolean mInited = false;
    private Context mContext = null;
    private BroadcastReceiver mTimerRecever = new BroadcastReceiver(){

        public void onReceive(Context object, Intent intent) {
            object = intent.getAction() + intent.getIntExtra(XLAlarmBaseTimer.MY_ALARM_TIMER_ID, 0);
            object = (TimerItem)XLAlarmBaseTimer.this.mTimerCollection.get(object);
            if (object == null) {
                return;
            }
            ((TimerItem)object).tick();
            if (!((TimerItem)object).isLoop()) {
                mTimer.unRegisterTimer(((TimerItem)object).getTimerId());
            }
        }
    };

    private XLAlarmBaseTimer() {
    }

    public static void init(Context context) {
        if (mInited) {
            return;
        }
        mInited = true;
        mTimer = new XLAlarmBaseTimer();
        new XLAlarmBaseTimer().mContext = context;
        context = new IntentFilter();
        context.addCategory(MY_ALARM_TIMER_INTENT_CATEGORY);
        context.addAction(MY_ALARM_TIMER_ACTION_BASE);
        context.setPriority(Integer.MAX_VALUE);
        XLAlarmBaseTimer.mTimer.mContext.registerReceiver(XLAlarmBaseTimer.mTimer.mTimerRecever, (IntentFilter)context);
    }

    public static void unInit() {
        if (!mInited) {
            return;
        }
        mInited = false;
        XLAlarmBaseTimer.mTimer.mContext.unregisterReceiver(XLAlarmBaseTimer.mTimer.mTimerRecever);
    }

    public static synchronized XLAlarmBaseTimer getInstance() {
        return mTimer;
    }

    public synchronized void registerTimer(int n, int n2, boolean bl, TimerListener timerListener) {
        TimerItem timerItem = new TimerItem(n, n2, bl, timerListener);
        this.mTimerCollection.put(TimerItem.getAction(n), timerItem);
        timerItem.start();
    }

    public synchronized void unRegisterTimer(int n) {
        TimerItem timerItem = this.mTimerCollection.get(TimerItem.getAction(n));
        if (timerItem != null) {
            timerItem.kill();
            this.mTimerCollection.remove(TimerItem.getAction(n));
        }
    }

    public void clearAllTimer() {
        for (String string : this.mTimerCollection.keySet()) {
            TimerItem object = this.mTimerCollection.get(string);
            object.kill();
        }
        this.mTimerCollection.clear();
    }

    public static class TimerItem {
        private int mTimerId = 0;
        private boolean mLoop = false;
        private TimerListener mListener = null;
        private int mExpireTime = 0;
        private PendingIntent mPendingIntent = null;

        public TimerItem(int n, int n2, boolean bl, TimerListener timerListener) {
            this.mTimerId = n;
            this.mExpireTime = n2;
            this.mLoop = bl;
            this.mListener = timerListener;
        }

        public static String getAction(int n) {
            return XLAlarmBaseTimer.MY_ALARM_TIMER_ACTION_BASE + String.valueOf(n);
        }

        public int getTimerId() {
            return this.mTimerId;
        }

        public void start() {
            Intent intent = new Intent(XLAlarmBaseTimer.MY_ALARM_TIMER_ACTION_BASE);
            intent.addCategory(XLAlarmBaseTimer.MY_ALARM_TIMER_INTENT_CATEGORY);
            intent.putExtra(XLAlarmBaseTimer.MY_ALARM_TIMER_ID, this.mTimerId);
            this.mPendingIntent = PendingIntent.getBroadcast((Context)mTimer.mContext, (int)this.mTimerId, (Intent)intent, (int)0x8000000);
            intent = (AlarmManager)mTimer.mContext.getSystemService("alarm");
            intent.setRepeating(0, System.currentTimeMillis() + (long)this.mExpireTime, (long)this.mExpireTime, this.mPendingIntent);
        }

        public void kill() {
            AlarmManager alarmManager = (AlarmManager)mTimer.mContext.getSystemService("alarm");
            alarmManager.cancel(this.mPendingIntent);
        }

        public void tick() {
            if (this.mListener != null) {
                this.mListener.onTimerTick(this.mTimerId);
            }
        }

        public boolean isLoop() {
            return this.mLoop;
        }

        public int getExpireTime() {
            return this.mExpireTime;
        }
    }

    public static interface TimerListener {
        public void onTimerTick(int var1);
    }
}

