package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpdateQuestionTask {
	private static final Logger logger = Logger.getLogger(UpdateQuestionTask.class.getName());

	public static void main(String[] args) {
		logger.info("=========开始更新工单中的VIP等级============");
		findNotDealForOneDay();
		logger.info("=========工单中的VIP等级更新完毕！===========");
	}

	
	/**
	 * 查询出超过 24小时还未处理的工单
	 */
	public static void findNotDealForOneDay(){
		   Connection conn = null;
		   PreparedStatement stmt = null;
		   Connection ctconn = null;
		   PreparedStatement ctstmt = null;
		   ResultSet crs = null;
		   String starttime = TaskLogUtil.getNowTime();
		   try{
		     ctconn = ConnUtil.getConnection();	
		     conn = ConnUtil.getConnection();	
             String sql = "select * from question ";
             ctstmt = ctconn.prepareStatement(sql);	  
             
             crs = ctstmt.executeQuery();
             while(crs.next()){
            	 String uid = crs.getString("userid");
            	 String usql = "UPDATE question SET vipGrade = (SELECT liveVipGrade FROM customerdetailquery WHERE uid = ?) WHERE userid = ?";
            	 stmt = conn.prepareStatement(usql);
            	 stmt.setString(1, uid);
            	 stmt.setString(2, uid);
            	 stmt.execute();
             }
             String endtime  = TaskLogUtil.getNowTime();	               
             TaskLogUtil.addLog("出超过 24小时还未处理的工单预警", "", starttime, endtime, true);
		   }catch(Exception e){
			   e.printStackTrace();
			   String endtime  = TaskLogUtil.getNowTime();	               
               TaskLogUtil.addLog("出超过 24小时还未处理的工单预警", e.getMessage(), starttime, endtime, false);
		   }finally{
			   try{
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
				   if(crs != null){//关闭连接
					   crs.close();
					   crs = null;
				   }
				   if(ctstmt != null){
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }				
	}
	
	
	/**
	 * 获得问题类别
	 * @return
	 */
	public static Map<String,String> getQuestionType(){
		return null;
	}
}
