package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;

public class UpdatePhoneTask {
	private static final Logger logger = Logger.getLogger(UpdatePhoneTask.class.getName());
	
	public static void main(String args[]){
		logger.info("开始执行更新大客户手机号的定时任务...");
		updatePhone();
		logger.info("大客户手机号任务执行完毕");
	}
	
	/**
	 * 由于调用远程接口是个非常耗时的操作，所以单独执行更新
	 */
	public static void updatePhone(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String time = sdf.format(new Date());
		Connection conn = null;
		Connection conn2 = null;
		Connection conn3 = null;
		ResultSet rs = null;
		Statement stmt = null;
		Statement stmt2 = null;
		Statement stmt3 = null;
		ResultSet rs3 = null;
		List<Map<String,Object>> beforedatas= new ArrayList<Map<String,Object>>();
		try{
			time = BigCustomerTask.formatBeforeDay(time);
			String beforetime = BigCustomerTask.formatBeforeDay(time);
			UserInfoProxy userInfoProxy  = ProxyFactory.getInstance().getUserInfoProxy();
			String sql = "select uid from bigcustomerdetail where daytime = ? ";
			sql = sql.replace("?", "'"+time+"'");
			logger.info("detailsql============>"+sql);
			
			conn = BigCustomerTask.getConnection();
			conn2 = BigCustomerTask.getConnection();
			conn3 = BigCustomerTask.getConnection();
			stmt = BigCustomerTask.getStatement(conn);
			stmt2 = BigCustomerTask.getStatement(conn2);
			stmt3 = BigCustomerTask.getStatement(conn3);
			rs = stmt.executeQuery(sql);	
			sql = "select uid,phone from bigcustomerdetail where daytime = ?";
			sql = sql.replace("?", "'"+beforetime+"'");
			logger.info("beforetimeql============>"+sql);
			rs3 = stmt3.executeQuery(sql);
			if(rs==null){
				logger.info("==========update phone error ,please check the time："+time+"of bigcustomerdetail");
				throw new XLRuntimeException("==========update phone error ,please check the time："+time+"of bigcustomerdetail");
			}	
			
			while(rs3.next()){
				Map<String,Object> m = new HashMap<String,Object>();
				m.put(rs3.getString("uid"), rs3.getString("phone"));
				beforedatas.add(m);
			}
			int line = 0;
			while(rs.next()){
				line++;				
				String uid = rs.getString("uid");
				logger.info("line="+line+",remote，getphone,uid="+uid);
				String beforephone = findBeforePhone(beforedatas,uid);
				sql = "update bigcustomerdetail set phone=1?  where uid=2? and  daytime=3?";
				String phone = null;
				if(beforephone==null){
					phone = getPhone(userInfoProxy,uid);
				}else{
					phone = beforephone;
				}
				if(phone==null||"".equals(phone))continue;
				sql = sql.replace("1?", "'"+phone+"'").replace("2?", "'"+uid+"'").replace("3?", "'"+time+"'");
				logger.info("sql============>"+sql);
				stmt2.executeUpdate(sql);
				logger.info("update success");
			}
			
			
		}catch(Exception e){
			logger.info("There is a error");
			logger.info(e.getMessage());
		}finally{
			try{
				beforedatas.clear();
				beforedatas = null;
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt2 != null){
					stmt2.close();
					stmt2 = null;
				}
				if(conn2 != null){
					conn2.close();
					conn2 = null;
				}
				if(rs3 != null){
					rs3.close();
					rs3 = null;
				}
				if(stmt3 != null){
					stmt3.close();
					stmt3 = null;
				}
				if(conn3 != null){
					conn3.close();
					conn3 = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
			}
		}

	}
	
	public static String findBeforePhone(List<Map<String,Object>> beforedatas,String uid){
		for(Map<String,Object> data:beforedatas){
			String beforephone = (String)(data.get(uid));
			if(beforephone != null&& !"".equals(beforephone.trim())){
				return beforephone;
			}
		}
		return null;
	}
	
	/**
	 * 调用远程接口查询出安全手机号
	 * @param account
	 * @return
	 */
	public static String getPhone(UserInfoProxy userInfoProxy,String account){	
		Resp_getuserinfo_sec userinfosec=userInfoProxy.getuserinfo_sec(account, (byte)2);
		if(userinfosec==null)return "";
		return userinfosec.getMobile()==0?"":userinfosec.getMobile()+"";
	}
}
