package com.xunlei.niux.manager.web.vo;


import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;


/**
 * 更新客户的充值游戏数和登录游戏数
 * @author lisu
 * 2013-05-11
 */
public class UpdateGameCountTask {
	private static final Logger logger = Logger.getLogger(UpdateGameCountTask.class.getName());
	private static String time = null;
	private static String customerInterface = "http://tw07286.sandai.net:8002/getPayAndLoginRecord?";
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 cal.add(Calendar.DAY_OF_MONTH, -1);
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间的前一天
		}
	}
	
	
	public static void main(String args[]){
	   make();
	}
	
	/**
	 * 更新客户的充值游戏数和登录游戏数
	 */
	public static void make(){	
	   logger.info("开始更新客户的充值游戏数和登录游戏数......");	
	   updateGameCount();
	   logger.info("更新客户的充值游戏数和登录游戏数完毕！");	   
	}	

	
	/**
	 * 更新客户的充值游戏数和登录游戏数
	 */
	public static void updateGameCount() {
		String starttime = TaskLogUtil.getNowTime();
		String baseUrl = getUrl();		
		String filepath = getFilesPath();		
		if(filepath.indexOf(",")>-1){//如果有多个文件
			for(String subFilePath:filepath.split(",")){
			   initData(baseUrl,subFilePath,starttime);
			}
		}else{//如果只有一个文件
			initData(baseUrl,filepath,starttime);
		}	
		String endtime  = TaskLogUtil.getNowTime();	               
        TaskLogUtil.addLog("更新客户的充值游戏数和登录游戏数", "", starttime, endtime, true);
	}
	
	/**
	 * 按照日期读出统计前一天的数据
	 * @return
	 */
	public static String getFilesPath(){				
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String strs[] = time.split("-");
		String filepath = null;
		String daytime = strs[0]+strs[1]+strs[2];
        try{
        	String sql = "select fileurl from bigcustomerquery where daytime=?";
        	conn = ConnUtil.getConnection();
        	pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, daytime);
 			rs = pstmt.executeQuery();
 			if(rs == null)return null;
 			rs.next();
 			filepath = rs.getString(1);
        }catch(Exception e){
        	e.printStackTrace();
        }finally{
        	try{
        		if(rs != null){
        			rs.close();
        			rs = null;
        		}
        		if(pstmt != null){
        			pstmt.close();
        			pstmt = null;
        		}
        		if(conn != null){
        			conn.close();
        			conn = null;
        		}
        	}catch(Exception e){
        		e.printStackTrace();
        	}
        }        		
		return filepath;		
	}
	
	/**
	 * 通过http的形式访问远程文件，并且读取文件中的数据，保存到数据库
	 * @param path
	 * @return
	 */
	public static void initData(String baseUrl,String filepath,String starttime){
		URL url = null;
		Connection uconn = null;
		PreparedStatement upstmt = null;
		ResultSet rs = null;
		try {
			url = new URL(baseUrl+filepath);			
		} catch (MalformedURLException e) {
			logger.info("文件找不到，文件路径为："+baseUrl+filepath+"，请查看是否正确。错误代码："+e.getMessage());
		} 
		HttpURLConnection httpUrl = null;
		BufferedReader br = null;
		//连接指定的网络资源 
		try {
			httpUrl = (HttpURLConnection) url.openConnection(); 
			httpUrl.connect();
			//获取网络输入流 
			br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 			
            logger.info("========开始解析文件:"+filepath+"=========");			
			String readLine = br.readLine();
			int line = 0;//读取的行号	
			uconn = ConnUtil.getConnection();
			Map gamepayMap = new HashMap();
			long gameCount = 0;
			long payGameCount = 0;
			while(readLine != null){				
					logger.info("line=============>"+line++);				
					//开始解析数据
					String arr[] = readLine.split(",");
					String uid = null;
					for(String data:arr){
						if(data.indexOf("userid=")>-1){													
							uid = data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim();//迅雷uid	
							if(uid == null||"".equals(uid)){
								continue;
							}
						}             			
					}
	                /////////////////////////////////////////////////////////////////////////////////////////
	                //计算激活游戏数和充值游戏数
	                getGameAndPayCount(gamepayMap,uid);
	                gameCount = gamepayMap==null?0:gamepayMap.get("gameCount")==null?0:(Long)gamepayMap.get("gameCount");
	                payGameCount = gamepayMap==null?0:gamepayMap.get("payGameCount")==null?0:(Long)gamepayMap.get("payGameCount");             
	            	String usql = "update customerdetailquery set gameCount=?,payCount=? where uid=?";
	            	upstmt = uconn.prepareStatement(usql);
	            	upstmt.setLong(2, gameCount);
	            	upstmt.setLong(2, payGameCount);
	            	upstmt.setString(3, uid);
	            	upstmt.execute();               
					                              
				//读取下一行的数据
				readLine = br.readLine();			   	
			}
		} catch (Exception e) {
			logger.info(e.getMessage());
			e.printStackTrace();
			String endtime  = TaskLogUtil.getNowTime();	               
	        TaskLogUtil.addLog("更新客户的充值游戏数和登录游戏数", "", starttime, endtime, true);
		}finally{
			try{
				if(upstmt != null){
					upstmt.close();
					upstmt = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(uconn != null){
					uconn.close();
					uconn = null;
				}
				if(br != null){
					br.close();
					br =  null;
				}
				if(httpUrl != null){
					httpUrl.disconnect();
					httpUrl = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
				e.printStackTrace();
			}
		}
	}
	
	
	
	/**
     * 获得文件服务器地址
     * @return
     */
	public static String getUrl(){
		String bigCustomerRemoteUrl= "http://twin13024.sandai.net:8080/hdfs-webdav";
		logger.info("获得文件服务器地址成功");
		return bigCustomerRemoteUrl;
	}
	
	
	/**
	 * 通过get方式调用接口
	 * @param url
	 * @return
	 */
	public static String getInfoForHttpGetMothed(String url) {
		try {
			logger.info(" Get/URL :" + url);
			HttpGet httpget = new HttpGet(url);
			HttpClient client = new DefaultHttpClient();
			String backStr = "";
			ResponseHandler<String> responseHandler = new BasicResponseHandler();
			backStr = client.execute(httpget, responseHandler);
			return backStr;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}
	
	
	/**
	 * 获得平台的激活游戏数和充值游戏数
	 */
	public static void getGameAndPayCount(Map map,String uid){	
		if(map != null)map.clear();
		String jsonStr = getInfoForHttpGetMothed(customerInterface+"uid="+uid+"&date="+time);
		if(jsonStr == null){
			return;
		}
		ObjectMapper mapper = new ObjectMapper();
		try {
			JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);			
			//绑定游戏详情数据
			List<Record> recordList = record.getList();								
			if(recordList == null||recordList.size()==0)return;
			long gameCount = 0L;//激活游戏数
			long payGameCount = 0L;//充值游戏数
			Set game = new HashSet();
			Set pay = new HashSet();	
			for(Record rec:recordList){
				if(rec.getFirstLoginTime() != null && !"".equals(rec.getFirstLoginTime())){
					game.add(rec.getGameId());
				}
				if(rec.getFirstPayTime() != null && !"".equals(rec.getFirstPayTime())){
					pay.add(rec.getGameId());
				}				
			}
			gameCount = game.size();
			payGameCount = pay.size();
			map.put("gameCount", gameCount);
			map.put("payGameCount", payGameCount);
		} catch (JsonParseException e) {
			e.printStackTrace();
		} catch (JsonMappingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
