package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;

public class UpdateCustomerTask {
	private static final Logger logger = Logger.getLogger(UpdateCustomerTask.class.getName());
	
	public static void main(String args[]){
		logger.info("开始执行更新客户信息的定时任务...");
		updateCustomer();
		//updateCallRecord();
		logger.info("客户信息更新任务执行完毕");
	}	
	
	/**
	 * 
	 * 更新用户的联系方式、个人信息
	 * 
	 */
	public static void updateCustomer(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String time = sdf.format(new Date());
		Connection conn = null;
		Connection conn2 = null;
		ResultSet rs = null;
		Statement stmt = null;
		Statement stmt2 = null;
		String starttime = TaskLogUtil.getNowTime();
		try{
			time = BigCustomerTask.formatBeforeDay(time);//当前日期的前一天
			UserInfoProxy userInfoProxy  = ProxyFactory.getInstance().getUserInfoProxy();
			String sql = "select uid,phone,contactNumber,qq,email,birthday from customerdetailquery where phone=''";	
			conn = ConnUtil.getConnection();
			conn2 = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			stmt2 = ConnUtil.getStatement(conn2);
			rs = stmt.executeQuery(sql);	
			if(rs==null){
				logger.info("==========update phone error ,please check the time："+time+"of customerdetailquery");
				return ;
			}	
			int line = 0;
			while(rs.next()){
				line++;				
				String uid = rs.getString("uid");//迅雷uid
				String bphone = rs.getString("phone");//安全手机
				String bcontactNumber = rs.getString("contactNumber");//联系方式
				String bqq = rs.getString("qq");
				String bemail = rs.getString("email");
				String bbirthday = rs.getString("birthday");
				
				logger.info("line="+line+",remote，getphone,uid="+uid);
				sql = "update customerdetailquery set phone=1?,account=2?,contactNumber=3?,qq=4?,email=5?,birthday=6?,lastUpdateTime=8?  where uid=7?";
				logger.info("sql============>"+sql);
				Resp_getuserinfo_sec userinfo = getUserInfo(userInfoProxy,uid);				
				Resp_getuserinfo_base userbaseinfo = getUserBaseInfo(userInfoProxy,uid);
				long phone = userinfo.getMobile();
				
				String mphone = phone<=0?null:(phone+"");
			    String  mcontactNumber =  userinfo.getTelphone();
			    long qq =  userinfo.getQq();
                String mqq =(qq ==0||qq==-1)?"":(qq+""); 
                String memail = userinfo.getMail();
                String mbirthday = formatTime(userbaseinfo.getBirthday());                
                
			    boolean flag = false;
                
			    if(checkData(mphone)){//如果新手机号不为空
			    	if(bphone == null){
			    		flag = true;
			    		bphone = mphone;
			    	}else{
			    		if(!bphone.equals(mphone)){
			    			flag = true;
				    		bphone = mphone;
			    		}
			    	}
			    }
               if(checkData(mcontactNumber)){//如果新联系方式不为空
            	   if(bcontactNumber == null){
            		   flag = true;
            		   bcontactNumber = mcontactNumber;
            	   }else{
            		   if(!bcontactNumber.equals(mcontactNumber)){
                		   flag = true;
                		   bcontactNumber = mcontactNumber;
            		   }
            	   }
               }
			   if(checkData(mqq)){
				   if(bqq == null){
					   flag = true;
					   bqq = mqq;
				   }else{
					   if(!bqq.equals(mqq)){
						   flag = true;
						   bqq = mqq;
					   }
				   }
			   }
			   if(checkData(memail)){
				   if(bemail == null){
					   flag = true;
					   bemail = memail;
				   }else{
					   if(!bemail.equals(memail)){
						   flag = true;
						   bemail = memail;
					   }
				   }
			   }
			   
			   if(checkData(mbirthday)){
				   if(bbirthday == null){
					   bbirthday = mbirthday;
				   }else{
					   if(!bbirthday.equals(mbirthday)){
						   bbirthday = mbirthday;
					   }
				   }
			   }
				sql = sql.replace("1?", "'"+(bphone)+"'")
				         .replace("2?", "'"+(userbaseinfo.getUserAccount()==null?userbaseinfo.getUsrname():userbaseinfo.getUserAccount())+"'")
				         .replace("3?", "'"+bcontactNumber+"'")
				         .replace("4?", "'"+bqq+"'")
				         .replace("5?", "'"+bemail+"'")
				         .replace("6?", "'"+bbirthday+"'")
				         .replace("8?", "'"+(flag?time:"")+"'")
				         .replace("7?", "'"+uid+"'");
				logger.info("mobile============>"+bcontactNumber);
				logger.info("mail============>"+bemail);
				stmt2.executeUpdate(sql);
				logger.info("update success");
		    }
			String endtime  = TaskLogUtil.getNowTime();	               
            TaskLogUtil.addLog("更新客户个人信息", "", starttime, endtime, true);
		}catch(Exception e){
			 e.printStackTrace();
			 String endtime  = TaskLogUtil.getNowTime();	               
             TaskLogUtil.addLog("更新客户个人信息", e.getMessage(), starttime, endtime, false);
			logger.info(e.getMessage());
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt2 != null){
					stmt2.close();
					stmt2 = null;
				}
				if(conn2 != null){
					conn2.close();
					conn2 = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
			}
		}
	}
	
	public static boolean checkData(String data){
		if(data == null)return false;
		if("".equals(data)) return false;
		if("-1".equals(data))return false;
		if("0".equals(data))return false;
		if("*".equals(data))return false;
		return true;
	}
	
	public static String findBeforePhone(List<Map<String,Object>> beforedatas,String uid){
		for(Map<String,Object> data:beforedatas){
			String beforephone = (String)(data.get(uid));
			if(beforephone != null&& !"".equals(beforephone.trim())){
				return beforephone;
			}
		}
		return null;
	}
	
	/**
	 * 调用远程接口查询用户信息
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_sec getUserInfo(UserInfoProxy userInfoProxy,String uid){	
		Resp_getuserinfo_sec userinfosec = userInfoProxy.getuserinfo_sec(uid, (byte)2);
		return userinfosec;
	}
	
	/**
	 * 调用远程接口查询用户基本信息
	 * @param userInfoProxy
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_base getUserBaseInfo(UserInfoProxy userInfoProxy,String uid){
		Resp_getuserinfo_base userinfobase = userInfoProxy.getuserinfo_base(uid, (byte)2);
		return userinfobase;
	}
	
	
	/**
	 * 格式化日期
	 * @param day
	 * @return
	 */
	public static String formatTime(String time){
		logger.info("time===================>"+time);
		if(time==null||"".equals(time.trim()))return "";	
		if(time.length() != 8){			
			return "";
		}
		String year = time.substring(0, 4);		
  		String tmp = time.substring(4, 8);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2);
        return year+"-"+month+"-"+day;
	}
}
