package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import com.xunlei.niux.manager.web.util.HttpClientUtil;


public class UpdateCustomerIntegralTask {
	private static final Logger logger = Logger.getLogger(UpdateCustomerIntegralTask.class.getName());
	private static String BONUSURL = "http://bonus.niu.xunlei.com:7070/querybonus.do?";//查询用户平台总积分接口地址
	
	public static void main(String args[]){
		logger.info("开始执行更新客户平台总积分...");
		updateCustomerIntegral();
		logger.info("客户平台总积分更新任务执行完毕");
	}		
	
	/**
	 * 
	 * 更新用户的联系方式、个人信息，包括外呼记录 和 积分
	 * 
	 */
	public static void updateCustomerIntegral(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String time = sdf.format(new Date());
		Connection conn = null;
		Connection conn2 = null;
		ResultSet rs = null;
		Statement stmt = null;
		Statement stmt2 = null;
		String starttime = TaskLogUtil.getNowTime();
		try{
			String sql = "select uid from customerdetailquery";	
			conn = ConnUtil.getConnection();
			conn2 = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			stmt2 = ConnUtil.getStatement(conn2);
			rs = stmt.executeQuery(sql);	
			if(rs==null){
				logger.info("==========update phone error ,please check the time："+time+"of customerdetailquery");
				return ;
			}	
			int line = 0;
			while(rs.next()){
				line++;				
				String uid = rs.getString("uid");
				logger.info("line="+line+",remote，getphone,uid="+uid);
				sql = "update customerdetailquery set integral=1?  where uid=2?";
				logger.info("sql============>"+sql);
				int bonusSum = getBonusSum(uid);
				sql = sql.replace("1?", "'"+bonusSum+"'")
				         .replace("2?", "'"+uid+"'");
				
				stmt2.executeUpdate(sql);
				logger.info("update success");
		    }
			String endtime  = TaskLogUtil.getNowTime();	               
            TaskLogUtil.addLog("更新客户平台总积分", "", starttime, endtime, true);
		}catch(Exception e){
			 e.printStackTrace();
			 String endtime  = TaskLogUtil.getNowTime();	               
             TaskLogUtil.addLog("更新客户平台总积分", e.getMessage(), starttime, endtime, false);
			logger.info(e.getMessage());
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt2 != null){
					stmt2.close();
					stmt2 = null;
				}
				if(conn2 != null){
					conn2.close();
					conn2 = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
			}
		}
	}
	
	
	/**
	 * 获得用户平台总积分
	 * @return
	 */
	public static int getBonusSum(String uid) throws Exception{
		String url = BONUSURL + "userId="+uid;
		String reponseText = HttpClientUtil.getHtml(url);
		String subs[] = reponseText.split(",");
		int sum = 0;
		for(String sub:subs){
			if(sub.indexOf("rechargeSum")>-1){
				String datas[] = sub.split(":");
				sum = Integer.parseInt(datas[1]);
				break;
			}
		}
	  return sum;	
	}	
	
}
