package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;

public class UpdateAccountTask {
	private static final Logger logger = Logger.getLogger(UpdateAccountTask.class.getName());
	
	public static void main(String args[]){
		logger.info("开始执行更新账号的定时任务...");
		updateCustomer();
		logger.info("账号信息更新执行完毕");
	}	
	
	/**
	 * 
	 * 更新用户的联系方式、个人信息，包括外呼记录 和 积分
	 * 
	 */
	public static void updateCustomer(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String time = sdf.format(new Date());
		Connection conn = null;
		Connection conn2 = null;
		ResultSet rs = null;
		Statement stmt = null;
		Statement stmt2 = null;
		String starttime = TaskLogUtil.getNowTime();
		try{
			time = BigCustomerTask.formatBeforeDay(time);//当前日期的前一天
			UserInfoProxy userInfoProxy  = ProxyFactory.getInstance().getUserInfoProxy();
			String sql = "select uid from customerdetailquery";	
			conn = ConnUtil.getConnection();
			conn2 = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			stmt2 = ConnUtil.getStatement(conn2);
			rs = stmt.executeQuery(sql);	
			if(rs==null){
				logger.info("==========update phone error ,please check the time："+time+"of customerdetailquery");
				return ;
			}	
			int line = 0;
			while(rs.next()){
				line++;				
				String uid = rs.getString("uid");
				logger.info("line="+line+",remote，getphone,uid="+uid);
				sql = "update customerdetailquery set account=1?  where uid=2?";
				logger.info("sql============>"+sql);	
				Resp_getuserinfo_base userbaseinfo = getUserBaseInfo(userInfoProxy,uid);
				sql = sql.replace("1?", "'"+(userbaseinfo.getUserAccount()==null?userbaseinfo.getUsrname():userbaseinfo.getUserAccount())+"'")
				         .replace("2?", "'"+uid+"'");
				
				stmt2.executeUpdate(sql);
				logger.info("uid="+uid+",update success");
		    }
			String endtime  = TaskLogUtil.getNowTime();	               
            TaskLogUtil.addLog("更新客户个人信息", "", starttime, endtime, true);
		}catch(Exception e){
			 e.printStackTrace();
			 String endtime  = TaskLogUtil.getNowTime();	               
             TaskLogUtil.addLog("更新客户个人信息", e.getMessage(), starttime, endtime, false);
			logger.info(e.getMessage());
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt2 != null){
					stmt2.close();
					stmt2 = null;
				}
				if(conn2 != null){
					conn2.close();
					conn2 = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
			}
		}
	}
	
	
	
	/**
	 * 调用远程接口查询用户信息
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_sec getUserInfo(UserInfoProxy userInfoProxy,String uid){	
		Resp_getuserinfo_sec userinfosec = userInfoProxy.getuserinfo_sec(uid, (byte)2);
		return userinfosec;
	}
	
	/**
	 * 调用远程接口查询用户基本信息
	 * @param userInfoProxy
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_base getUserBaseInfo(UserInfoProxy userInfoProxy,String uid){
		Resp_getuserinfo_base userinfobase = userInfoProxy.getuserinfo_base(uid, (byte)2);
		return userinfobase;
	}
	
	
	/**
	 * 格式化日期
	 * @param day
	 * @return
	 */
	public static String formatTime(String time){
		logger.info("time===================>"+time);
		if(time==null||"".equals(time.trim()))return "";	
		if(time.length() != 8){			
			return "";
		}
		String year = time.substring(0, 4);		
  		String tmp = time.substring(4, 8);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2);
        return year+"-"+month+"-"+day;
	}
	
}
