package com.xunlei.niux.manager.web.vo;


import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;

public class QueryAccountById {
	private static final Logger logger = Logger.getLogger(QueryAccountById.class.getName());
	
	public static void main(String args[]){
		System.out.println("name:"+args[0]+",uid:"+findUidByName(args[0]));
	}	
	
	public static String findUidByName(String name){
		  UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
		  String userid = null;
	        try
	        {
	            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(name, (byte)-1);
	            if(userInfo.isOk())
	                userid = String.valueOf(userInfo.getUserno());
	        }
	        catch(Exception e)
	        {
	            logger.error((new StringBuilder()).append("getUserIdByUserName exception:").append(e).toString());
	            throw new XLRuntimeException(e);
	        }
	        return userid;
	}
	
	/**
	 * 
	 * 更新用户的联系方式、个人信息，包括外呼记录 和 积分
	 * 
	 */
	public static void findCustomer(int i,String uid){
		try{
			    UserInfoProxy userInfoProxy  = ProxyFactory.getInstance().getUserInfoProxy();
				Resp_getuserinfo_sec userinfo = getUserInfo(userInfoProxy,uid);				
				Resp_getuserinfo_base userbaseinfo = getUserBaseInfo(userInfoProxy,uid);
				long mobile = userinfo.getMobile();
				String account = userbaseinfo.getUserAccount();
				String username = userbaseinfo.getUsrname();
				String telphone = userinfo.getTelphone();
				long qq = userinfo.getQq();
				String mai = userinfo.getMail();
				System.out.println("line:"+i+",uid:"+uid+",account:"+account+",username:"+username+",telphone:"+telphone+",qq:"+qq+",mail:"+mai+",mobile:"+mobile);
		}catch(Exception e){
			 e.printStackTrace();
		}
	}
	
	
	public static String findBeforePhone(List<Map<String,Object>> beforedatas,String uid){
		for(Map<String,Object> data:beforedatas){
			String beforephone = (String)(data.get(uid));
			if(beforephone != null&& !"".equals(beforephone.trim())){
				return beforephone;
			}
		}
		return null;
	}
	
	public static String getUidByAccount(UserInfoProxy userInfoProxy,String account){
		String userid = null;
		Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(account, (byte)-1);
        if(userInfo.isOk())
            userid = String.valueOf(userInfo.getUserno());        
         return userid;
	}
	
	/**
	 * 调用远程接口查询用户信息
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_sec getUserInfo(UserInfoProxy userInfoProxy,String uid){	
		Resp_getuserinfo_sec userinfosec = userInfoProxy.getuserinfo_sec(uid, (byte)2);
		return userinfosec;
	}
	
	/**
	 * 调用远程接口查询用户基本信息
	 * @param userInfoProxy
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_base getUserBaseInfo(UserInfoProxy userInfoProxy,String uid){
		Resp_getuserinfo_base userinfobase = userInfoProxy.getuserinfo_base(uid, (byte)2);
		return userinfobase;
	}
	
	
	/**
	 * 格式化日期
	 * @param day
	 * @return
	 */
	public static String formatTime(String time){
		logger.info("time===================>"+time);
		if(time==null||"".equals(time.trim()))return "";	
		if(time.length() != 8){			
			return "";
		}
		String year = time.substring(0, 4);		
  		String tmp = time.substring(4, 8);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2);
        return year+"-"+month+"-"+day;
	}
}
