package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;

/**
 * 同步在线人数等实时数据定时任务
 * @author lisu
 * 2013-03-22
 */
public class LiveCountTask {

	private static final Logger logger = Logger.getLogger(LiveCountTask.class.getName());	
    private static String time = null;
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间
		}
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		logger.info("开始同步逆袭参与人数......");	
		syncCounterAttack();
		logger.info("逆袭参与人数同步完毕！");	
	}

	/**
	 * 同步逆袭参与人数和逆袭成功人数
	 */
	public static void syncCounterAttack(){
		Connection conn = null;
		Connection pconn = null;
		PreparedStatement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try{
		    conn = ConnUtil.getConnection();
		    pconn = ConnUtil.getConnection();
		    String sql = "SELECT COUNT(*) FROM counterattack  UNION ALL SELECT COUNT(*) FROM  counterattack WHERE isSuccess=1";
		    stmt = conn.prepareStatement(sql);
		    rs = stmt.executeQuery();
		    int i = 1;
		    long allCount = 0L;
		    long successCount = 0L;
		    while(rs.next()){
		    	if(i == 1){
		    		allCount = rs.getLong(1);
		    	}else{
		    		successCount = rs.getLong(1);
		    	}
		    	i++;
		    }
		    sql = "update livecount set liveCount="+allCount+" where seqid=1";//逆袭参与人数
		    pstmt = pconn.prepareStatement(sql);
		    pstmt.execute();
		    
		    sql = "update livecount set liveCount="+successCount+" where seqid=2";//逆袭成功人数
		    pstmt = pconn.prepareStatement(sql);
		    pstmt.execute();
		}catch(Exception e){
			logger.info("syncCounterAttack error exception:"+e.getMessage()+",time="+time);
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){//关闭数据库连接
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}	
	}
}
