package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import com.xunlei.niux.manager.web.util.HttpClientUtil;

/**
 * 每月月初，初始化代金券记录
 * @author lisu
 * 2013-03-15
 */
public class InitCardTask {
	private static final Logger logger = Logger.getLogger(InitCardTask.class.getName());
	private static final String url = "http://dynamic.vip.xunlei.com/xljinku/checkcash/?act=4010";//查询代金券剩余数量
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		logger.info("========开始初始化每月代金券数===========");
		init();
		clearCount();
		logger.info("========每月代金券数初始化完毕===========");
	}
	
	/**
	 * 初始化数据
	 */
	public static void init(){
		Connection conn = null;
		PreparedStatement ctstmt = null;	
		Connection sconn = null;
		PreparedStatement sctstmt = null;	
		ResultSet rs = null;
		SimpleDateFormat nsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String nowtime = nsdf.format(new Date());
		String starttime = TaskLogUtil.getNowTime();
		try {
			logger.info("开始调用远程接口获得代金券数量");
			String reponseText = HttpClientUtil.getHtml(url);
			logger.info("reponseText===============>"+reponseText);
			logger.info("代金券数量获得成功!");
			String datas[] = reponseText.split("&");
			int  monthlimit = 0; // 1：按月发放 0：按天发放
			long leavecount = 0L; //可使用总数量
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			String now = sdf.format(new Date());
			String strs[] = now.split("-");
			String month = strs[0]+"-"+strs[1];
			conn = ConnUtil.getConnection();
			sconn = ConnUtil.getConnection();
			for(String data:datas){
				if(data.indexOf("ret") != -1){
					String ret = data.split("=")[1];
					if(Integer.parseInt(ret) != 0){
						throw new Exception("代金券数量初始化失败，调用会员接口查询失败");
					}
				}
				if(data.indexOf("monthlimit") != -1){
					String m = data.split("=")[1];
					monthlimit = Integer.parseInt(m);
					if(monthlimit != 1){//如果不是按月发放代金券
						throw new Exception("代金券数量初始化失败，检查到代金券不是按月发放");
					}
				}
				if(data.indexOf("remain") != -1){
					String m = data.split("=")[1];
					leavecount = Long.parseLong(m);
				}
			}
			
			/**
			 * 初始化时首先检查是否有当月代金券记录
			 */
			String selectsql = "select count(*) from carddistribution where month = ?";			
			sctstmt = sconn.prepareStatement(selectsql);
			sctstmt.setString(1, month);
			rs = sctstmt.executeQuery();
			int count = 0;
			if(rs != null && rs.next()){
				count = rs.getInt(1);
			}
			logger.info("count==========================>"+count);
			if(count > 0){//如果存在当月代金券使用记录，则说明有人手动初始化了，则只需要修改成真实的数量
				//检查代金券总数量是否够用
				selectsql = "select totalCount-usedCount from carddistribution where month = ?";			
				sctstmt = sconn.prepareStatement(selectsql);
				sctstmt.setString(1, month);
				rs = sctstmt.executeQuery();
				int leaveCount = 0;
				if(rs.next()){
					leaveCount = rs.getInt(1);
				}
				if(leaveCount < 0){
					throw new Exception("代金券数量初始化失败，代金券剩余总数量小于已手动分配的数量，请及时调整，否则影响代金券正常发放！少了："+(-leaveCount));
				}
				
				//更新成每月代金券真实的数量
				String sql = "update carddistribution set totalCount=?,leaveCount=totalCount-usedCount where month=?";
				ctstmt = conn.prepareStatement(sql);
				ctstmt.setLong(1, leavecount);
				ctstmt.setString(2, month);
				ctstmt.executeUpdate();	
				
			}else{//如果不存在，则需要新增
				String sql = "insert into carddistribution values(?,?,?,?,?,?,?)";
				ctstmt = conn.prepareStatement(sql);
				ctstmt.setString(1, null);//月卡
				ctstmt.setLong(2, leavecount);
				ctstmt.setLong(3, 0);
				ctstmt.setLong(4, leavecount);
				ctstmt.setLong(5, 0);
				ctstmt.setString(6, month);
				ctstmt.setString(7, "系统初始化");
				ctstmt.execute();							
			}			
			String endtime  = TaskLogUtil.getNowTime();	               
            TaskLogUtil.addLog("每月代金券初始化", "", starttime, endtime, true);
			logger.info("init card success leavecount="+leavecount+",time="+nowtime);
		} catch (Exception e) {
			e.printStackTrace();
			 String endtime  = TaskLogUtil.getNowTime();	               
             TaskLogUtil.addLog("每月代金券初始化", e.getMessage(), starttime, endtime, false);
			logger.error("init card error . The reason is :"+e.getMessage()+",time:"+nowtime);
		}finally{
			try{
				if(ctstmt != null){
					ctstmt.close();
					ctstmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(sctstmt != null){
					sctstmt.close();
					sctstmt = null;
				}
				if(sconn != null){
					sconn.close();
					sconn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	
	/**
	 * 每月第一天检查，该月活动是否跨月，如果有跨月，则本月的数量默认跟上月一致
	 */
	private static void clearCount(){
		Connection conn = null;
		PreparedStatement ctstmt = null;	
		Connection sconn = null;
		PreparedStatement sctstmt = null;	
		PreparedStatement sumstmt = null;
		PreparedStatement ustmt = null;
		Connection sumconn = null;
		Connection uconn = null;
		ResultSet rs = null;
		ResultSet sumrs = null;
		SimpleDateFormat nsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String nowtime = nsdf.format(new Date());
		String nowmonth = nowtime.substring(0,7);
		String starttime = TaskLogUtil.getNowTime();
		String biznistrs = "";
		try{
			conn = ConnUtil.getConnection();
			sconn = ConnUtil.getConnection();
			sumconn = ConnUtil.getConnection();
			uconn = ConnUtil.getConnection();
			String selectsql = "select actNo from cardbizi WHERE  (DATE_FORMAT(actToTime,'%m') - DATE_FORMAT(NOW(),'%m'))>=0 AND (DATE_FORMAT(NOW(),'%m') - DATE_FORMAT(actFromTime,'%m'))>=1";
			ctstmt = conn.prepareStatement(selectsql);
			logger.info("selectsql===========================>"+selectsql);
			rs = ctstmt.executeQuery();
			String updatesql = null;	
			long allcount = 0l;
			while(rs.next()){
				String actNo = rs.getString(1);
				biznistrs += actNo+",";
				updatesql = "UPDATE cardcount SET usedcount = 0,leavecount = allcount  WHERE actNo='"+actNo+"'";
				logger.info("updatesql===========================>"+updatesql);
				sctstmt = sconn.prepareStatement(updatesql);
				sctstmt.executeUpdate();
				String sumsql = "select sum(leavecount) from cardcount WHERE actNo='"+actNo+"'";
				sumstmt = sumconn.prepareStatement(sumsql);
				sumrs = sumstmt.executeQuery();
				if(sumrs != null && sumrs.next()){
					allcount += sumrs.getLong(1);
				}
			}
			logger.info("cardcount table update success");
			String sql = "update carddistribution set usedcount="+allcount+",leavecount=totalCount-"+allcount+" where month='"+nowmonth+"'";
			ustmt = uconn.prepareStatement(sql);
			logger.info("sql=================>"+sql);
			ustmt.executeUpdate();
			String endtime  = TaskLogUtil.getNowTime();	               
            TaskLogUtil.addLog("每月代金券业务活动跨月数量更新成功", "", starttime, endtime, true);
			logger.info("update more month bizi card count  success biznistrs="+biznistrs+",time="+nowtime);
		}catch(Exception e){
			String endtime  = TaskLogUtil.getNowTime();	               
            TaskLogUtil.addLog("每月代金券业务活动跨月数量更新失败", e.getMessage(), starttime, endtime, false);
			logger.error("update more month bizi card count failure . The reason is :"+e.getMessage()+",biznistrs="+biznistrs+",time:"+nowtime);
			e.printStackTrace();
		}finally{
			try{
				if(ustmt != null){
					ustmt.close();
					ustmt = null;
				}
				if(uconn != null){
					uconn.close();
					uconn = null;
				}
				if(sumrs != null){
					sumrs.close();
					sumrs = null;
				}
				if(sumstmt != null){
					sumstmt.close();
					sumstmt = null;
				}
				if(sumconn != null){
					sumconn.close();
					sumconn = null;
				}
				if(sctstmt != null){
					sctstmt.close();
					sctstmt = null;
				}
				if(sconn != null){
					sconn.close();
					sconn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(ctstmt != null){
					ctstmt.close();
					ctstmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}
