package com.xunlei.niux.manager.web.vo;


import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

import com.xunlei.niux.manager.web.util.HttpClientUtil;


/**
 * 生成充值客户信息
 * @author lisu
 * 2013-03-02
 */
public class CustomerTask {
	private static final Logger logger = Logger.getLogger(CustomerTask.class.getName());
	private static String time = null;
	private static String ftime = null;
	private static String BaseUrl = "http://twin13024.sandai.net";
	private static String customerInterface = "http://tw07286.sandai.net:8002/getPayAndLoginRecord?";
	private static String customerRemoteUrl = BaseUrl+":8080/hdfs-webdav";
	private static String newUserUrl =  BaseUrl+":8089/scanPlatNewForUser";
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 cal.add(Calendar.DAY_OF_MONTH, -1);
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间的前一天
			 sdf = new SimpleDateFormat("yyyyMMdd");
			 ftime = sdf.format(cal.getTime());
		}
	}
	
	
	public static void main(String args[]){
	   if(args != null && args.length>=1){
		   time = args[0];
		   ftime = time.replaceAll("-", "");
	   }
	   make();	   	  
	}
	
	/**
	 * 生成文件到文件服务器，更新客户信息，并且生成大客户记录
	 */
	public static void make(){	
		   logger.info("开始计算大客户的流失状态");
		   updateCustomerLostStatus();
		   logger.info("大客户的流失状态计算完毕~！");
		   logger.info("开始重置客户详情中的相关状态......");	
		   resetCustomerStatus();
		   logger.info("客户详情中的相关状态重置完毕！");
		   logger.info("开始生成客户详情数据......");	
		   execCustomerDetail();
		   logger.info("客户详情数据生成完毕！");	 

	}
	
	/**
	 * 更新大客户流失状态，确保计算之前的数据的准确性。
	 * 后面也有相关的计算，后面主要是为了计算流失之后又重新登录的情况，状态变回为保有状态，
	 * 但是如果接口挂了或者网络异常，导致定时任务出现异常，
	 * 则大客户流失状态可能会出现异常。这里可以保证大客户流失状态在出现异常的情况下，
	 * 数据也是准确的。
	 */
	private static void updateCustomerLostStatus(){
		  Connection ctconn = null;
		   PreparedStatement ctstmt = null;
		   try{
		       ctconn = ConnUtil.getConnection();			  		   
		       StringBuffer sql = new StringBuffer();
				  sql.append("update customerdetailquery set  vipStatus=2 WHERE lastLoginTime<> '' AND (((TO_DAYS('"+time+"') - TO_DAYS(lastLoginTime) >= 5) AND vipGrade>=1 and vipGrade<=7 )  or ((TO_DAYS('"+time+"') - TO_DAYS(lastLoginTime) >= 2) AND vipGrade>=8 and vipGrade<=10 ))") ;				   
              ctstmt = ctconn.prepareStatement(sql.toString());	 
              System.out.println("updatecustomerloststatussql:"+sql);
              ctstmt.execute();
		   }catch(Exception e){
			   e.printStackTrace();
		   }finally{
			   try{
				   if(ctstmt != null){//关闭连接
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }				
		
	}
	
	/**
	 * 生成充值客户信息文件
	 */
	public static  void makeFile(){		
		String date = ftime;//当前时间的前一天
		String starttime = TaskLogUtil.getNowTime();
		String url = newUserUrl+"?date="+date+"&type=2";
		logger.info("file system url:"+url);
		String message = null;
		int flag = 0;
		 try{
		      String responseString =  HttpClientUtil.getHtml(url);	  
		      logger.info("responseString:"+responseString);
		      if(responseString != null && !"".equals(responseString)){
		    		String str[] = responseString.split("&");
		    		String status = str[0].split("=")[1];
		    		message = str[1].split("=")[1];
		    		flag = Integer.parseInt(status);
		    		if(flag != 1){
		    			throw new Exception(URLDecoder.decode(message,"utf8"));
		    		}
		    	}
		       String endtime = TaskLogUtil.getNowTime();
		       TaskLogUtil.addLog("生成充值客户文件", null, starttime, endtime, true);
		    }catch(Exception e){
		    	logger.info("生成充值客户文件任务执行失败，原因：" + e.getMessage());
		    	String endtime = TaskLogUtil.getNowTime();
				TaskLogUtil.addLog("生成充值客户文件", e.getMessage(), starttime, endtime, false);
		    }finally{
		    	
		    }
	}
	
	
    /**
     * 重置客户详情中的相关状态
     */
	public static void resetCustomerStatus(){
		   Connection ctconn = null;
		   PreparedStatement ctstmt = null;
		   try{
		       ctconn = ConnUtil.getConnection();			  		   
               String insertsql = "UPDATE customerdetailquery SET isBack=0 WHERE  isBack = 1";
               ctstmt = ctconn.prepareStatement(insertsql);	 
               ctstmt.execute();
		   }catch(Exception e){
			   e.printStackTrace();
		   }finally{
			   try{
				   if(ctstmt != null){//关闭连接
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }				
	}
	
	
	 /**
     * 删除客户路径
     */
	public static void deleteCustomerPath(){	      
		   String date = ftime;//当前时间的前一天
		   Connection ctconn = null;
		   PreparedStatement ctstmt = null;
		   try{
		       ctconn = ConnUtil.getConnection();			  		   
               String insertsql = "delete from bigcustomerquery where daytime='"+date+"'";
               ctstmt = ctconn.prepareStatement(insertsql);	    
               ctstmt.execute();
		   }catch(Exception e){
			   e.printStackTrace();
		   }finally{
			   try{
				   if(ctstmt != null){//关闭连接
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }				
	}
	
	/**
	 * 生成客户详情数据
	 */
	public static void execCustomerDetail() {
		String starttime = TaskLogUtil.getNowTime();
		String baseUrl = getUrl();		
		String filepath = getFilesPath();		
		if(filepath.indexOf(",")>-1){//如果有多个文件
			for(String subFilePath:filepath.split(",")){
			   initData(baseUrl,subFilePath,starttime);
			}
		}else{//如果只有一个文件
			initData(baseUrl,filepath,starttime);
		}	
		String endtime  = TaskLogUtil.getNowTime();	               
        TaskLogUtil.addLog("生成客户详情数据", "", starttime, endtime, true);
        
        if(filepath.indexOf(",")>-1){
        	for(String subFilePath:filepath.split(",")){
        		updateGameCount(baseUrl,subFilePath,starttime);
 			}
        }else{
        	updateGameCount(baseUrl,filepath,starttime);
        }
        TaskLogUtil.addLog("更新充值和登录游戏数", "", starttime, endtime, true);
	}
	
	
	/**
	 * 通过http的形式访问远程文件，并且读取文件中的数据，保存到数据库
	 * @param path
	 * @return
	 */
	public static void initData(String baseUrl,String filepath,String starttime){
		URL url = null;
		Connection conn = null;
		Connection uconn = null;
		PreparedStatement pstmt = null;
		PreparedStatement upstmt = null;
		ResultSet rs = null;
		try {
			url = new URL(baseUrl+filepath);			
		} catch (MalformedURLException e) {
			logger.info("文件找不到，文件路径为："+baseUrl+filepath+"，请查看是否正确。错误代码："+e.getMessage());
		} 
		HttpURLConnection httpUrl = null;
		BufferedReader br = null;
		//连接指定的网络资源 
		try {
			httpUrl = (HttpURLConnection) url.openConnection(); 
			httpUrl.connect();
			//获取网络输入流 
			br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 			
			/**-----------
			 * 开始解析数据
			 * -----------
			 */
            logger.info("========开始解析文件:"+filepath+"=========");			
			String readLine = br.readLine();
			int line = 0;//读取的行号
			List<String> loginlist = new ArrayList<String>();//登录集合
			List<Double> paylist = new ArrayList<Double>();//支付集合	
			List<String> payTimeList = new ArrayList<String>();//充值时间集合		
			//获得所有的客户等级
			//List<CustomerGrade> gradeList = FacadeFactory.INSTANCE.getCustomerGradeBo().findCustomerGradeList();
			String sql = "select * from customergrade ORDER BY vipGrade ASC ";
			conn = ConnUtil.getConnection();
			uconn = ConnUtil.getConnection();
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			List<Integer> vipGradeList = new ArrayList<Integer>();
			List<Long> amountFromList = new ArrayList<Long>();
			List<Long> amountToList = new ArrayList<Long>();
			while(rs.next()){
				amountFromList.add(rs.getLong("amountFrom"));
				amountToList.add(rs.getLong("amountTo"));
            	vipGradeList.add(rs.getInt("vipGrade"));
			}
//			int jj = 0;
			double total = 0;
			long lastPayTotal = 0L;
			long payTotalAmt = 0L;
			Integer vipgrade = 0;
			int vipstatus = 0;
			boolean isBack = false;
			boolean isPromote = false;
			String lastLoginTime = null;
			String lastPayTime = null;
			while(readLine != null){
//				if(jj >= 200)break;
//				jj ++;
				total = 0;
				lastPayTotal = 0L;
				payTotalAmt = 0L;
				vipstatus = 0;
				vipgrade = 0;
				lastLoginTime = null;
				lastPayTime = null;
				isBack = false;
				isPromote = false;
				
				line ++;
				logger.info("line=============>"+line);				
				//开始解析数据
				String arr[] = readLine.split(",");
				loginlist.clear();//清空集合
				paylist.clear();
				payTimeList.clear();
				String uid = null;
				for(String data:arr){
					if(data.indexOf("userid=")>-1){													
						uid = data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim();//迅雷uid	
						if(uid == null||"".equals(uid)){
							continue;
						}
					}
					if(data.indexOf("login_")>-1){					
						loginlist.add(data.substring(data.indexOf("_")+1).split("=")[0]);//将多个日期放到集合						
					}
					if(data.indexOf("pay_")>-1){	
					    paylist.add(new Double(data.substring(data.indexOf("_")).split("=")[1]));//将多个金额放到集合
					    payTimeList.add(data.substring(data.indexOf("_")+1).split("=")[0]);//将多个充值时间放到集合
					}	
				}
				for(int i=0;i<payTimeList.size();i++){
					String payTime = getFormatYear(payTimeList.get(i));
					if(payTime.trim().equals(time)){
						lastPayTotal+=paylist.get(i);//当天的平台充值金额
					}
				}
				//detail.setLastModifyAmt(lastPayTotal);
				
				Collections.sort(loginlist);//将登录日期排序
				Collections.sort(payTimeList);//将充值日期排序
		        if(loginlist.size()>0){
                	String maxday = loginlist.get(loginlist.size()-1);
                	maxday = getFormatYear(maxday);
                	//detail.setLastLoginTime(maxday);//最后登录时间
                	if(compareTime(maxday,time)>0){//如果只重跑之前的记录
                		maxday = time;
                	}
                	lastLoginTime = maxday;
                }  
                for(Double pay:paylist){
                	total += pay;//求出总金额
                }
                if(payTimeList.size()>0){
                	String maxday = payTimeList.get(payTimeList.size()-1);
                	maxday = getFormatYear(maxday);
                	//detail.setLastPayTime(maxday);//最后充值时间
                	if(compareTime(maxday,time)>0){//如果只重跑之前的记录
                		maxday = time;
                	}
                	lastPayTime = maxday;
                }
               // detail.setPayTotalAmt(total);
                payTotalAmt = Math.round(total) ;
                
//                //测试时只统计VIP登记在7级以上的用户
//                if(payTotalAmt < 50000){
//                	readLine = br.readLine();
//                	continue;
//                }
               
                ////////////////////////////////////////////////////////////////////////////////////////
                //判断该客户的新增、回流、晋级状态
                sql = "select * from customerdetailquery where uid=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, uid);
    			rs = pstmt.executeQuery();   			
                
                if(rs == null||!rs.next()){//如果客户不存在，则需要新增客户信息  
                	logger.info("insertuid==============>"+uid);
                    ///////////////////////////////////////////////////////////////////////////////////////
                    //查询客户的VIP等级
                    for(int i=0;i<amountFromList.size();i++){
                    	long amountFrom = amountFromList.get(i);
                    	long amountTo = amountToList.get(i);
                    	Integer vipGrade = vipGradeList.get(i);
                    	if(amountFrom <= payTotalAmt && amountTo >= payTotalAmt){
                    		vipgrade = vipGrade;
                    		break;
                    	}
                    }
                    ////////////////////////////////////////////////////////////////////////////////////////
                    //判断客户是否流失
                    boolean lostFlag = checkCustomerIsLost(lastLoginTime,vipgrade);
                    if(lostFlag)vipstatus=2;//设置状态为流失
                    else vipstatus=1;//设置状态为保有
                	String usql = "insert into customerdetailquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";               	
                	upstmt = uconn.prepareStatement(usql);
                	upstmt.setString(1, null);
                	upstmt.setString(2, uid);
                	upstmt.setString(3, "");
                	upstmt.setInt(4, vipgrade);                	
                	upstmt.setInt(5, vipstatus);
                	upstmt.setLong(6, 0);
                	upstmt.setLong(7, 0);
                	upstmt.setLong(8, payTotalAmt);                	
                	upstmt.setString(9, lastPayTime);
                	upstmt.setString(10, lastLoginTime);
                	upstmt.setInt(11, 0);
                	upstmt.setInt(12, 0);
                	upstmt.setString(13, "");
                	upstmt.setString(14, "");
                	upstmt.setString(15, "");
                	upstmt.setString(16, "");
                	upstmt.setString(17, "");
                	upstmt.setLong(18, lastPayTotal);
                	upstmt.setInt(19, 1);
                	upstmt.setInt(20, 0);
                	upstmt.setInt(21, 0);
                	upstmt.setLong(22, payTotalAmt);
                	upstmt.setInt(23, vipgrade);
                	upstmt.setInt(24, 0);
                	upstmt.setString(25, "");
                	upstmt.setString(26, "");
                	upstmt.setString(27, "");
                	upstmt.setLong(28, 0);	
                	upstmt.setString(29, "");	
                	upstmt.setString(30, "");	
                	upstmt.setString(31, "");	
                	upstmt.setString(32, "");
                	upstmt.setInt(33, 0);
                	upstmt.setLong(34, 0);
                	upstmt.setString(35,"");
                	upstmt.setString(36,"1");
                	upstmt.execute();
                }else{
                	logger.info("updateuid==============>"+uid);
                    ///////////////////////////////////////////////////////////////////////////////////////
                    //查询客户的VIP等级
                	//payTotalAmt += rs.getLong("payTotalAmt");
                    for(int i=0;i<amountFromList.size();i++){
                    	long amountFrom = amountFromList.get(i);
                    	long amountTo = amountToList.get(i);
                    	Integer vipGrade = vipGradeList.get(i);
                    	if(amountFrom <= payTotalAmt && amountTo >= payTotalAmt){
                    		vipgrade = vipGrade;
                    		break;
                    	}
                    }
                    ////////////////////////////////////////////////////////////////////////////////////////
                    //判断客户是否流失
                    boolean lostFlag = checkCustomerIsLost(lastLoginTime,vipgrade);
                    if(lostFlag)vipstatus=2;//设置状态为流失
                    else vipstatus=1;//设置状态为保有
            		int myvipgrade = rs.getInt("vipGrade");
                	int myvipstatus = rs.getInt("vipStatus");
                	if(!lostFlag && myvipstatus == 2){//判断是否回流
                		isBack = true;
                	}else{
                		isBack = false;
                	}
                	if(myvipgrade < vipgrade)isPromote=true;//判断是否晋级
                	else isPromote = false;
                	String usql = "update customerdetailquery set isBack=?,lastLoginTime=?,lastPayTime=?,lastModifyAmt=?,vipGrade=?,vipStatus=?,payTotalAmt=?,bvipGrade=?  where uid=?";
                	upstmt = uconn.prepareStatement(usql);
                	upstmt.setInt(1, isBack?1:0);
                	upstmt.setString(2, lastLoginTime);
                	upstmt.setString(3, lastPayTime);
                	upstmt.setLong(4, lastPayTotal);
                	upstmt.setInt(5, vipgrade);
                	upstmt.setInt(6, vipstatus);
                	upstmt.setLong(7, payTotalAmt);
                	upstmt.setInt(8, isPromote?myvipgrade:0);
                	upstmt.setString(9, uid);
                	upstmt.execute();                               	
                }                
				//读取下一行的数据
				readLine = br.readLine();
			}											
		} catch (Exception e) {
			logger.info(e.getMessage());
			e.printStackTrace();
			String endtime  = TaskLogUtil.getNowTime();	               
	        TaskLogUtil.addLog("生成客户详情数据", "", starttime, endtime, true);
		}finally{
			try{
				if(upstmt != null){
					upstmt.close();
					upstmt = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(uconn != null){
					uconn.close();
					uconn = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(br != null){
					br.close();
					br =  null;
				}
				if(httpUrl != null){
					httpUrl.disconnect();
					httpUrl = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
				e.printStackTrace();
			}
		}
	}
	
	
	/**
	 * 更新激活游戏数、充值游戏数、最后一次登录的游戏、最后一次充值的游戏
	 * @param baseUrl
	 * @param filepath
	 * @param starttime
	 */
	private static void updateGameCount(String baseUrl,String filepath,String starttime){
		URL url = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		try {
			url = new URL(baseUrl+filepath);			
		} catch (MalformedURLException e) {
			logger.info("文件找不到，文件路径为："+baseUrl+filepath+"，请查看是否正确。错误代码："+e.getMessage());
		} 
		HttpURLConnection httpUrl = null;
		BufferedReader br = null;
		//连接指定的网络资源 
		try {
			httpUrl = (HttpURLConnection) url.openConnection(); 
			httpUrl.connect();
			//获取网络输入流 
			br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 			
            logger.info("========开始解析文件:"+filepath+"=========");			
			String readLine = br.readLine();
			int line = 0;//读取的行号
			conn = ConnUtil.getConnection();
			Map<String,Object> gamepayMap = new HashMap<String,Object>();
			long gameCount = 0;
			long payGameCount = 0;
			String lastLoginGameId = null;
			String lastPayGameId = null;
			String logingameids = null;
			while(readLine != null){
				String arr[] = readLine.split(",");
				line ++;
				logger.info("line=============>"+line);				
				String uid = null;
				for(String data:arr){
					if(data.indexOf("userid=")>-1){													
						uid = data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim();//迅雷uid	
						if(uid == null||"".equals(uid)){
							continue;
						}
					}				
				}
               
                /////////////////////////////////////////////////////////////////////////////////////////
                //计算激活游戏数和充值游戏数
                getGameAndPayCount(gamepayMap,uid);
                gameCount = gamepayMap==null?0:gamepayMap.get("gameCount")==null?0:(Long)gamepayMap.get("gameCount");
                payGameCount = gamepayMap==null?0:gamepayMap.get("payGameCount")==null?0:(Long)gamepayMap.get("payGameCount");
                lastLoginGameId = gamepayMap==null?"":gamepayMap.get("loginGameId")==null?"":(String)gamepayMap.get("loginGameId");
                lastPayGameId = gamepayMap==null?"":gamepayMap.get("payGameId")==null?"":(String)gamepayMap.get("payGameId");
                logingameids = gamepayMap==null?"":gamepayMap.get("logingameids")==null?"":(String)gamepayMap.get("logingameids");
                
                /////////////////////////////////////////////////////////////////////////////////////////
                StringBuffer sqlbuffer = new StringBuffer("update customerdetailquery set gamecount=")
                                                    .append(gameCount).append(",payCount=").append(payGameCount)
                                                    .append(",loginGameId='").append(lastLoginGameId).append("',")
                                                    .append(" payGameId='").append(lastPayGameId).append("',")
                                                    .append(" loginGameIds='").append(logingameids).append("'")
                                                    .append("  where uid='").append(uid).append("'");
                logger.info("update login and pay count sql:"+sqlbuffer);
                pstmt = conn.prepareStatement(sqlbuffer.toString());
                pstmt.execute();
				//读取下一行的数据
				readLine = br.readLine();
			}											
		} catch (Exception e) {
			logger.info(e.getMessage());
			e.printStackTrace();
			String endtime  = TaskLogUtil.getNowTime();	               
	        TaskLogUtil.addLog("生成客户详情数据", "", starttime, endtime, true);
		}finally{
			try{				
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(br != null){
					br.close();
					br =  null;
				}
				if(httpUrl != null){
					httpUrl.disconnect();
					httpUrl = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
				e.printStackTrace();
			}
		}
	}
	
	
	/**
	 * 检查客户是否流失 
	 * 规则：VIP1-VIP7连续5天未登录游戏  VIP8-VIP10连续2天未登录游戏
	 * @param lastLoginTime 最后登录时间
	 * @param vipGrade VIP等级
	 * @return
	 */
	public static boolean checkCustomerIsLost(String lastLoginTime,int vipGrade) throws Exception{
		if(lastLoginTime == null||"".equals(lastLoginTime))return true;
		if(vipGrade>=1 && vipGrade <= 7){
			if(compareTime(time,lastLoginTime) >= 5)return true;
		}else if(vipGrade >= 8 && vipGrade <= 10){
			if(compareTime(time,lastLoginTime) >= 2)return true;
		}
		return false;
	}
	
	/**
	 * 格式化年份
	 * @param maxday
	 * @return
	 */
	public static String getFormatYear(String maxday){
		String year = maxday.substring(0, 1);		
  		String tmp = maxday.substring(1, 5);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2); 
		if("1".equals(year)){
    		year = "2011";
    	}else if("2".equals(year)){
    		year = "2012";
    	}else if("3".equals(year)){
    		year = "2013";
    	}else if("4".equals(year)){
    		year = "2014";
    	}else if("5".equals(year)){
    		year = "2015";
    	}else if("6".equals(year)){
    		year = "2016";
    	}else if("7".equals(year)){
    		year = "2017";
    	}else if("8".equals(year)){
    		year = "2018";
    	}else if("9".equals(year)){
    		year = "2019";
    	}
		maxday = year+"-"+month+"-"+day;
		return maxday;
	}
	
	
	
	/**
	 * 取时间格式为：yyyy-MM-dd 日期的前一天 
	 * @param daytime
	 * @return
	 */
	public static String formatBeforeDay(String daytime){
		if(daytime==null||"".equals(daytime))return null;
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date = sdf.parse(daytime);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String now = sdf.format(cal.getTime());		
		return now;
	}
	
	
	/**
	 * 按照日期读出统计前一天的数据
	 * @return
	 */
	public static String getFilesPath(){				
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String strs[] = time.split("-");
		String filepath = null;
		String daytime = strs[0]+strs[1]+strs[2];
        try{
        	String sql = "select fileurl from bigcustomerquery where daytime=?";
        	conn = ConnUtil.getConnection();
        	pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, daytime);
 			rs = pstmt.executeQuery();
 			if(rs == null)return null;
 			rs.next();
 			filepath = rs.getString(1);
        }catch(Exception e){
        	e.printStackTrace();
        }finally{
        	try{
        		if(rs != null){
        			rs.close();
        			rs = null;
        		}
        		if(pstmt != null){
        			pstmt.close();
        			pstmt = null;
        		}
        		if(conn != null){
        			conn.close();
        			conn = null;
        		}
        	}catch(Exception e){
        		e.printStackTrace();
        	}
        }
        		
		return filepath;
		
	}
	
	/**
     * 获得文件服务器地址
     * @return
     */
	public static String getUrl(){
		String bigCustomerRemoteUrl= customerRemoteUrl;
		logger.info("获得文件服务器地址成功");
		return bigCustomerRemoteUrl;
	}
	
	
	/**
	 * 通过get方式调用接口
	 * @param url
	 * @return
	 */
	public static String getInfoForHttpGetMothed(String url) {
		logger.info(" Get/URL :" + url);		
		HttpClient client = new DefaultHttpClient();
		HttpGet httpget = new HttpGet(url);			
		try {				
			String backStr = "";
			ResponseHandler<String> responseHandler = new BasicResponseHandler();
			backStr = client.execute(httpget, responseHandler);
			return backStr;
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(client != null)
			    client.getConnectionManager().shutdown();			
		}
		return "";
	}
	
	/**
	 * 比较两个时间相隔多少天
	 *  
	 * @param fromtime 格式 yyyy-MM-dd
	 * @param totime   格式 yyyy-MM-dd
	 * @return
	 */
	public static long compareTime(String fromtime,String totime) throws Exception{
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
        Date one = null;
        Date two = null;
        long days=0;  
    	one = df.parse(fromtime);  
    	two = df.parse(totime); 
    	long time1 = one.getTime();  
    	long time2 = two.getTime();  
    	long diff = time1 - time2;       	
    	days = diff / (1000 * 60 * 60 * 24);      
		return days;
	}
	
	
	/**
	 * 获得平台的激活游戏数和充值游戏数
	 */
	public static void getGameAndPayCount(Map<String,Object> map,String uid) throws Exception{	
			if(map != null)map.clear();
			String jsonStr = getInfoForHttpGetMothed(customerInterface+"uid="+uid+"&date="+time);
			if(jsonStr == null){
				return;
			}
	    	ObjectMapper mapper = new ObjectMapper();
			JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);			
			//绑定游戏详情数据
			List<Record> recordList = record.getList();								
			if(recordList == null||recordList.size()==0)return;
			long gameCount = 0L;//激活游戏数
			long payGameCount = 0L;//充值游戏数
			
			Set<String> gameset = new TreeSet<String>();			
			Set<String> payset = new TreeSet<String>();	
			String lastLoginTime = null;
			String lastPayTime = null;
			String loginGameId = null;
			String payGameId = null;
			for(Record rec:recordList){
				String loginTime = rec.getLastLoginTime();
				String payTime = rec.getLastPayTime();
				if(rec.getFirstLoginTime() != null && !"".equals(rec.getFirstLoginTime())){
					gameset.add(rec.getGameId());
				}
				if(rec.getFirstPayTime() != null && !"".equals(rec.getFirstPayTime())){
					payset.add(rec.getGameId());
				}	
				if(loginTime!=null&&!"".equals(loginTime)){
					if(lastLoginTime == null){
						lastLoginTime = loginTime;
						loginGameId = rec.getGameId();
					}else{						
						if(compareTime(lastLoginTime,loginTime)<0){
							lastLoginTime = loginTime;
							loginGameId = rec.getGameId();
						}
					}
				}
				if(payTime !=null&&!"".equals(payTime)){
					if(lastPayTime == null){
						lastPayTime = payTime;
						payGameId = rec.getGameId();
					}else{
						if(compareTime(lastPayTime,payTime)<0){
							lastPayTime = payTime;
							payGameId = rec.getGameId();
						}
					}
				}			
			}
			gameCount = gameset.size();
			payGameCount = payset.size();
			String logingameids = "";
			for(String game:gameset){
				logingameids += (game+",");
			}
			map.put("logingameids", logingameids);//激活游戏数
			map.put("gameCount", gameCount);//激活游戏数
			map.put("payGameCount", payGameCount);//充值游戏数
			map.put("loginGameId", loginGameId==null?"":loginGameId);//最后登录游戏
			map.put("payGameId", payGameId==null?"":payGameId);//最后充值游戏
	}
}
