package com.xunlei.niux.manager.web.vo;


import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;


/**
 * 生成各种客户统计
 * @author  lisu
 * 2013-03-01
 */
public class CustomerLostTask {
	private static final Logger logger = Logger.getLogger(CustomerLostTask.class.getName());
	private static String time = null;
	private static String BASEURL = "http://tw07286.sandai.net:8002/";
	private static String bigCustomerInterface = BASEURL+"getPayAndLoginRecord?";
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 cal.add(Calendar.DAY_OF_MONTH, -1);
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间的前一天
		}
	}
	
	
	public static void main(String args[]){
	   if(args != null && args.length>=1){
		   time = args[0];
	   }
	   make();
	}
	
	public static void make(){			  	 	   
	   logger.info("lostcustomerquery start......");	
	   deleteCustomer("customerquery",2);
	   logger.info("===lostcustomerquery delete");
	   makeLostCustomer();
	   logger.info("lostcustomerquery done");	
	   logger.info("------------------------");	   
	}
			
	
	/**
	 * 删除客户统计表中某日的记录，以便重新生成新数据
	 * @param tableName
	 */
	public static void deleteCustomer(String tableName,int type){
		Connection conn = null;
		PreparedStatement pstmt = null;
		//String starttime = TaskLogUtil.getNowTime();
		try{
		    conn = ConnUtil.getConnection();
		    String sql = "delete from "+tableName+" where daytime=? and type=?";
		    pstmt = conn.prepareStatement(sql);
		    pstmt.setString(1, time);
		    pstmt.setInt(2, type);
		    pstmt.execute();
		   // String endtime = TaskLogUtil.getNowTime();
		   // TaskLogUtil.addLog("删除"+time+"日的"+tableName+"表中的记录", null, starttime, endtime, true);
		}catch(Exception e){
		//	String endtime = TaskLogUtil.getNowTime();
		//	TaskLogUtil.addLog("删除"+time+"日的"+tableName+"表中的记录", e.getMessage(), starttime, endtime, false);
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	 /**
     * 重置客户详情中的相关状态
     */
	public static void resetCustomerStatus(){
		   Connection ctconn = null;
		   PreparedStatement ctstmt = null;
		   String starttime = TaskLogUtil.getNowTime();
		   try{
		       ctconn = ConnUtil.getConnection();			  		   
               String insertsql = "UPDATE customerdetailquery SET isNew = 0,isPromote=0,bvipGrade=0 WHERE isNew=1 OR isPromote=1 OR bvipGrade>0";
               ctstmt = ctconn.prepareStatement(insertsql);	 
               ctstmt.execute();
               String endtime = TaskLogUtil.getNowTime();
  		       TaskLogUtil.addLog("重置客户详情中的相关状态", null, starttime, endtime, true);
		   }catch(Exception e){
			   e.printStackTrace();
			   String endtime = TaskLogUtil.getNowTime();
			   TaskLogUtil.addLog("重置客户详情中的相关状态", e.getMessage(), starttime, endtime, false);
		   }finally{
			   try{
				   if(ctstmt != null){//关闭连接
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }				
	}
	
	
	/**
	 * 生成流失客户记录
	 */
	public static void makeLostCustomer(){
		   Connection conn = null;
		   Connection ctconn = null;
		   Connection uconn = null;
		   Statement stmt = null;
		   PreparedStatement ctstmt = null;
		   PreparedStatement utstmt = null;
		   ResultSet rs = null;
		   String starttime = TaskLogUtil.getNowTime();
		   try{
			  conn = ConnUtil.getConnection();
			  ctconn = ConnUtil.getConnection();
			  uconn = ConnUtil.getConnection();
			  stmt = ConnUtil.getStatement(conn);			  
			  StringBuffer sql = new StringBuffer();
			  sql.append("(SELECT * FROM customerdetailquery WHERE (TO_DAYS('"+time+"') - TO_DAYS(lastLoginTime) = 5) AND vipGrade>=1 and vipGrade<=7 ) ") 
			     .append("  UNION  all")				     
			     .append(" (SELECT * FROM customerdetailquery WHERE (TO_DAYS('"+time+"') - TO_DAYS(lastLoginTime) = 2) AND vipGrade>=8 and vipGrade<=10 )");				   
			  rs = stmt.executeQuery(sql.toString());
			  if(rs == null)return ;				  
              String insertsql = "insert into customerquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
              ctstmt = ctconn.prepareStatement(insertsql);
              String updatesql = "update customerdetailquery set vipStatus=2 where uid=?";
              utstmt = uconn.prepareStatement(updatesql);
              Set<String> gameset = new HashSet<String>();
              while(rs.next()){
            	   String uid = rs.getString("uid");
            	   ctstmt.setString(1, null);
            	   ctstmt.setString(2, uid);
            	   ctstmt.setString(3, rs.getString("account"));
            	   ctstmt.setInt(4, rs.getInt("vipGrade"));
            	   ctstmt.setInt(5, 2);
            	   ctstmt.setLong(6, rs.getLong("gameCount"));
            	   ctstmt.setLong(7, rs.getLong("payCount"));
            	   ctstmt.setLong(8, rs.getLong("payTotalAmt"));
            	   ctstmt.setString(9, rs.getString("lastPayTime"));
            	   ctstmt.setString(10, rs.getString("lastLoginTime"));
            	   ctstmt.setLong(11, rs.getLong("callCount"));
            	   ctstmt.setLong(12, rs.getLong("integral"));
            	   ctstmt.setString(13, rs.getString("phone"));
            	   ctstmt.setString(14, rs.getString("contactNumber"));
            	   ctstmt.setString(15, rs.getString("qq"));
            	   ctstmt.setString(16, rs.getString("email"));
            	   ctstmt.setInt(17, 2);
            	   ctstmt.setString(18, time);
            	   String jsonStr = getInfoForHttpGetMothed(bigCustomerInterface+"uid="+uid+"&date="+time);
            	   ObjectMapper mapper = new ObjectMapper();
            	   JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);		
            	   //绑定游戏详情数据
            	   String gameName = "";   
            	   if(gameset != null)gameset.clear();
       			   List<Record> recordList = record.getList();	
	       		   for(int i=0;i<recordList.size();i++){
	          		   Record rd = recordList.get(i);
	          		   gameset.add(URLDecoder.decode(rd.getGameName(),"utf8"));
	          	   }
            	   for(Iterator<String> iter = gameset.iterator();iter.hasNext();){
            		   gameName += (String)iter.next()+",";
            	   }
            	   if(gameName != null && gameName.indexOf(".")!= -1)
            	      gameName = gameName.substring(0,gameName.lastIndexOf(","));
            	   ctstmt.setString(19, gameName);
            	   ctstmt.setString(20, "");
            	   ctstmt.setString(21, rs.getString("payGameId"));
            	   ctstmt.setString(22, rs.getString("loginGameId"));
            	   ctstmt.execute();
            	   
            	   //更新流失状态
            	   utstmt.setString(1, uid);
            	   utstmt.execute();
			   }	
               String endtime = TaskLogUtil.getNowTime();
		       TaskLogUtil.addLog("生成流失客户记录", null, starttime, endtime, true);
		   }catch(Exception e){
			   e.printStackTrace();
			   String endtime = TaskLogUtil.getNowTime();
			   TaskLogUtil.addLog("生成流失客户记录", e.getMessage(), starttime, endtime, false);
		   }finally{
			   try{
				   if(utstmt != null){//关闭连接
					   utstmt.close();
					   utstmt = null;
					}
				   if(ctstmt != null){//关闭连接
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(uconn != null){
					   uconn.close();
					   uconn = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
		
	}
	
	
	/**
	 * 通过get方式调用接口
	 * @param url
	 * @return
	 */
	public static String getInfoForHttpGetMothed(String url) {
		try {
			logger.info(" Get/URL :" + url);
			HttpGet httpget = new HttpGet(url);
			HttpClient client = new DefaultHttpClient();
			String backStr = "";
			ResponseHandler<String> responseHandler = new BasicResponseHandler();
			backStr = client.execute(httpget, responseHandler);
			return backStr;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}
	
}
