package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.log4j.Logger;

/**
 * 会员卡使用记录定时任务
 * @author lisu
 * 2013-03-20
 */
public class CardUserRecordTask {
	private static final Logger logger = Logger.getLogger(CardUserRecordTask.class.getName());
	private static String time = null;
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 cal.add(Calendar.DAY_OF_MONTH, -1);
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间的前一天
		}
	}
	public static void main(String[] args) {
	   logger.info("开始删除会员卡使用记录数据......");	
	   deleteUserRecord("cardrecorddetail");
	   deleteUserRecord("carduserecord");
	   logger.info("会员卡使用记录数据删除完毕！");
	   logger.info("开始生成每日会员卡使用记录详情数据......");	
	   makeDetail();
	   logger.info("每日会员卡使用记录详情数据生成完毕！");	
	   logger.info("开始生成每日会员卡使用记录汇总数据......");	
	   makeTotal();
	   logger.info("每日会员卡使用记录汇总数据生成完毕！");
	}

	
	/**
	 * 删除客户统计表中某日的记录，以便重新生成新数据
	 * @param tableName
	 */
	public static void deleteUserRecord(String tableName){
		Connection conn = null;
		PreparedStatement pstmt = null;
		try{
		    conn = ConnUtil.getConnection();
		    String sql = "delete from "+tableName+" where daytime=?";
		    pstmt = conn.prepareStatement(sql);
		    pstmt.setString(1, time);
		    pstmt.execute();
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 生成使用记录详情数据
	 */
	public static void makeDetail(){
	   Connection conn = null;
	   Connection ctconn = null;
	   Connection utconn = null;
	   Statement stmt = null;
	   PreparedStatement ctstmt = null;
	   PreparedStatement utstmt = null;
	   ResultSet rs = null;
	   String starttime = TaskLogUtil.getNowTime();
	   try{
		   conn = ConnUtil.getConnection();
		   ctconn = ConnUtil.getConnection();
		   utconn = ConnUtil.getConnection();
		   stmt = ConnUtil.getStatement(conn);
		   StringBuffer sql = new StringBuffer("SELECT s1.actno ano,s1.actname aname,s2.cardType btype,s2.liveUsedCount  bcount FROM ")
		                     .append(" (SELECT actno,actname  ")
		                     .append(" FROM `cardbizi`  ")
		                     .append(" WHERE DATE_FORMAT(actFromTime,'%Y-%m-%d') <= DATE_SUB(CURRENT_DATE(),INTERVAL 1 DAY) AND actToTime >= DATE_SUB(CURRENT_DATE(),INTERVAL 1 DAY)) s1  ")
		                     .append(" LEFT JOIN cardcount s2   ")
		                     .append(" ON s1.actno = s2.actno ")
		                     .append(" ORDER BY s2.actno ASC,s2.cardType ASC ");
          rs = stmt.executeQuery(sql.toString());                   
          
          String insertsql = "insert into cardrecorddetail (seqid,actNo,actName,cardType,liveUsedCount,daytime) values(?,?,?,?,?,?)";
          ctstmt = ctconn.prepareStatement(insertsql);
          Set<String> set = new HashSet<String>();
		  while(rs.next()){
			  ctstmt.setString(1, null);
			  ctstmt.setString(2, rs.getString(1));
			  ctstmt.setString(3, rs.getString(2));
			  ctstmt.setString(4, rs.getString(3));
			  ctstmt.setString(5, rs.getString(4));
			  ctstmt.setString(6, time);
			  ctstmt.execute();
			  set.add(rs.getString(1));
		  }
		  
		  for(Iterator iter=set.iterator();iter.hasNext();){
			  String uid = (String)iter.next();
			  //更新前一天的剩余数量
			  StringBuffer updatesql = new StringBuffer("UPDATE cardcount SET liveUsedCount = 0 ")
			                           .append(" WHERE actno = '"+uid+"'");
			  utstmt = utconn.prepareStatement(updatesql.toString());
			  utstmt.execute();
		  }
		  String endtime  = TaskLogUtil.getNowTime();	               
          TaskLogUtil.addLog("生成代金券使用记录详情", "", starttime, endtime, true);
	   }catch(Exception e){
		   e.printStackTrace();
		   String endtime  = TaskLogUtil.getNowTime();	               
           TaskLogUtil.addLog("生成代金券使用记录详情", e.getMessage(), starttime, endtime, false);
		   logger.info("time:"+time+" cardrecorddetail error reason is "+e.getMessage());
	   }finally{
		   try{
			   if(utstmt != null){//关闭连接
				   utstmt.close();
				   utstmt = null;
			   }
			   if(utconn != null){
				   utconn.close();
				   utconn = null;
			   }
			   if(ctstmt != null){
				   ctstmt.close();
				   ctstmt = null;
			   }
			   if(ctconn != null){
				   ctconn.close();
				   ctconn = null;
			   }
			   if(rs != null){
				   rs.close();
				   rs = null;
			   }
			   if(stmt != null){
				   stmt.close();
				   stmt  = null;
			   }
			   if(conn != null){
				   conn.close();
				   conn = null;
			   }
		   }catch(Exception e){
			   e.printStackTrace();
		   }
	   }
	}
	
	
	/**
	 * 生成使用记录汇总数据
	 */
	public static void makeTotal(){
		   Connection conn = null;
		   Connection ctconn = null;
		   Statement stmt = null;
		   PreparedStatement ctstmt = null;
		   ResultSet rs = null;
		   String starttime = TaskLogUtil.getNowTime();
		   try{
			   conn = ConnUtil.getConnection();
			   ctconn = ConnUtil.getConnection();
			   stmt = ConnUtil.getStatement(conn);
			   StringBuffer sql = new StringBuffer("SELECT cardType, SUM(liveUsedCount) FROM cardrecorddetail")			                     
			                     .append(" WHERE daytime = '"+time+"'")
			                     .append(" GROUP BY cardType ");
	          rs = stmt.executeQuery(sql.toString());
	          String insertsql = "insert into carduserecord values(?,?,?,?)";
	          ctstmt = ctconn.prepareStatement(insertsql);
			  while(rs.next()){
				  ctstmt.setString(1, null);
				  ctstmt.setString(2, time);
				  ctstmt.setString(3, rs.getString(1));
				  ctstmt.setString(4, rs.getString(2));
				  ctstmt.execute();
			  }
			  String endtime  = TaskLogUtil.getNowTime();	               
	          TaskLogUtil.addLog("代金券使用记录汇总", "", starttime, endtime, true);
		   }catch(Exception e){
			   e.printStackTrace();
			   String endtime  = TaskLogUtil.getNowTime();	               
	           TaskLogUtil.addLog("代金券使用记录汇总", e.getMessage(), starttime, endtime, false);
			   logger.info("time:"+time+" carduserrecord error reason is "+e.getMessage());
		   }finally{
			   try{
				   if(ctstmt != null){//关闭连接
					   ctstmt.close();
					   ctstmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt  = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
	}
	
}
