package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import com.xunlei.niux.manager.web.util.HttpClientUtil;


public class CallRecordTask {
	private static final Logger logger = Logger.getLogger(CallRecordTask.class.getName());
	private static String url = "http://tw07286.sandai.net:8002/getAfterCallLoginTimeAndPayTotal?uid=";
	
	public static void main(String args[]){
	   make();
	}
	
	public static void make(){
	   SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	   String starttime = sdf.format(new Date());
	   logger.info("time:"+starttime+",callrecordtask is running......");	
	   scanCallRecord();
	   String endtime = sdf.format(new Date());
	   logger.info("time:"+endtime+",callrecordtask is done");	   	   	   
	}
	
	
	/**
	 * 扫描外呼记录，查询外呼后第3天客户的登录和充值情况
	 */
	public static void scanCallRecord(){
		   Connection conn = null;
		   Connection ctconn = null;
		   Statement stmt = null;
		   PreparedStatement ctstmt = null;
		   ResultSet rs = null;
		   String starttime = TaskLogUtil.getNowTime();
		   try{
			   conn = ConnUtil.getConnection();
			   ctconn = ConnUtil.getConnection();
			   stmt = ConnUtil.getStatement(conn);			  
			   StringBuffer sql = new StringBuffer();
			   sql.append("SELECT seqid,uid,callTime FROM callrecord  WHERE TO_DAYS(NOW())-TO_DAYS(callTime) = 3 ");			   
				   rs = stmt.executeQuery(sql.toString());
				   if(rs == null)return ;
	               String insertsql = "update callrecord set afterCallLoginTime=?,afterCallPayAmount=? where seqid=?";
	               ctstmt = ctconn.prepareStatement(insertsql);
	               while(rs.next()){
	            	   long seqid = rs.getLong(1);//外呼编号
	            	   String uid = rs.getString(2);//迅雷uid
	            	   String callTime = rs.getString(3);//外呼时间
	            	   callTime = java.net.URLEncoder.encode(callTime, "utf-8");
	       	    	   //调用远程接口
	                   String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(url+uid+"&time="+callTime);     
	                   logger.info("callurl======================>"+url+uid+"&time="+callTime);
	                   ObjectMapper mapper = new ObjectMapper();       
	                   CallRecordJson json = mapper.readValue(jsonStr, CallRecordJson.class);
	                   String loginTime = json.getLogintime();//外呼后最近的一次登录时间
	                   long amount = json.getPaytotal();//外呼后的充值金额
                       ctstmt.setString(1, loginTime);
                       ctstmt.setLong(2, amount);
                       ctstmt.setLong(3, seqid);
	            	   ctstmt.execute();
				   }
	               String endtime  = TaskLogUtil.getNowTime();	               
	               TaskLogUtil.addLog("外呼后第3天客户的登录和充值更新", "", starttime, endtime, true);
		   }catch(Exception e){
			   e.printStackTrace();
			   String endtime  = TaskLogUtil.getNowTime();	               
               TaskLogUtil.addLog("外呼后第3天客户的登录和充值更新", e.getMessage(), starttime, endtime, false);
		   }finally{
			   try{
				   if(ctstmt != null){//关闭连接
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }				
	}
	
	/**
	 * 调用接口通用方法
	 * @param url 接口地址
	 * @return
	 * @throws Exception
	 */
	public static String getHtml(String url) throws Exception {
		HttpGet httpGet = new HttpGet(url);
		HttpResponse response;
		String responseString = "";
		HttpEntity entity = null;
		try {
			DefaultHttpClient httpClient = new DefaultHttpClient();
			response = httpClient.execute(httpGet);
			entity = response.getEntity(); // 返回服务器响应
			// 这样获取返回的html就不需要象以前的打印流了
			responseString = EntityUtils.toString(response.getEntity()); //返回服务器响应HTML代码
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (entity != null) {
				entity.consumeContent(); // 释放连接
			}
		}
		return responseString;
	}
	
	static class CallRecordJson{
    	private String logintime;
    	private long paytotal;
		public String getLogintime() {
			return logintime;
		}
		public void setLogintime(String logintime) {
			this.logintime = logintime;
		}
		public long getPaytotal() {
			return paytotal;
		}
		public void setPaytotal(long paytotal) {
			this.paytotal = paytotal;
		}	
    }
}
