package com.xunlei.niux.manager.web.vo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import com.xunlei.common.util.XLRuntimeException;


public class BigCustomerTask {
	private static final Logger logger = Logger.getLogger(BigCustomerTask.class.getName());
	private static final String SPEEDPATH = "/tmp/bigcustomerdetail/";
	
	public static void main(String args[]){
	   logger.info("开始执行大客户统计定时任务");	
	   make();
	   logger.info("大客户统计定时任务执行完毕");	
	   logger.info("开始执行大客户详情加速");	
	   speed();
	   logger.info("大客户详情加速完毕");	
	}
	
	
	/**
	 * 定时生成大客户统计数据
	 */
	public static void make(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String time = sdf.format(new Date());
		time = formatBeforeDay(time);
		String sub[] = time.split("-");
		time = sub[0] + sub[1] + sub[2];
		logger.info("time==================>"+time);	
		String url = "http://twin13024.sandai.net:8001/scanPlatNewForBigR?date="+time;
		String message = null;
		int flag = 0;
		 try{
	    	String responseString =  getHtml(url);	    	
	    	if(responseString != null && !"".equals(responseString)){
	    		String str[] = responseString.split("&");
	    		String status = str[0].split("=")[1];
	    		message = str[1].split("=")[1];
	    		flag = Integer.parseInt(status);
	    		if(flag != 1){
	    			logger.info(URLDecoder.decode(message,"utf8"));
	    		}
	    	}
	    }catch(Exception e){
	    	logger.info("大客户统计的任务执行失败，原因：" + e.getMessage());
	    }
	}
	
	/**
	 * 游戏详情查询效率提速
	 */
	public static void speed(){
		try{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			String time = sdf.format(new Date());
			time = formatBeforeDay(time);
			String baseUrl = getUrl();		
			String filepath = getFilesPath(time);
			String path = SPEEDPATH;
			String dirtime = formatDay2(time);
			if(!checkFile(path+dirtime)){
				if(filepath.indexOf(",")>-1){//如果有多个文件
					for(String subFilePath:filepath.split(",")){
						downLoad(baseUrl, subFilePath, time, path);
					}
				}else{//如果只有一个文件
					downLoad(baseUrl, filepath, time, path);
				}
				logger.info("游戏详情查询加速成功");
			}else{
				logger.info("游戏详情查询已经加速");
			}
	
		}catch(Exception e){
			logger.info("游戏详情查询加速失败，原因：" + e.getMessage());
		}
	}
	
	/**
	 * 按照日期读出统计前一天的数据
	 * @return
	 */
	public static String getFilesPath(String nowtime){	
		String filepath = null;
		Connection conn = null;
		ResultSet rs = null;
		Statement stmt = null;
		logger.info("nowtime=====================>"+nowtime);
		try {
			String strs[] = nowtime.split("-");
			conn = getConnection();
			String sql = "SELECT fileurl FROM bigcustomerquery WHERE daytime = ?";// 取出文件路径
			sql = sql.replace("?", "'"+strs[0]+strs[1]+strs[2]+"'");
			logger.info("filepath_sql===================>"+sql);
			stmt = getStatement(conn);
			rs = getResultSet(stmt, sql);		
			if(rs == null){
				logger.info("大客户表中数据有问题,日期不对,日期为："+nowtime);
				throw new XLRuntimeException("大客户表中数据有问题,日期不对,日期为："+nowtime);
			}				
			rs.next();
			filepath = rs.getString("fileurl");		
			if(filepath==null||"".equals(filepath)){
				logger.info("大客户表中数据有问题,路径为空。日期为："+nowtime);
				throw new XLRuntimeException("大客户表中数据有问题,路径为空。日期为："+nowtime);
			}	
		} catch (SQLException e) {
			e.printStackTrace();
			logger.info(e.getMessage());
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return filepath;
		
	}
	public static String getUrl(){		
		String bigCustomerRemoteUrl= "http://twin13024.sandai.net:8080/hdfs-webdav";
		logger.info("url获得成功");
		return bigCustomerRemoteUrl;
	}
	
	public static String getHtml(String url) throws Exception {
		HttpGet httpGet = new HttpGet(url);
		HttpResponse response;
		String responseString = "";
		HttpEntity entity = null;
		try {
			DefaultHttpClient httpClient = new DefaultHttpClient();
			response = httpClient.execute(httpGet);
			entity = response.getEntity(); // 返回服务器响应
			// 这样获取返回的html就不需要象以前的打印流了
			responseString = EntityUtils.toString(response.getEntity()); //返回服务器响应HTML代码
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (entity != null) {
				entity.consumeContent(); // 释放连接
			}
		}
		return responseString;
	}
	
	/**
	 * 取时间格式为：yyyy-MM-dd 日期的前一天 
	 * @param daytime
	 * @return
	 */
	public static String formatBeforeDay(String daytime){
		if(daytime==null||"".equals(daytime))return null;
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date = sdf.parse(daytime);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String now = sdf.format(cal.getTime());
		logger.info("now================>"+now);		
		return now;
	}
	
	/**
	 * 判断目录下是否有文体存在
	 * @param time
	 * @return
	 */
	public static boolean checkFile(String path){
		File file = null;
		try{
			file = new File(path);
            long len = 0L;
			if(file.exists()){
            	File [] files = file.listFiles();
            	if(files != null && files.length > 0)
	            	for(File child:files){
	            		len += child.length();
	            	}
            }else{
            	file.mkdir();
            }
			len = len/(1024*1024);
		    if(len <= 3){
		    	File [] files = file.listFiles();
		    	if(files != null && files.length > 0)
			    	for(File child:files){
	            		child.delete();
	            	}
		    	return false;
		    }
		}catch(Exception e){
			e.printStackTrace();
		}
		return true;
	}
	
	/**
	 * /
	 * 将远程服务器上面的文件下载到本地服务器，以达到提速的效果
	 * @param baseUrl 远程服务器路径
	 * @param filepath 文件名称
	 * @param time 指定时间
	 * @param path 要保存的路径
		 */
	public static void downLoad(String baseUrl,String fileName,String time,String path){
		URL url = null;
		File file = null;
		try {
			url = new URL(baseUrl+fileName);
            logger.info("url========================>"+url);			
		} catch (MalformedURLException e) {
			logger.info("文件找不到，文件路径为："+baseUrl+fileName+"，请查看是否正确。错误代码："+e.getMessage());
			throw new XLRuntimeException("文件找不到，文件路径为："+baseUrl+fileName+"，请查看是否正确");
		} 
		HttpURLConnection httpUrl = null;
		BufferedReader br = null;
		FileOutputStream fos = null;
		BufferedWriter bw = null;
		//连接指定的网络资源 
		try {
			httpUrl = (HttpURLConnection) url.openConnection(); 
			httpUrl.connect();
			//获取网络输入流 
			if(fileName != null){
				fileName = fileName.substring(fileName.lastIndexOf("/"));
			}
			time = formatDay2(time);			
			br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 
			file = new File(path+time);
			if(!file.exists()){
				file.mkdirs();
			}
			file =  new File(path+time+fileName);
            logger.info(path+time+fileName);				
			if(!file.exists()){
				file.createNewFile();
			}
			fos = new FileOutputStream(file);
			bw = new BufferedWriter(new OutputStreamWriter(fos));	
			String readLine = br.readLine();
			int line = 0;
			while(readLine != null){
			   line ++;	   
               bw.write(readLine);
               bw.write("\n");
               readLine = br.readLine();
			}
			bw.flush();
	}catch(Exception e){
		logger.info(e.getMessage());
		e.printStackTrace();
	}finally{
		try{
		   if(bw != null){
			   bw.close();
			   bw = null;
		   }
		   if(fos != null){
			   fos.close();
			   fos = null;
		   }
		   if(br != null){
			   br.close();
			   br = null;
		   }
		   if(httpUrl != null){
			   httpUrl.disconnect();
			   httpUrl = null;
		   }
		}catch(Exception e){
			
		}
	  }
    }
	
	
	/**
	 * 格式化时间
	 * @param time
	 * @return
	 */
	public static String formatDay2(String time){
		if(time != null){
			String stimes[] = time.split("-");
			time = stimes[0]+stimes[1]+stimes[2];
		}	
		return time;
	}
	
	public static Connection getConnection(){
		// 驱动程序名           
		String driver = "com.mysql.jdbc.Driver";
		String url = "jdbc:mysql://localhost:3306/vip_game_info";
		String user = "root"; 
	    String password = "wg08a49";
	    Connection conn = null;
		try {
			Class.forName(driver);
			conn = DriverManager.getConnection(url, user, password);
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		} 
		return conn;
	}
	
	public static Statement getStatement(Connection conn){
		Statement statement = null;
		try {
			statement = conn.createStatement();
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return statement;
	}
	
	public static ResultSet getResultSet(Statement statement,String sql){
		ResultSet rs = null;
		try{
			rs = statement.executeQuery(sql);
		}catch(Exception e){
			e.printStackTrace();
		}
		return rs;
	}
}
