package com.xunlei.niux.manager.web.util;


import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.manager.web.exception.NiuxException;
import com.xunlei.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

/**
 * 短信客户端
 * @author Administrator
 *
 */
public class SmsClient {
	private static String sms_domain= EnvPropertyUtil.loadProperty("sms", "sms_domain");
	private static String sms_bizno=EnvPropertyUtil.loadProperty("sms", "sms_bizno");//"000005";
	private static String sms_bizpwd=EnvPropertyUtil.loadProperty("sms", "sms_bizpwd");//"ljdfjklsdjieurie";
	private static String monitor_sms_bizno=EnvPropertyUtil.loadProperty("sms", "monitor_sms_bizno");//"000005";
	private static String monitor_sms_bizkey=EnvPropertyUtil.loadProperty("sms", "monitor_sms_bizpwd");//"ljdfjklsdjieurie";
	private static String sms_identifyingcodelen="6";
	private static String sms_identifyingcodeonlynum="1";//是否纯数字验证码 除了纯数字验证码，就是字母和数字的组合验证码
	private static String sms_identifyingcodeexpire="300";//验证码过期时间，单位秒
	private static String sms_identifyingcodesmscontentformat="验证码{}【迅雷网络】";
	private static Logger logger = Log.getLogger(SmsClient.class);
	
    private static Map<String ,String> errCodeMap = new HashMap<String, String>();

    static {    	
        errCodeMap.put("12", "手机号或短信形容为空");
        errCodeMap.put("13", "手机号格式不正确");
        errCodeMap.put("21", "不好意思，您的验证码失效，请重新获取~");
        errCodeMap.put("22", "不好意思，您的验证码错误，请重新输入~");
        errCodeMap.put("28", "手机号长度不正确");
    }

    public static void sendIdentifyingCode(String mobileNum) throws Exception {
        sendIdentifyingCode(mobileNum, sms_identifyingcodesmscontentformat);
    }

    /**
     * 用于系统监控时发短信的接口
     * @param mobileNum
     * @param content
     * @throws NiuxException
     */
    public static void sendMonitorIdentifyingCode(String mobileNum, String content)throws NiuxException{
		if(content.endsWith("【迅雷网络】")==false){
			content=content+"【迅雷网络】";
		}
		Map<String,String> param=new HashMap<String,String>();
		param.put("version", "v1.0");
		param.put("pageCharset","GBK");
		param.put("bizNo", monitor_sms_bizno);
		param.put("mobile", mobileNum);
		param.put("content", content);
		String signPwd=SignUtil.sign(param, monitor_sms_bizkey);
		param.put("needCode", "0");
		param.put("codeLen", sms_identifyingcodelen);
		param.put("onlyNum", sms_identifyingcodeonlynum);
		param.put("expire", sms_identifyingcodeexpire);
		String paramStr=SignUtil.getSignatureContent(param, "UTF-8");
		try{
		    String url = sms_domain+"/sendsms?"+paramStr+"&signMsg="+signPwd;
		    logger.info("send sms message phone:"+mobileNum+", url:"+url);
			String resp=HttpClientUtil.get(url);
			if(!resp.contains("<sendresult>00</sendresult>")){
				String errorCode=resp.substring(resp.indexOf("<errcode>")+9, resp.indexOf("</errcode>"));
				throw new NiuxException(errorCode, errCodeMap.get(errorCode));
			}
		}catch(NiuxException e){
			throw e;
		}catch(Exception e){
			throw new NiuxException("99",e.getMessage(), e);
		}
	}

    /**
	 * 发送短信验证码
	 * @param mobileNum 手机号
	 * @return 返回编码，00：表示发送正确，其他伟错误代码
	 */
	public static void sendIdentifyingCode(String mobileNum, String content)throws NiuxException{
		if(content.endsWith("【迅雷网络】")==false){
			content=content+"【迅雷网络】";
		}
		Map<String,String> param=new HashMap<String,String>();
		param.put("version", "v1.0");
		param.put("pageCharset","GBK");
		param.put("bizNo", sms_bizno);
		param.put("mobile", mobileNum);
		param.put("content", content);
		String signPwd=SignUtil.sign(param, sms_bizpwd);
		param.put("needCode", "1");
		param.put("codeLen", sms_identifyingcodelen);
		param.put("onlyNum", sms_identifyingcodeonlynum);
		param.put("expire", sms_identifyingcodeexpire);
		String paramStr=SignUtil.getSignatureContent(param, "UTF-8");
		try{
		    String url = sms_domain+"/sendsms?"+paramStr+"&signMsg="+signPwd;
		    logger.info("send sms message phone:"+mobileNum+", url:"+url);
			String resp=HttpClientUtil.get(url);
			if(!resp.contains("<sendresult>00</sendresult>")){
				String errorCode=resp.substring(resp.indexOf("<errcode>")+9, resp.indexOf("</errcode>"));
				throw new NiuxException(errorCode, errCodeMap.get(errorCode));
			}
		}catch(NiuxException e){
			throw e;
		}catch(Exception e){
			throw new NiuxException("99",e.getMessage(), e);
		}
	}
	public static void sendSms(String mobileNum, String content)throws NiuxException{
		if(content.endsWith("【迅雷网络】")==false){
			content=content+"【迅雷网络】";
		}
		Map<String,String> param=new HashMap<String,String>();
		param.put("version", "v1.0");
		param.put("pageCharset","GBK");
		param.put("bizNo", sms_bizno);
		param.put("mobile", mobileNum);
		param.put("content", content);
		String signPwd=SignUtil.sign(param, sms_bizpwd);
		String paramStr=SignUtil.getSignatureContent(param, "UTF-8");
		try{
			String url = sms_domain+"/sendsms?"+paramStr+"&signMsg="+signPwd;
			System.out.println("smsurl:"+url);
			String resp=HttpClientUtil.get(url);
			if(!resp.contains("<sendresult>00</sendresult>")){
				String errorCode=resp.substring(resp.indexOf("<errcode>")+9, resp.indexOf("</errcode>"));
				System.out.println("errorMsg:"+errCodeMap.get(errorCode));
				throw new NiuxException(errorCode, errCodeMap.get(errorCode));
			}
		}catch(NiuxException e){
			throw e;
		}catch(Exception e){
			throw new NiuxException("99",e.getMessage(), e);
		}
	}
	/**
	 * 
	 * @param mobileNum
	 * @param code
	 * @throws NiuxException
	 */
	public static void checkIdentifyingCode(String mobileNum,String code)throws NiuxException{
		if(mobileNum==null||"".equals(mobileNum)){
			throw new NiuxException("13", "手机号为空");
		}
		if(code==null||"".equals(code)){
			throw new NiuxException("14", "验证码为空");
		}
		StringBuilder sb=new StringBuilder();
		sb.append(sms_domain).append("/validate?")
		  .append("mobile=").append(mobileNum)
		  .append("&bizNo=").append(sms_bizno)
		  .append("&authcode=").append(code);
		try{
			String resp=HttpClientUtil.get(sb.toString());
			if(!resp.contains("<sendresult>00</sendresult>")){
				String errorCode=resp.substring(resp.indexOf("<errcode>")+9, resp.indexOf("</errcode>"));
				throw new NiuxException(errorCode, errCodeMap.get(errorCode));
			}
		}catch(NiuxException e){
			throw e;
		}catch(Exception e){
			throw new NiuxException("99",e.getMessage(), e);
		}
	}
	
	public static void main(String[] args){
		try {
			SmsClient.sendMonitorIdentifyingCode("13418464767", "test");
		} catch (NiuxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
