package com.xunlei.niux.manager.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import com.xunlei.channel.util.Md5Encrypt;

public class SignUtil {
	public static String sign(String content, String privateKey) {
		if (content == null) {
			return null;
		}
		return Md5Encrypt.md5(content + privateKey);
	}
	public static String sign(Map<String, String> param,String privateKey,String encodeCharset){
		return sign(getSignatureContent(param, encodeCharset),privateKey);
	}
	public static String sign(Map<String, String> param,String privateKey){
		return sign(getSignatureContent(param),privateKey);
	}
	public static String getSignatureContent(Map<String, String> param) {
		return getSignatureContent(param, null);
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static String getSignatureContent(Map<String, String> param,
			String encodeCharset) {
		Properties prop = new Properties();
		for (String key : param.keySet()) {
			if (key.equals("signMsg")) {
				continue;
			}
			String value = (String) param.get(key);
			if (value != null && !"".equals(value)) {
				prop.setProperty(key, value);
			}
		}
		StringBuilder sb = new StringBuilder();
		Object keys = new ArrayList<Object>(prop.keySet());
		Collections.sort((List) keys);
		for (int i = 0; i < ((List) keys).size(); i++) {
			String key = (String) ((List) keys).get(i);

			String value = prop.getProperty(key);
			if (encodeCharset != null && !"".equals(encodeCharset))
				try {
					value = URLEncoder.encode(prop.getProperty(key),
							encodeCharset);
				} catch (Exception localException) {
				}
			sb.append(i == 0 ? "" : "&");
			sb.append(key).append("=").append(value);
		}

		return (String) sb.toString();
	}
	public static String urlEncode(String value,String charset){
		try {
			return URLEncoder.encode(value, charset);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
}
