package com.xunlei.niux.manager.web.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.xunlei.common.facade.IFacadeCommon;


/**
 * 生成二维码(QR Code)的工具类
 * 
 * @since 2014-10-17
 * @author lisu
 */
public class QRCodeUtil {
	private static  String qcodePath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("qcodePath");	//二维码图片远程存放路径
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//二维码图片本地存放路径
	private static final String SYNCPICCOMMONDPHOTO = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("syncPicCommond");
	private static final Logger logger = Logger.getLogger(QRCodeUtil.class.getName());
	private static final String DEFAULTSIZE = "300";
	   
	public static String getPath(String gameId){
		String codes [] = qcodePath.split("/");
		String apkcode = codes[codes.length-1];
		String path = FILEPATH+apkcode+"/"+gameId;
		return path;
	}
	
	/**
	 * 生成jump二维码图片
	 * @param gameId
	 * @param content
	 * @param gameNo
	 * @return
	 */
	public static String makeJumpApkMultiFile(String advNo,String version,String gameId,String gameNo,String content){
		return makeJumpApkMultiFile(advNo,version,gameId,content,gameNo,DEFAULTSIZE,DEFAULTSIZE);
	}
	
	public static String makeJumpApkMultiFile(String advNo,String version,String gameId,String content,String gameNo,String weidth,String height){
		 String path = getPath(gameId);
		 File file = new File(path);
		 if(!file.exists()){
			 file.mkdirs();
		 }
		QRCodeUtil.makeMultiFile(content, (gameNo+advNo+version)+".png", path, 300, 300);
		synchPhoto();//同步二维码图片
		return qcodePath+gameId+"/"+((gameNo+advNo+version)+".png");
	}
	
	
	public static void synchPhoto() {
		try {
			 logger.info("开始同步二维码图片,地址:/usr/local/bin/"+SYNCPICCOMMONDPHOTO);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMONDPHOTO);	
			 logger.info("apk同步成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	}
	
	  public static void main(String args[]){
		  makeMultiFile("http://pay.niu.xunlei.com/mobile/pay.html","pay_90.png","c:/tmp",95,95);
		  makeMultiFile("http://pay.niu.xunlei.com/mobile/pay.html","pay_150.png","c:/tmp",150,150);
		  makeMultiFile("http://pay.niu.xunlei.com/mobile/pay.html","pay_300.png","c:/tmp",300,300);
	  }
	  public static  void makeMultiFile(String content,String fileName,String path,int awidth,int aheight){
			try {            
				 File file = new File(path);
				 if(!file.exists()){
					 file.mkdirs();
				 }	     				
			     MultiFormatWriter multiFormatWriter = new MultiFormatWriter();		     
			     Map<EncodeHintType,Object> hints = new HashMap<EncodeHintType,Object>();
			     hints.put(EncodeHintType.MARGIN, 0); 
			     hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
			     BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, awidth, aheight,hints);
			     File file1 = new File(path,fileName);
			     MatrixToImageConfig config = new MatrixToImageConfig(0xFF000001, 0xFFFFFFFF);
			     MatrixToImageWriter.writeToFile(bitMatrix, "png", file1,config);
			   //1.1去白边
			     int[] rec = bitMatrix.getEnclosingRectangle();  
			     int resWidth = rec[2] + 1;  
			     int resHeight = rec[3] + 1;  
			     BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);  
			     resMatrix.clear();  
			     for (int i = 0; i < resWidth; i++) {  
			         for (int j = 0; j < resHeight; j++) {  
			             if (bitMatrix.get(i + rec[0], j + rec[1])) { 
			                  resMatrix.set(i, j); 
			             } 
			         }  
			     }  
			     int width = resMatrix.getWidth();
			     int height = resMatrix.getHeight();
			     int onColor = config.getPixelOnColor();
	             int offColor = config.getPixelOffColor();
			     BufferedImage image = new BufferedImage(width, height,onColor != -16777216 || offColor != -1 ? 1 : 12);
		       
			     for (int x = 0; x < width; x++) {
			         for (int y = 0; y < height; y++) {
			             image.setRGB(x, y, resMatrix.get(x, y) == true ? 
			             Color.BLACK.getRGB():Color.WHITE.getRGB());		    
			             image.setRGB(x, y, resMatrix.get(x, y) ? onColor : offColor);
			         }
			     }
			     ImageIO.write(image,"png", file1);		     			
			 } catch (Exception e) {
			     e.printStackTrace();
			 }
			 System.out.println(path+"/"+fileName);
		}
}
