package com.xunlei.niux.manager.web.util;


import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;

public class PageUtil {

	public static Page formatPage(PagedFliper pf){
		Page page=new Page();
		page.setPageNo(pf.getPageNo());
		page.setPageSize(pf.getPageSize());
		String sort=pf.getSortColumn();
		if(sort==null||"".equals(sort)){
			return page;
		}
		String[] sortArray=sort.trim().split(" ");
		if(sortArray.length<2){
			return page;
		}
		if("desc".equals(sortArray[1])){
			page.addOrder(sortArray[0], OrderType.DESC);
		}else{
			page.addOrder(sortArray[0], OrderType.ESC);
		}
		return page;
	}
	/**
	 * 
	 * @param pf
	 * @param defaultSorts 排序字段类表  
	 * @return
	 */
	public static Page formatPage(PagedFliper pf,String ...defaultSorts){
		Page page=new Page();
		page.setPageNo(pf.getPageNo());
		page.setPageSize(pf.getPageSize());
		String sort=pf.getSortColumn();
		//如果sort为空设置默认排序；否则按照sort排序
		if(sort==null||"".equals(sort)){
			for(int i=1;i<defaultSorts.length;i=i+2){
				if("desc".equals(defaultSorts[i])){
					page.addOrder(defaultSorts[i-1], OrderType.DESC);
				}else{
					page.addOrder(defaultSorts[i-1], OrderType.ESC);
				}
			}
		}else{
			String[] sortArray=sort.trim().split(" ");
			if(sortArray.length<2){
				return page;
			}
			if("desc".equals(sortArray[1])){
				page.addOrder(sortArray[0], OrderType.DESC);
			}else{
				page.addOrder(sortArray[0], OrderType.ESC);
			}
		}
		return page;
	}
}
