package com.xunlei.niux.manager.web.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.CoreConnectionPNames;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
	public static String get(String url,String action){
		try {
			HttpClient client=new DefaultHttpClient();
			HttpGet get=new HttpGet(url+action);
			HttpResponse response = client.execute(get);
			HttpEntity entity=response.getEntity();
			return EntityUtils.toString(entity);
		} catch (ClientProtocolException e) {
			throw new RuntimeException(e);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
	public static String get(String url){
		try {
			HttpClient client=new DefaultHttpClient();
			HttpGet get=new HttpGet(url);
			HttpResponse response = client.execute(get);
			HttpEntity entity=response.getEntity();
			return EntityUtils.toString(entity);
		} catch (ClientProtocolException e) {
			throw new RuntimeException(e);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}

	}
	public static String decode(String value){
		if(value==null){
			return value;
		}
		try {
			return URLDecoder.decode(value, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return "";
		}
	}
	
	/**
	 * 通过get方式调用接口
	 * @param url add by lisu 2013-02-26
	 * @return
	 */
	public static String getInfoForHttpGetMothed(String url) {
		HttpClient client = null;
		try {
			HttpGet httpget = new HttpGet(url);
			client = new DefaultHttpClient();
			client.getParams().setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT,  3000);//连接时间3s
			client.getParams().setParameter(CoreConnectionPNames.SO_TIMEOUT,  6000);//数据传输时间6s
			String backStr = "";
			ResponseHandler<String> responseHandler = new BasicResponseHandler();			
			backStr = client.execute(httpget, responseHandler);
			return backStr;
		} catch (Throwable e) {
			e.printStackTrace();
		} finally {
			if(client!=null){//释放连接
				client.getConnectionManager().shutdown();
			}
		}
		return "";
	}	
	
	public static String getHtml(String url) throws Exception {
		HttpGet httpGet = new HttpGet(url);
		HttpResponse response;
		String responseString = "";
		HttpEntity entity = null;
		DefaultHttpClient httpClient = new DefaultHttpClient();
		try {			
			response = httpClient.execute(httpGet);
			entity = response.getEntity(); // 返回服务器响应
			// 这样获取返回的html就不需要象以前的打印流了
			responseString = EntityUtils.toString(response.getEntity()); //返回服务器响应HTML代码
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (entity != null) {
				entity.consumeContent(); // 释放连接
			}
			if(httpClient!=null){
				httpClient.getConnectionManager().shutdown();
			}
		}
		return responseString;
	}
	
	public static void main(String[] args){
		String i="\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u73b0\u5728\u8fd8\u6ca1\u6709\u83b7\u5f97\u8fc7\u73b0\u91d1\u5238\u3002";
		System.out.println(decode(i));
	}
}
