package com.xunlei.niux.manager.web.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import org.apache.log4j.Logger;

/**
 * 文件帮助类，主要功能：创建文件；删除文件；读写文件
 * @author lin
 * @date 2012-9-3
 * @Descripter:
 */
public class FileUtil {
	private static final Logger logger = Logger.getLogger(FileUtil.class.getName());
	/**
	 * 创建文件
	 * @param filePath
	 * @return
	 */
	public static File createFile(String dirPath,String fileName){
		dirPath=dirPath==null?"":dirPath.replaceAll("\\\\", "/");
		File dir=new File(dirPath);
		if((!dir.exists())&&(!dir.isDirectory())){
			dir.mkdirs();
		}
		String filepath=dirPath.endsWith("/")?dirPath+fileName:dirPath+"/"+fileName;
		System.out.println(filepath);
		return new File(filepath);
	}
	/**
	 * 关闭输入流
	 * @param out
	 */
    public static void close(OutputStream out){
    	try{
    		if(out!=null){
    			out.close();
    		}
    	}catch(Exception e){
    		logger.error("关闭inputstream出现异常");
    	}
    }
    /**
     * 关闭输入流
     * @param out
     */
    public static void close(Writer out){
    	try{
    		if(out!=null){
    			out.close();
    		}
    	}catch(Exception e){
    		logger.error("关闭inputstream出现异常");
    	}
    }
	public static void writeByChar(File file,String content){
		BufferedWriter bufw = null;
		try{
			bufw=new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file), "UTF-8"));
			bufw.write(content);
			bufw.flush();
		}catch(Exception e){
			throw new RuntimeException(e);
		}finally{
			close(bufw);
		}
	}
	public static void writeByChar(String path,String content){
		File file =new File(path);
		writeByChar(file, content);
	}
}
