package com.xunlei.niux.manager.web.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;


import com.xunlei.niux.manager.web.model.ParamCacheManagedBean;
/**
 * 上传文件帮助类
 * @author lin
 * @date 2012-8-8
 * @Descripter:
 */
public class FileUploadUtil {
	private static Logger logger=Logger.getLogger(FileUploadUtil.class.getName());
	private static int bufsize=1024*4;
	
	/**
	 * 文件上传工具，可以自定义存储路径
	 * @param theFile
	 * @param storePath
	 * @return
	 * @throws Exception
	 */
	 public static  String upLoadFile(UploadedFile theFile,String storePath)throws Exception
		{	
	    	if(theFile==null){
	    		throw new Exception("文件为空");
	    	}
	    	logger.info("文件名："+theFile.getName());
	    	InputStream in=null;
	    	OutputStream out =null;
	    	try{
//	    		int lastIndexDol = theFile.getName().lastIndexOf(".");
	    		String fname = theFile.getName();
//	            String fsup = theFile.getName().substring(0, lastIndexDol);;
	            String fsub = fname.substring(fname.lastIndexOf(".") + 1, fname.length());
	            fname = System.currentTimeMillis() + "." + fsub;
	            in = theFile.getInputStream();
	            String filepath=storePath+ fname;
	            logger.info("存储文件路径："+filepath);
	            out = new FileOutputStream(filepath);
	            byte[] buf=new byte[bufsize];
	            int len=-1;
	            while((len=in.read(buf))>0){
	            	out.write(buf, 0, len);
	            }
	            return fname;
	    	}catch(Exception e){
	    		logger.error("写文件出现异常",e);
	    		throw new Exception("写文件出现异常", e);
	    	}finally{
	    		close(in);
	    		close(out);
	    	}
	    }
	
	
    public static  String upLoadFile(UploadedFile theFile)throws Exception
	{	
    	if(theFile==null){
    		throw new Exception("文件为空");
    	}
    	logger.info("文件名："+theFile.getName());
    	InputStream in=null;
    	OutputStream out =null;
    	try{
//    		int lastIndexDol = theFile.getName().lastIndexOf(".");
    		String fname = theFile.getName();
//            String fsup = theFile.getName().substring(0, lastIndexDol);;
            String fsub = fname.substring(fname.lastIndexOf(".") + 1, fname.length());
            fname = System.currentTimeMillis() + "." + fsub;
            in = theFile.getInputStream();
            String filepath=ParamCacheManagedBean.getUploadPicStorePath()+ fname;
            logger.info("存储图片路径："+filepath);
            out = new FileOutputStream(filepath);
            byte[] buf=new byte[bufsize];
            int len=-1;
            while((len=in.read(buf))>0){
            	out.write(buf, 0, len);
            }
            return fname;
    	}catch(Exception e){
    		logger.error("写文件出现异常",e);
    		throw new Exception("写文件出现异常", e);
    	}finally{
    		close(in);
    		close(out);
    	}
    }
    public static void close(InputStream in){
    	try{
    		if(in!=null){
    			in.close();
    		}
    	}catch(Exception e){
    		logger.error("关闭inputstream出现异常");
    	}
    }
    public static void close(OutputStream out){
    	try{
    		if(out!=null){
    			out.close();
    		}
    	}catch(Exception e){
    		logger.error("关闭inputstream出现异常");
    	}
    }
    public static void copy(File src,File desc)throws Exception{
    	InputStream in=null;
    	OutputStream out =null;
    	try{
    		in = new FileInputStream(src);
    		out=new FileOutputStream(desc);
    		byte[] buf=new byte[bufsize];
            int len=-1;
            while((len=in.read(buf))>0){
            	out.write(buf, 0, len);
            }
    	}catch(Exception e){
    		throw e;
    	}finally{
    		close(in);
    		close(out);
    	}
    }
    public static void write(File file,String context)throws Exception{
    	OutputStream out =null;
    	try{
    		out=new FileOutputStream(file);
    		out.write(context.getBytes("utf-8"));
    	}catch(Exception e){
    		throw e;
    	}finally{
    		close(out);
    	}
    }
    public static void delete(File file)throws Exception{
    	file.delete();
    }
}
