package com.xunlei.niux.manager.web.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;


/**
 * excel 生成工具
 * 
 * @author lisu 2012-12-7
 */
public class ExcelUtil {
	private static final int MAXSIZE = 30000;
	
	public static void main(String args[]){
		String title = "贵宾数据新增贵宾";
		String[] columnName = { "编号", "产品名称", "产品价格", "产品数量", "生产日期", "产地", "是否出口" };
		String filePath = "d:\\test.xls";
		List list = new ArrayList();
		List lista = new ArrayList();
		lista.add(123);
		lista.add(123123.12);
		lista.add("sdfdf");
		List listb = new ArrayList();
		listb.add("34323");
		listb.add("2012-12-07");
		listb.add(123);
		list.add(lista);
		list.add(listb);
		long beginTime = System.currentTimeMillis();
		ExcelUtil.create("产品清单",title,columnName,filePath,list);
		long endTime = System.currentTimeMillis();
		System.out.println("生成excel文件总共花费时间："+(endTime-beginTime)+"ms");
	}
	
	/**
	 * 生成execl文件
	 * @param sheetName 工作空间名称
	 * @param titles 列名称
	 * @param filePath 文件生成路径  
	 * @param detailsList 数据
	 */
	public static Workbook create(String sheetName,String title,String [] columnName,String filePath,List<List> detailsList) {
		
		Workbook wb = new HSSFWorkbook();// 创建一个EXCEL
		int size = detailsList.size();
		if(size == 0){
			Sheet sheet = wb.createSheet(sheetName);
			sheet.setColumnWidth(0, 3766);
			int oo = 0;					
			
			/**
			 *  初始化样式
			 */
			 CellStyle style = wb.createCellStyle();
			 for(int i=0;i<columnName.length;i++)
			    sheet.setColumnWidth(i, 3800); 
	  
			/**
			 * 填充标题
			 */
			Row row0 = sheet.createRow((short) 0);// 创建一行		
			Cell cell0 = row0.createCell((short) 0);
	        cell0.setCellValue(title);
	        sheet.addMergedRegion(new CellRangeAddress(0,0,0,columnName.length-1));//设置合并的区域
			style.setVerticalAlignment(CellStyle.VERTICAL_CENTER);//垂直   
			style.setAlignment(CellStyle.ALIGN_CENTER);//水平 
			Font titleFont = wb.createFont();
			titleFont.setFontName("黑体");
			titleFont.setColor((short)12);
			titleFont.setFontHeightInPoints((short) 16);//设置字体大小
			titleFont.setBoldweight(Font.BOLDWEIGHT_BOLD);//粗体显示
			style.setFont(titleFont);
			row0.setHeight((short) 500);
	        cell0.setCellStyle(style);
	        
			/**
			 * 填充列名称
			 */
	        CellStyle style2 = wb.createCellStyle();
	        Font columnFont = wb.createFont();
	        columnFont.setFontName("黑体");
	        columnFont.setFontHeightInPoints((short) 11);//设置字体大小
	        columnFont.setBoldweight(Font.BOLDWEIGHT_BOLD);//粗体显示
			style2.setFont(columnFont);		
			style2.setVerticalAlignment(CellStyle.VERTICAL_CENTER);//垂直   
			style2.setAlignment(CellStyle.ALIGN_CENTER);//水平 
			Row row1 = sheet.createRow((short) 1);// 创建一行
			row1.setHeight((short) 330);
			row1.setRowStyle(style2);
			for (String s : columnName) {
				Cell cell = row1.createCell(oo);
				cell.setCellValue(s);
				cell.setCellStyle(style2);
				oo++;
			}
			
		}else{
			int len = size%MAXSIZE==0?size/MAXSIZE:size/MAXSIZE+1;//求出导出到多少个sheet里面，如果数据量比较大的话，每个sheet里面只能存MAXSIZE行	
			for(int ii=0;ii<len;ii++){
				Sheet sheet = wb.createSheet(sheetName+(ii>=1?ii:""));// 创建一个SHEET	
				sheet.setColumnWidth(0, 3766);
				int oo = 0;					
				
				/**
				 *  初始化样式
				 */
				 CellStyle style = wb.createCellStyle();
				 for(int i=0;i<columnName.length;i++)
				    sheet.setColumnWidth(i, 3800); 
		  
				/**
				 * 填充标题
				 */
				Row row0 = sheet.createRow((short) 0);// 创建一行		
				Cell cell0 = row0.createCell((short) 0);
		        cell0.setCellValue(title);
		        sheet.addMergedRegion(new CellRangeAddress(0,0,0,columnName.length-1));//设置合并的区域
				style.setVerticalAlignment(CellStyle.VERTICAL_CENTER);//垂直   
				style.setAlignment(CellStyle.ALIGN_CENTER);//水平 
				Font titleFont = wb.createFont();
				titleFont.setFontName("黑体");
				titleFont.setColor((short)12);
				titleFont.setFontHeightInPoints((short) 16);//设置字体大小
				titleFont.setBoldweight(Font.BOLDWEIGHT_BOLD);//粗体显示
				style.setFont(titleFont);
				row0.setHeight((short) 500);
		        cell0.setCellStyle(style);
		        
				/**
				 * 填充列名称
				 */
		        CellStyle style2 = wb.createCellStyle();
		        Font columnFont = wb.createFont();
		        columnFont.setFontName("黑体");
		        columnFont.setFontHeightInPoints((short) 11);//设置字体大小
		        columnFont.setBoldweight(Font.BOLDWEIGHT_BOLD);//粗体显示
				style2.setFont(columnFont);		
				style2.setVerticalAlignment(CellStyle.VERTICAL_CENTER);//垂直   
				style2.setAlignment(CellStyle.ALIGN_CENTER);//水平 
				Row row1 = sheet.createRow((short) 1);// 创建一行
				row1.setHeight((short) 330);
				row1.setRowStyle(style2);
				for (String s : columnName) {
					Cell cell = row1.createCell(oo);
					cell.setCellValue(s);
					cell.setCellStyle(style2);
					oo++;
				}
				
				
				/**
				 * 填充各列数据
				 */
				CellStyle style3 = wb.createCellStyle();
		        Font dataFont = wb.createFont();
		        dataFont.setFontHeightInPoints((short) 10);//设置字体大小
				style3.setFont(dataFont);		
				style3.setVerticalAlignment(CellStyle.VERTICAL_CENTER);//垂直   
				style3.setAlignment(CellStyle.ALIGN_CENTER);//水平 
				int index = 0;
				if(len == 1&&size<MAXSIZE){
					index = size;
				}else{
					if(ii == len-1){//如果是最后一个sheet
						index = ii*MAXSIZE+(size%MAXSIZE==0?MAXSIZE:size%MAXSIZE);
					}else{
						index = (ii+1)*MAXSIZE;
					}
					
				}
			
				int kk = 0;
				for(int i=ii*MAXSIZE;i<index;i++){
					Row row = sheet.createRow((short) (kk+2));
					List details = detailsList.get(i);
					for(int j=0;j<details.size();j++){
						//sheet.autoSizeColumn(j+1, true);//设置宽度自动变化 
						Object obj = details.get(j);
						Cell icell = row.createCell(j);
						if(obj instanceof Integer){
							icell.setCellValue((Integer)details.get(j));
						}else if(obj instanceof Long){
							icell.setCellValue((Long)details.get(j));
						}else if(obj instanceof Double){				
							icell.setCellValue((Double)details.get(j));
						}else{
							icell.setCellValue((String)details.get(j));
						}	
						icell.setCellStyle(style3);
						
					}	
					
					kk++;
				}
			}
		}
				
		FileOutputStream fileOut = null;
		try {
			fileOut = new FileOutputStream(filePath);
			wb.write(fileOut);
		} catch (FileNotFoundException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			try {
				if(fileOut != null){
					fileOut.close();
					fileOut = null;
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return wb;
	}
}
