package com.xunlei.niux.manager.web.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author hezhong
 */
public class DateUtil {

    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    
	private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss");
	
	private static ThreadLocal<DateFormat> threadLocal = new ThreadLocal<DateFormat>(){
				
		@Override
		protected synchronized DateFormat initialValue() {
			return new SimpleDateFormat(DEFAULT_PATTERN);
		}
	};
	
	public static DateFormat getDateFormat(){
		return threadLocal.get();
	}
	
	public static Date parse(String time) throws ParseException{
		return getDateFormat().parse(time);
	}
	
	public static long parseForTimestamp(String time) throws ParseException{
		return getDateFormat().parse(time).getTime();
	}
	
	public static String getOrderTime(){
		return SDF.format(new Date());
	}

    public static Date yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_YEAR, -1);

        return calendar.getTime();
    }

    public static String formatNow(String pattern) {
       return format(new Date(), pattern);
    }


    public static String formatNowByDefault() {
        return formatNow(DEFAULT_PATTERN);
    }

    public static Date nextYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.YEAR, 1);

        return calendar.getTime();
    }

    public static  String format(Date date, String pattern) {
        DateFormat dateFormat = new SimpleDateFormat(pattern);

        return dateFormat.format(date);
    }

    
    /**
	 * 比较两个时间相隔多少天
	 *  add by lisu 2013-05-08
	 * @param fromtime 格式 yyyy-MM-dd
	 * @param totime   格式 yyyy-MM-dd
	 * @return
	 */
	public static long compareTime(String fromtime,String totime){
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
        Date one = null;
        Date two = null;
        long days=0;  
        try{
        	one = df.parse(fromtime);  
        	two = df.parse(totime); 
        	long time1 = one.getTime();  
        	long time2 = two.getTime();  
        	long diff = time1 - time2;
        	days = diff / (1000 * 60 * 60 * 24);  
        }catch(ParseException  e){
        	e.printStackTrace();  
        }
		return days;
	}

    /**
     * 时间比大小
     * */
    public static int timeCompare(String t1,String t2){
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c1=Calendar.getInstance();
        Calendar c2=Calendar.getInstance();
        try {
            c1.setTime(formatter.parse(t1));
            c2.setTime(formatter.parse(t2));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        int result=c1.compareTo(c2);
        return result;
    }
	
	
	
}
