package com.xunlei.niux.manager.web.util;

import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;

/**
 * 获得账号信息工具类
 * @author lisu
 *  2014-08-04
 */
public class AccountUtil {
	private static UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
	

	/**
	 * 调用远程接口查询用户信息
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_sec getUserInfo(String uid){	
		Resp_getuserinfo_sec userinfosec = userInfoProxy.getuserinfo_sec(uid, (byte)2);
		return userinfosec;
	}
	
	/**
	 * 调用远程接口查询用户基本信息
	 * @param userInfoProxy
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_base getUserBaseInfo(String uid){
		Resp_getuserinfo_base userinfobase = userInfoProxy.getuserinfo_base(uid, (byte)2);
		return userinfobase;
	}
	
	/**
	 * 获得用户名
	 * @param uid
	 * @return
	 */
	public static String getUserName(String uid){
		Resp_getuserinfo_base baseInfo =  getUserBaseInfo(uid);
		return baseInfo.getUsrname();
	}
	
	/**
	 * 获得账号
	 * @param uid
	 * @return
	 */
	public static String getAccount(String uid){
		Resp_getuserinfo_base baseInfo =  getUserBaseInfo(uid);
		return baseInfo.getUserAccount();
	}
	
}
